/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.Registry.SoundRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityPump
extends TileEntityPowerReceiver
implements PipeConnector,
IFluidHandler,
DiscreteFunction {
    private BlockArray blocks = new BlockArray();
    private int soundtick = 200;
    private int damage = 0;
    public int duplicationAmount;
    public static final int CAPACITY = 24000;
    private final HybridTank tank = new HybridTank("pump", 24000);
    public static final int FALLOFF = 256;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.soundtick;
        ++this.tickcount;
        this.getIOSides(world, x, y, z, this.func_145832_p());
        this.getPower(true);
        this.power = (long)this.omega * (long)this.torque;
        Block idbelow = world.func_147439_a(x, y - 1, z);
        if (idbelow == Blocks.field_150350_a) {
            return;
        }
        Fluid f = ReikaFluidHelper.lookupFluidForBlock((Block)idbelow);
        if (f == null) {
            return;
        }
        if (this.blocks.isEmpty()) {
            this.blocks.recursiveAddLiquidWithBounds((IBlockAccess)world, x, y - 1, z, x - 16, y - 2, z - 16, x + 16, y - 1, z + 16, f);
            this.blocks.reverseBlockOrder();
        }
        if (this.damage > 400) {
            this.power = 0L;
        }
        if (this.blocks.isEmpty()) {
            return;
        }
        if (this.power >= this.MINPOWER && this.torque >= this.MINTORQUE && this.getLevel() < 24000 && this.tickcount >= this.getOperationTime()) {
            Coordinate loc = this.blocks.getNextAndMoveOn();
            this.harvest(world, x, y, z, loc);
            this.tickcount = 0;
        }
        if (this.power > this.MINPOWER && this.torque >= this.MINTORQUE && this.soundtick >= 100) {
            this.soundtick = 0;
            SoundRegistry.PUMP.playSoundAtBlock(world, x, y, z, 0.5f, 1.0f);
        }
        if (this.power > this.MINPOWER && this.torque >= this.MINTORQUE) {
            this.suckUpMobs(world, x, y, z);
        }
    }

    private void suckUpMobs(World world, int x, int y, int z) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)(y - 1), (double)z, (double)(x + 1), (double)y, (double)(z + 1));
        List inbox = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : inbox) {
            e.func_70097_a(DamageSource.field_76377_j, 5.0f);
        }
        if (inbox.size() > 0 && !ReikaEntityHelper.allAreDead((List)inbox, (boolean)false)) {
            ++this.damage;
        }
        if (this.damage >= 400) {
            this.breakPump(world, x, y, z);
        }
    }

    public boolean isBroken() {
        return this.damage >= 400;
    }

    private void breakPump(World world, int x, int y, int z) {
        world.func_72908_a((double)x, (double)y, (double)z, "random.break", 1.0f, 1.0f);
    }

    public void harvest(World world, int x, int y, int z, Coordinate loc) {
        if (world.field_72995_K) {
            return;
        }
        FluidStack fs = ReikaWorldHelper.getDrainableFluid((World)world, (int)loc.xCoord, (int)loc.yCoord, (int)loc.zCoord);
        if (fs == null) {
            return;
        }
        if (fs == null || !this.tank.canTakeIn(fs)) {
            return;
        }
        Fluid f = fs.getFluid();
        if (f != FluidRegistry.LAVA || !ReikaWorldHelper.is1p9InfiniteLava((World)world, (int)loc.xCoord, (int)loc.yCoord, (int)loc.zCoord)) {
            world.func_147449_b(loc.xCoord, loc.yCoord, loc.zCoord, Blocks.field_150350_a);
        }
        int mult = 1;
        if (this.canMultiply(f)) {
            if (this.power / this.MINPOWER >= 16L) {
                mult *= 2;
            }
            if (this.power / this.MINPOWER >= 64L) {
                mult *= 2;
            }
            if (this.power / this.MINPOWER >= 256L) {
                mult *= 2;
            }
            if (this.power / this.MINPOWER >= 1024L) {
                mult *= 2;
            }
            if (this.power / this.MINPOWER >= 4096L) {
                mult *= 2;
            }
        }
        if (f.equals(FluidRegistry.WATER)) {
            RotaryAchievements.PUMP.triggerAchievement(this.getPlacer());
        }
        this.duplicationAmount = (int)((float)mult * ConfigRegistry.getFreeWaterProduction());
        this.tank.addLiquid(fs.amount * mult, f);
        world.func_147471_g(loc.xCoord, loc.yCoord, loc.zCoord);
    }

    private boolean canMultiply(Fluid fluid) {
        return fluid.equals(FluidRegistry.WATER);
    }

    public boolean isSource(World world, int x, int y, int z) {
        Block liqid = world.func_147439_a(x, y, z);
        if (!(liqid instanceof BlockFluidBase) && !(liqid instanceof BlockLiquid)) {
            return false;
        }
        boolean srcmeta = liqid instanceof BlockFluidFinite ? world.func_72805_g(x, y, z) == 7 : world.func_72805_g(x, y, z) == 0;
        Fluid f2 = ReikaFluidHelper.lookupFluidForBlock((Block)liqid);
        Fluid f = this.tank.getActualFluid();
        if (f2 == null) {
            return false;
        }
        boolean liq = f2.equals(f) || f == null;
        return srcmeta && liq;
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 1: {
                this.read = ForgeDirection.EAST;
                this.read2 = ForgeDirection.WEST;
                break;
            }
            case 0: {
                this.read = ForgeDirection.NORTH;
                this.read2 = ForgeDirection.SOUTH;
            }
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
        NBT.func_74768_a("dmg", this.damage);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
        this.damage = NBT.func_74762_e("dmg");
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.PUMP;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return side.offsetY == 0;
    }

    @Override
    public void onEMP() {
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from.offsetY != 0) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.offsetY == 0 && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int getLevel() {
        return this.tank.getLevel();
    }

    public Fluid getLiquid() {
        return this.tank.getActualFluid();
    }

    public void removeLiquid(int amt) {
        this.tank.removeLiquid(amt);
    }

    public void setEmpty() {
        this.tank.empty();
    }

    public void addLiquid(int amt, Fluid f) {
        this.tank.addLiquid(amt, f);
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side.offsetY == 0 ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.NONE;
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.PUMP.getOperationTime(this.omega);
    }

    public int getMaxBackPressure() {
        return 1000 * (1 + ReikaMathLibrary.logbase2((long)(this.torque / this.MINTORQUE)));
    }
}

