/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.DragonAPI.Extras.IconPrefabs;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.RotaryCraft.API.Interfaces.RefrigeratorAttachment;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Auxiliary.Interfaces.ProcessingMachine;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerLiquidProducer;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.PacketRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityRefrigerator
extends InventoriedPowerLiquidProducer
implements MultiOperational,
ProcessingMachine,
BreakAction {
    public int time;
    private StepTimer timer = new StepTimer(20);
    private StepTimer soundTimer = new StepTimer(20);
    private final RefrigeratorAttachment[] attachments = new RefrigeratorAttachment[6];

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        this.timer.setCap(this.getOperationTime());
        if (this.canProgress()) {
            this.soundTimer.update();
            if (this.soundTimer.checkCap()) {
                SoundRegistry.FRIDGE.playSoundAtBlock(world, x, y, z, RotaryAux.isMuffled((TileEntity)this) ? 0.25f : 1.0f, 0.88f);
            }
        } else {
            this.soundTimer.reset();
        }
        int n = this.getNumberConsecutiveOperations();
        for (int i = 0; i < n; ++i) {
            this.doOperation(n > 1);
        }
        if (!world.field_72995_K) {
            this.time = this.timer.getTick();
        }
    }

    private void doOperation(boolean multiple) {
        if (this.canProgress()) {
            this.timer.update();
            if ((multiple || this.timer.checkCap()) && !this.field_145850_b.field_72995_K) {
                this.cycle();
            }
        } else {
            this.timer.reset();
        }
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 0: {
                this.read = ForgeDirection.EAST;
                break;
            }
            case 1: {
                this.read = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.NORTH;
            }
        }
    }

    private boolean canProgress() {
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return false;
        }
        if (this.inv[0] == null) {
            return false;
        }
        if (!this.tank.canTakeIn(this.getProducedLN2())) {
            return false;
        }
        return ReikaItemHelper.matchStackWithBlock((ItemStack)this.inv[0], (Block)Blocks.field_150432_aD) && (this.inv[1] == null || this.inv[1].field_77994_a < this.inv[1].func_77976_d());
    }

    private void cycle() {
        ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
        int amt = this.getProducedLN2();
        this.tank.addLiquid(amt, FluidRegistry.getFluid((String)"rc liquid nitrogen"));
        if (amt > 0) {
            for (RefrigeratorAttachment r : this.attachments) {
                if (r == null) continue;
                r.onCompleteCycle(amt);
            }
            if (rand.nextInt(4) == 0) {
                int n;
                int n2 = rand.nextInt(20) == 0 ? 4 : (n = rand.nextInt(4) == 0 ? 2 : 1);
                if (this.inv[1] != null) {
                    n = Math.min(n, ItemStacks.dryice.func_77976_d() - this.inv[1].field_77994_a);
                }
                ReikaInventoryHelper.addOrSetStack((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.dryice, (int)n), (ItemStack[])this.inv, (int)1);
            }
        }
    }

    private int getProducedLN2() {
        int over = this.torque / this.MINTORQUE;
        return Math.min(2000, 100 * over * over);
    }

    public void setLevel(int lvl) {
        if (!this.tank.isEmpty()) {
            this.tank.setContents(lvl, this.tank.getActualFluid());
        }
    }

    public int getProgressScaled(int a) {
        return this.time * a / this.getOperationTime();
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 1;
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 0 && ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150432_aD);
    }

    @Override
    public boolean canOutputTo(ForgeDirection to) {
        return true;
    }

    @Override
    public int getCapacity() {
        return 12000;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.REFRIGERATOR;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.REFRIGERATOR.getOperationTime(this.omega);
    }

    @Override
    public int getNumberConsecutiveOperations() {
        return DurationRegistry.REFRIGERATOR.getNumberOperations(this.omega);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.time = NBT.func_74762_e("timer");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("timer", this.time);
    }

    public int getLiquidScaled(int i) {
        return this.tank.getLevel() * i / this.tank.getCapacity();
    }

    public void addAttachment(RefrigeratorAttachment te, ForgeDirection dir) {
        this.attachments[dir.ordinal()] = te;
    }

    protected void onPlacedNextToThis(TileEntity te, ForgeDirection dir) {
        this.attachments[dir.ordinal()] = null;
    }

    public void breakBlock() {
        float f = this.tank.getFraction();
        if ((double)f > 0.1) {
            ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.fizz", (float)1.2f, (float)0.8f);
            float hearts = f * 4.0f;
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(5.0, 5.0, 5.0);
            List li = this.field_145850_b.func_72872_a(EntityLivingBase.class, box);
            RotaryCraft.freezeDamage.lastMachine = this;
            for (EntityLivingBase e : li) {
                e.func_70097_a((DamageSource)RotaryCraft.freezeDamage, hearts * 2.0f);
            }
            ReikaPacketHelper.sendDataPacketWithRadius((String)"RotaryCraftData", (int)PacketRegistry.FRIDGEBREAK.ordinal(), (TileEntity)this, (int)24, (int[])new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void doBreakFX(World world, int x, int y, int z) {
        for (int i = 0; i < 15; ++i) {
            double dx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            double dz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            double dy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.25);
            double v = 0.04;
            EntityBlurFX fx = new EntityBlurFX(world, (double)x + 0.5 + dx, (double)y + 0.5 + dy, (double)z + 0.5 + dz, dx * v, dy * v, dz * v, IconPrefabs.FADE_GENTLE.getIcon());
            fx.setColor(0xBFB2FF).setScale(3.0f + rand.nextFloat() * 2.0f).setRapidExpand().setAlphaFading().setLife(30 + rand.nextInt(31)).setColliding();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean hasWork() {
        return this.areConditionsMet();
    }

    @Override
    public boolean areConditionsMet() {
        return this.inv[0] != null && ReikaItemHelper.matchStackWithBlock((ItemStack)this.inv[0], (Block)Blocks.field_150432_aD);
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Ice";
    }
}

