/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Storage;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.NBTMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFluidCompressor
extends TileEntityPowerReceiver
implements IFluidHandler,
PipeConnector,
NBTMachine {
    private final HybridTank tank = new HybridTank("gastank", 1000000000);
    private int timer = 0;
    private static final ArrayList<Fluid> creativeFluids = new ArrayList();

    public int getCapacity() {
        return this.tank.isEmpty() ? 0 : this.getCapacity(this.tank.getActualFluid());
    }

    public int getCapacity(Fluid f) {
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return 0;
        }
        int log2 = (int)(ReikaMathLibrary.logbase((long)this.torque, (int)2) / 2.0);
        long power = ReikaMathLibrary.longpow((int)10, (int)log2);
        int factor = f.isGaseous() ? 8 : 1;
        long frac = (long)factor * (power / 40L);
        return (int)Math.min(frac, (long)this.tank.getCapacity());
    }

    public Fluid getFluid() {
        return this.tank.getActualFluid();
    }

    public boolean isEmpty() {
        return this.tank.isEmpty();
    }

    public int getLevel() {
        return this.tank.getLevel();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.GASTANK;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.getFluid() == null) {
            return 0;
        }
        int toadd = Math.min(resource.amount, this.getCapacity(resource.getFluid()) - this.tank.getLevel());
        if (toadd <= 0) {
            return 0;
        }
        FluidStack fs = new FluidStack(resource.getFluid(), toadd);
        return this.canFill(from, resource.getFluid()) ? this.tank.fill(fs, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe() || m == MachineRegistry.HOSE || m == MachineRegistry.FUELLINE || m == MachineRegistry.VALVE;
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p);
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == ForgeDirection.UP ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.INPUT;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
    }

    @Override
    public NBTTagCompound getTagsToWriteToStack() {
        if (this.isEmpty()) {
            return null;
        }
        NBTTagCompound NBT = new NBTTagCompound();
        Fluid f = this.getFluid();
        int level = this.getLevel();
        ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)NBT, (Fluid)f);
        NBT.func_74768_a("lvl", level);
        return NBT;
    }

    @Override
    public void setDataFromItemStackTag(NBTTagCompound NBT) {
        if (NBT == null) {
            this.tank.empty();
            return;
        }
        Fluid f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)NBT);
        int level = NBT.func_74762_e("lvl");
        if (f != null && level > 0) {
            this.tank.setContents(level, f);
        }
    }

    @Override
    public ArrayList<NBTTagCompound> getCreativeModeVariants() {
        ArrayList<NBTTagCompound> li = new ArrayList<NBTTagCompound>();
        li.add(null);
        for (int i = 0; i < creativeFluids.size(); ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("lvl", 1000000000);
            ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)nbt, (Fluid)creativeFluids.get(i));
            li.add(nbt);
        }
        return li;
    }

    public static void initCreativeFluids() {
        creativeFluids.clear();
        TileEntityFluidCompressor.addCreativeFluid("hydrofluoric acid");
        TileEntityFluidCompressor.addCreativeFluid("uranium hexafluoride");
        TileEntityFluidCompressor.addCreativeFluid("rc ammonia");
        TileEntityFluidCompressor.addCreativeFluid("rc chlorine");
        TileEntityFluidCompressor.addCreativeFluid("rc co2");
        TileEntityFluidCompressor.addCreativeFluid("rc oxygen");
        TileEntityFluidCompressor.addCreativeFluid("rc deuterium");
        TileEntityFluidCompressor.addCreativeFluid("rc tritium");
    }

    private static void addCreativeFluid(String name) {
        Fluid f = FluidRegistry.getFluid((String)name);
        if (f != null) {
            creativeFluids.add(f);
        }
    }

    @Override
    public ArrayList<String> getDisplayTags(NBTTagCompound nbt) {
        ArrayList<String> li = new ArrayList<String>();
        Fluid f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)nbt);
        if (f != null) {
            String fluid = f.getLocalizedName();
            int amt = nbt.func_74762_e("lvl");
            if (amt > 0) {
                String amount = String.format("%d", amt / 1000);
                String contents = "Contents: " + amount + "B of " + fluid;
                li.add(contents);
            }
        }
        return li;
    }
}

