/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Surveying;

import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Renders.M.RenderCaveFinder;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCaveFinder
extends TileEntityPowerReceiver
implements RangedEffect {
    private int[] src = new int[3];
    private int rendermode = 0;
    public String owner;
    public boolean on;
    private boolean[][][] points = new boolean[this.getRange() * 2 + 1][this.getRange() * 2 + 1][this.getRange() * 2 + 1];
    private boolean needsCalc = true;
    private Scanner scanner = new Scanner(this);

    protected void onFirstTick(World world, int x, int y, int z) {
        if (this.src[0] == 0 && this.src[1] == 0 && this.src[2] == 0) {
            this.setSrc(x, y, z);
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getSummativeSidedPower();
        if (this.power < this.MINPOWER) {
            this.on = false;
            return;
        }
        this.on = true;
        if (this.rendermode != 0 && this.rendermode == 1) {
            EntityPlayer ep = world.func_72977_a((double)x, (double)y, (double)z, -1.0);
            if (ep == null) {
                return;
            }
            int px = (int)ep.field_70165_t;
            int py = (int)ep.field_70163_u;
            int pz = (int)ep.field_70161_v;
            this.setSrc(px, py, pz);
        }
        int t = this.getUpdateFrequency();
        if (this.needsCalc || (world.func_82737_E() & (long)t) == 0L) {
            this.calculatePoints();
        }
    }

    private int getUpdateFrequency() {
        int r = this.getRange();
        if (r < 16) {
            return 1;
        }
        if (r < 32) {
            return 3;
        }
        if (r < 64) {
            return 7;
        }
        if (r < 128) {
            return 15;
        }
        return 31;
    }

    private void calculatePoints() {
        Thread t = new Thread(this.scanner);
        t.start();
        this.needsCalc = false;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            RenderCaveFinder rcf = (RenderCaveFinder)this.getRenderer();
            rcf.removeListFor(this);
        }
    }

    public boolean hasPointAt(int dx, int dy, int dz) {
        int r = this.getRange();
        if (Math.abs(dx) > r * 2 || Math.abs(dy) > r * 2 || Math.abs(dz) > r * 2) {
            return false;
        }
        if (Math.abs(dx) < 0 || Math.abs(dy) < 0 || Math.abs(dz) < 0) {
            return false;
        }
        try {
            return this.points[dx][dy][dz];
        }
        catch (Exception e) {
            RotaryCraft.logger.logError((Object)("Exception at " + dx + ", " + dy + ", " + dz + "!"));
            return false;
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public double func_145833_n() {
        return 65536.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public int getRange() {
        return Math.max(4, ConfigRegistry.CAVEFINDERRANGE.getValue());
    }

    public int getSourceX() {
        return this.src[0];
    }

    public int getSourceY() {
        return this.src[1];
    }

    public int getSourceZ() {
        return this.src[2];
    }

    public void setSrc(int x, int y, int z) {
        this.src[0] = x;
        this.src[1] = y;
        this.src[2] = z;
        this.needsCalc = true;
    }

    public void moveSrc(int num, ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                this.src[1] = this.src[1] - num;
                break;
            }
            case UP: {
                this.src[1] = this.src[1] + num;
                break;
            }
            case WEST: {
                this.src[0] = this.src[0] - num;
                break;
            }
            case EAST: {
                this.src[0] = this.src[0] + num;
                break;
            }
            case NORTH: {
                this.src[2] = this.src[2] - num;
                break;
            }
            case SOUTH: {
                this.src[2] = this.src[2] + num;
                break;
            }
        }
        this.needsCalc = true;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74783_a("Source", this.src);
        NBT.func_74757_a("calc", this.needsCalc);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.src = NBT.func_74759_k("Source");
        this.needsCalc = NBT.func_74767_n("calc");
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.CAVESCANNER;
    }

    @Override
    public int getMaxRange() {
        return 128;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    private final class Scanner
    implements Runnable {
        private final TileEntityCaveFinder tile;

        private Scanner(TileEntityCaveFinder te) {
            this.tile = te;
        }

        @Override
        public void run() {
            int r = this.tile.getRange();
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    for (int k = -r; k <= r; ++k) {
                        int z;
                        int y;
                        int x = this.tile.getSourceX() + i;
                        ((TileEntityCaveFinder)this.tile).points[i + r][j + r][k + r] = ReikaWorldHelper.cornerHasAirAdjacent((World)TileEntityCaveFinder.this.field_145850_b, (int)x, (int)(y = this.tile.getSourceY() + j), (int)(z = this.tile.getSourceZ() + k));
                    }
                }
            }
        }
    }
}

