/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Surveying;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.BlockColorMapper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.RemoteControlMachine;
import Reika.RotaryCraft.Registry.GuiRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntitySpyCam
extends RemoteControlMachine
implements RangedEffect {
    private int tickcount2 = 0;
    public static final int MAXRANGE = 24;
    private BlockKey[][] topBlocks = new BlockKey[49][49];
    private int[][] mobs = new int[49][49];
    private int[][] topY = new int[49][49];
    private List<EntityLivingBase> inzone;

    public List<EntityLivingBase> getEntities() {
        return Collections.unmodifiableList(this.inzone);
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.SPYCAM;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.setColors();
        if (!this.hasCoil()) {
            this.on = false;
            return;
        }
        this.on = true;
        ++this.tickcount2;
        if (!DragonAPICore.debugtest) {
            int dmg = this.inv[0].func_77960_j();
            if (this.tickcount2 > this.getUnwindTime()) {
                ItemStack is;
                this.inv[0] = is = this.getDecrementedCharged();
                this.tickcount2 = 0;
            }
        }
        this.getTopBlocks(world, x, y, z);
        this.getMobs(world, x, y, z);
    }

    private void getMobs(World world, int x, int y, int z) {
        this.mobs = ReikaArrayHelper.fillMatrix((int[][])this.mobs, (int)0);
        int range = this.getRange();
        int maxrange = this.getMaxRange();
        AxisAlignedBB zone = AxisAlignedBB.func_72330_a((double)(x - range), (double)0.0, (double)(z - range), (double)(x + 1 + range), (double)(y + 1), (double)(z + 1 + range));
        this.inzone = world.func_72872_a(EntityLivingBase.class, zone);
        for (EntityLivingBase ent : this.inzone) {
            int ex = (int)ent.field_70165_t - x;
            int ey = (int)ent.field_70163_u - y;
            int ez = (int)ent.field_70161_v - z;
            if (EntityList.func_75619_a((Entity)ent) <= 0 || Math.abs(ex) >= range + 1 || Math.abs(ez) >= range + 1 || !(ent.field_70163_u >= (double)ReikaWorldHelper.findTopBlockBelowY((World)world, (int)((int)ent.field_70165_t), (int)y, (int)((int)ent.field_70161_v)))) continue;
            this.mobs[ez + range][ex + range] = EntityList.func_75619_a((Entity)ent);
        }
    }

    private void getTopBlocks(World world, int x, int y, int z) {
        int range = this.getRange();
        int maxrange = this.getMaxRange();
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                int topy;
                this.topY[i + range][j + range] = topy = ReikaWorldHelper.findTopBlockBelowY((World)world, (int)(x + i), (int)y, (int)(z + j));
                Block b = world.func_147439_a(x + i, topy, z + j);
                int meta = world.func_72805_g(x + i, topy, z + j);
                if (world.field_72995_K) {
                    this.topBlocks[i + range][j + range] = new BlockKey(b, meta);
                }
                if (world.func_147439_a(x + i, y, z + j) == Blocks.field_150350_a) continue;
            }
        }
    }

    public int[] getBounds() {
        int range = this.getRange();
        int mrange = this.getMaxRange();
        int[] bounds = new int[]{mrange - range, mrange + range};
        return bounds;
    }

    public int getMobAt(int i, int j) {
        return this.mobs[i][j];
    }

    @SideOnly(value=Side.CLIENT)
    public int getTopBlockColorAt(int i, int j) {
        return BlockColorMapper.instance.getColorForBlock(this.topBlocks[i][j]);
    }

    public int getHeightAt(int i, int j) {
        return this.topY[i][j];
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public int getRange() {
        return this.getMaxRange();
    }

    @Override
    public int getMaxRange() {
        return 24;
    }

    @Override
    public void activate(World world, EntityPlayer ep, int x, int y, int z) {
        if (this.on) {
            ep.openGui((Object)RotaryCraft.instance, GuiRegistry.SPYCAM.ordinal(), world, x, y, z);
        }
    }
}

