/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.RotaryCraft.Auxiliary.EntityEnderFX;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.init.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class TileEntityChunkLoader
extends TileEntityPowerReceiver
implements ChunkLoadingTile,
BreakAction,
RangedEffect {
    private boolean loaded;
    public static final int BASE_RADIUS = 0;
    public static final int FALLOFF = 524288;
    public static final int MAX_RADIUS = ConfigRegistry.CHUNKLOADERSIZE.getValue();

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        if (!world.field_72995_K) {
            if (this.omega >= this.MINSPEED) {
                this.load();
            } else {
                this.unload();
            }
        } else if (this.omega >= this.MINSPEED) {
            this.doParticles(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        double[] r = new double[]{0.3125, 0.25, 0.1875, 0.125};
        double[] h = new double[]{0.25, 0.4375, 0.625, 0.8125};
        for (int i = 0; i < 4; ++i) {
            double a = (float)(4 - i) * this.phi + 40.0f;
            double dr = r[i] + 0.0625;
            double px = (double)x + 0.5 + dr * Math.cos(Math.toRadians(a));
            double pz = (double)z + 0.5 + dr * Math.sin(Math.toRadians(a));
            double py = (double)y + h[i];
            double vy = 0.0625;
            float s = 0.375f;
            EntityEnderFX fx = new EntityEnderFX(world, px, py, pz, 0.0, vy, 0.0, 0xFFFFFF).setRapidExpand().setScale(s).setIcon(Items.field_151156_bN.func_77617_a(0));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            px = (double)x + 0.5 + dr * Math.cos(Math.toRadians(a += 180.0));
            pz = (double)z + 0.5 + dr * Math.sin(Math.toRadians(a));
            fx = new EntityEnderFX(world, px, py, pz, 0.0, vy, 0.0, 0xFFFFFF).setRapidExpand().setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        ChunkManager.instance.loadChunks((ChunkLoadingTile)this);
    }

    private void unload() {
        if (this.loaded) {
            this.loaded = false;
            ChunkManager.instance.unloadChunks((TileEntity)this);
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (this.omega > 0) {
            this.phi = (float)((double)this.phi - 0.25 * ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2));
        }
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        if (world.field_72995_K) {
            return;
        }
        if (invalid) {
            this.unload();
        }
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.CHUNKLOADER;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public Collection<ChunkCoordIntPair> getChunksToLoad() {
        return ChunkManager.getChunkSquare((int)this.field_145851_c, (int)this.field_145849_e, (int)this.getLoadingRadius());
    }

    private int getLoadingRadius() {
        return Math.min(MAX_RADIUS, 0 + (int)(this.power - (long)this.MINSPEED) / 524288);
    }

    public void breakBlock() {
        if (!this.field_145850_b.field_72995_K) {
            this.unload();
        }
    }

    @Override
    public int getRange() {
        return this.getLoadingRadius() * 16;
    }

    @Override
    public int getMaxRange() {
        return MAX_RADIUS * 16;
    }
}

