/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.DragonAPI.Base.OneSlotMachine;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntitySpringPowered;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class TileEntitySmokeDetector
extends TileEntitySpringPowered
implements RangedEffect,
OneSlotMachine {
    private boolean isAlarm = false;
    private boolean isLowBatt = false;
    private int unwindtick = 0;
    public int soundDelay = -1;

    public boolean isAlarming() {
        return this.isAlarm;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        ++this.tickcount;
        ++this.unwindtick;
        if (!this.checkValidCoil()) {
            return;
        }
        if (this.unwindtick >= this.getUnwindTime()) {
            this.inv[0] = this.getDecrementedCharged();
            this.unwindtick = 0;
        }
        if (ReikaWorldHelper.findNearBlock((World)world, (int)x, (int)y, (int)z, (int)8, (Block)Blocks.field_150480_ab)) {
            if (!this.isAlarm) {
                this.isAlarm = true;
                ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
            }
        } else if (this.isAlarm) {
            this.isAlarm = false;
            ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
        }
        this.isLowBatt = this.lowBattery();
        this.soundDelay = this.isAlarm ? 4 : (this.isLowBatt ? 600 : -1);
        if (this.tickcount >= this.soundDelay && this.soundDelay != -1) {
            this.tickcount = 0;
            SoundRegistry.SMOKE.playSoundAtBlock(world, x, y, z, 0.1f, 1.0f);
        }
    }

    public boolean checkValidCoil() {
        return this.hasCoil();
    }

    @Override
    public int getRange() {
        if (!this.checkValidCoil()) {
            return 0;
        }
        int dmg = this.inv[0].func_77960_j();
        int overpower = (int)ReikaMathLibrary.logbase((long)(dmg * dmg), (int)2);
        if (overpower > 8) {
            return 8;
        }
        return overpower;
    }

    public boolean lowBattery() {
        if (!this.checkValidCoil()) {
            return false;
        }
        return this.inv[0].func_77960_j() <= 8;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.SMOKEDETECTOR;
    }

    @Override
    public int getMaxRange() {
        return this.getRange();
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public int getBaseDischargeTime() {
        return 1200;
    }
}

