/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.DragonAPI.Instantiable.Data.Immutable.InventorySlot;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySorting
extends TileEntityPowerReceiver {
    public static final int LENGTH = 9;
    private ForgeDirection facingDir;
    private ItemStack[] mappings = new ItemStack[27];

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if (!world.field_72995_K && this.power >= this.MINPOWER) {
            List<ItemCallback> li = this.getItems(world, x, y, z);
            this.sortItems(world, x, y, z, li);
        }
    }

    private List<ItemCallback> getItems(World world, int x, int y, int z) {
        TileEntity te = this.getAdjacentTileEntity(ForgeDirection.UP);
        ArrayList<ItemCallback> li = new ArrayList<ItemCallback>();
        if (te instanceof IInventory) {
            IInventory ii = (IInventory)te;
            for (int i = 0; i < ii.func_70302_i_(); ++i) {
                ItemStack in = ii.func_70301_a(i);
                if (in == null) continue;
                li.add(new InventoryItemCallback(ii, i));
            }
        } else {
            AxisAlignedBB box = this.getBox();
            List items = world.func_72872_a(EntityItem.class, box);
            for (EntityItem ei : items) {
                if (ei.field_70128_L) continue;
                li.add(new EntityItemCallback(ei));
            }
        }
        return li;
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 0: {
                this.facingDir = ForgeDirection.EAST;
                break;
            }
            case 1: {
                this.facingDir = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.facingDir = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                this.facingDir = ForgeDirection.SOUTH;
            }
        }
        this.read = this.facingDir;
    }

    private void sortItems(World world, int x, int y, int z, List<ItemCallback> li) {
        int n = this.getNumberCyclesPerTick();
        for (ItemCallback ei : li) {
            ItemStack is = ei.getStack();
            for (int i = 0; i < n && is.field_77994_a > 0; ++i) {
                if (is.field_77994_a <= 1) {
                    ei.destroy();
                }
                --is.field_77994_a;
                ForgeDirection dir = this.getSideForItem(is);
                this.dumpItem(world, x, y, z, is, dir);
            }
        }
    }

    private int getNumberCyclesPerTick() {
        long frac = this.power / this.MINPOWER;
        if (frac == 1L) {
            return 1;
        }
        if (frac >= 16L) {
            return 64;
        }
        if (frac >= 12L) {
            return 32;
        }
        if (frac >= 8L) {
            return 16;
        }
        if (frac >= 4L) {
            return 4;
        }
        if (frac >= 2L) {
            return 2;
        }
        return 1;
    }

    private void dumpItem(World world, int x, int y, int z, ItemStack is, ForgeDirection dir) {
        ItemStack drop = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)1);
        TileEntity te = this.getAdjacentTileEntity(dir);
        if (te instanceof IInventory && ReikaInventoryHelper.addToIInv((ItemStack)drop, (IInventory)((IInventory)te))) {
            return;
        }
        double dx = (double)x + 0.5 + (double)dir.offsetX * 0.75;
        double dy = (double)y + 0.5 + (double)dir.offsetY * 0.75;
        double dz = (double)z + 0.5 + (double)dir.offsetZ * 0.75;
        EntityItem e = new EntityItem(world, dx, dy, dz, drop);
        double v = 0.1;
        e.field_70159_w = (double)dir.offsetX * v;
        e.field_70181_x = (double)dir.offsetY * v;
        e.field_70179_y = (double)dir.offsetZ * v;
        world.func_72838_d((Entity)e);
    }

    private ForgeDirection getSideForItem(ItemStack is) {
        for (int k = 0; k < this.mappings.length; ++k) {
            ItemStack map = this.mappings[k];
            if (map == null) continue;
            Item item = is.func_77973_b();
            Item item2 = map.func_77973_b();
            if (!(item.func_77614_k() || item2.func_77614_k() ? ReikaItemHelper.matchStacks((ItemStack)map, (ItemStack)is) : is.func_77973_b() == map.func_77973_b())) continue;
            return this.getDirection(k);
        }
        return ForgeDirection.DOWN;
    }

    private ForgeDirection getDirection(int index) {
        index /= 9;
        ArrayList<ForgeDirection> li = new ArrayList<ForgeDirection>();
        for (int i = 2; i < 6; ++i) {
            li.add(this.dirs[i]);
        }
        li.remove(this.facingDir);
        return (ForgeDirection)li.get(index);
    }

    private ForgeDirection getFacingDir(int meta) {
        switch (meta) {
            case 0: {
                return ForgeDirection.EAST;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.DOWN;
    }

    private AxisAlignedBB getBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 1.25), (double)(this.field_145849_e + 1));
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.SORTING;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public boolean setMapping(int index, ItemStack item) {
        if (item == null) {
            this.mappings[index] = null;
            return true;
        }
        if (this.isValidForSlot(index, item)) {
            Item i = item.func_77973_b();
            this.mappings[index] = i.func_77614_k() ? new ItemStack(item.func_77973_b(), 1, item.func_77960_j()) : new ItemStack(item.func_77973_b(), 1, 0);
            return true;
        }
        return false;
    }

    public ItemStack getMapping(int index) {
        return this.mappings[index];
    }

    private boolean isValidForSlot(int index, ItemStack item) {
        for (int i = 0; i < this.mappings.length; ++i) {
            ItemStack is = this.mappings[i];
            if (is == null || !ReikaItemHelper.matchStacks((ItemStack)item, (ItemStack)is)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        NBTTagList nbttaglist = NBT.func_150295_c("Items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        this.mappings = new ItemStack[27];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.mappings.length) continue;
            this.mappings[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.mappings.length; ++i) {
            if (this.mappings[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.mappings[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        NBT.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public static byte getSlot(int col, int side) {
        return (byte)(side * 3 + col);
    }

    public static int[] getParams(int slot) {
        int l = 9;
        int[] p = new int[]{slot % l, slot / l};
        return p;
    }

    @Override
    public int getTextureStateForSide(int s) {
        switch (this.func_145832_p()) {
            case 0: {
                switch (s) {
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 3;
                    }
                    case 5: {
                        return 0;
                    }
                }
                break;
            }
            case 1: {
                switch (s) {
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 0;
                    }
                    case 5: {
                        return 3;
                    }
                }
                break;
            }
            case 2: {
                switch (s) {
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                    case 4: {
                        return 2;
                    }
                    case 5: {
                        return 3;
                    }
                }
                break;
            }
            case 3: {
                switch (s) {
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                    case 4: {
                        return 2;
                    }
                    case 5: {
                        return 3;
                    }
                }
            }
        }
        return 0;
    }

    private static class InventoryItemCallback
    implements ItemCallback {
        private final InventorySlot slot;

        private InventoryItemCallback(IInventory ii, int slot) {
            this.slot = new InventorySlot(slot, ii);
        }

        @Override
        public void destroy() {
            this.slot.setSlot(null);
        }

        @Override
        public ItemStack getStack() {
            return this.slot.getStack();
        }
    }

    private static class EntityItemCallback
    implements ItemCallback {
        private final EntityItem item;

        private EntityItemCallback(EntityItem ei) {
            this.item = ei;
        }

        @Override
        public void destroy() {
            this.item.func_70106_y();
        }

        @Override
        public ItemStack getStack() {
            return this.item.func_92059_d();
        }
    }

    private static interface ItemCallback {
        public void destroy();

        public ItemStack getStack();
    }
}

