/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.RotaryCraft.API.Interfaces.ComplexIO;
import Reika.RotaryCraft.API.Power.PowerAcceptor;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntity1DTransmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityTransmissionMachine;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import com.google.common.collect.HashBiMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TileEntityBevelGear
extends TileEntity1DTransmitter
implements GuiController {
    private static final HashBiMap<Integer, ImmutablePair<ForgeDirection, ForgeDirection>> directions = HashBiMap.create();
    public int direction;

    private static void registerDirectionValue(int value) {
        ForgeDirection read = null;
        ForgeDirection write = null;
        switch (value) {
            case 0: {
                read = ForgeDirection.WEST;
                write = ForgeDirection.NORTH;
                break;
            }
            case 1: {
                read = ForgeDirection.NORTH;
                write = ForgeDirection.EAST;
                break;
            }
            case 2: {
                read = ForgeDirection.EAST;
                write = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                read = ForgeDirection.SOUTH;
                write = ForgeDirection.WEST;
                break;
            }
            case 4: {
                read = ForgeDirection.WEST;
                write = ForgeDirection.SOUTH;
                break;
            }
            case 5: {
                read = ForgeDirection.NORTH;
                write = ForgeDirection.WEST;
                break;
            }
            case 6: {
                write = ForgeDirection.NORTH;
                read = ForgeDirection.EAST;
                break;
            }
            case 7: {
                read = ForgeDirection.SOUTH;
                write = ForgeDirection.EAST;
                break;
            }
            case 8: {
                read = ForgeDirection.WEST;
                write = ForgeDirection.UP;
                break;
            }
            case 9: {
                read = ForgeDirection.NORTH;
                write = ForgeDirection.UP;
                break;
            }
            case 10: {
                read = ForgeDirection.EAST;
                write = ForgeDirection.UP;
                break;
            }
            case 11: {
                read = ForgeDirection.SOUTH;
                write = ForgeDirection.UP;
                break;
            }
            case 12: {
                read = ForgeDirection.DOWN;
                write = ForgeDirection.WEST;
                break;
            }
            case 13: {
                read = ForgeDirection.DOWN;
                write = ForgeDirection.NORTH;
                break;
            }
            case 14: {
                read = ForgeDirection.DOWN;
                write = ForgeDirection.EAST;
                break;
            }
            case 15: {
                read = ForgeDirection.DOWN;
                write = ForgeDirection.SOUTH;
                break;
            }
            case 16: {
                write = ForgeDirection.DOWN;
                read = ForgeDirection.WEST;
                break;
            }
            case 17: {
                write = ForgeDirection.DOWN;
                read = ForgeDirection.NORTH;
                break;
            }
            case 18: {
                write = ForgeDirection.DOWN;
                read = ForgeDirection.EAST;
                break;
            }
            case 19: {
                write = ForgeDirection.DOWN;
                read = ForgeDirection.SOUTH;
                break;
            }
            case 20: {
                read = ForgeDirection.UP;
                write = ForgeDirection.WEST;
                break;
            }
            case 21: {
                read = ForgeDirection.UP;
                write = ForgeDirection.NORTH;
                break;
            }
            case 22: {
                read = ForgeDirection.UP;
                write = ForgeDirection.EAST;
                break;
            }
            case 23: {
                read = ForgeDirection.UP;
                write = ForgeDirection.SOUTH;
            }
        }
        TileEntityBevelGear.registerDirection(read, write);
    }

    private static void registerDirection(ForgeDirection read, ForgeDirection write) {
        int idx = directions.size();
        directions.put((Object)idx, (Object)new ImmutablePair((Object)read, (Object)write));
        RotaryCraft.logger.log((Object)("Registered bevel direction #" + idx + ": " + read + " to " + write));
    }

    public static HashBiMap<Integer, ImmutablePair<ForgeDirection, ForgeDirection>> getDirectionMap() {
        return HashBiMap.create(directions);
    }

    public static boolean isValid(ForgeDirection read, ForgeDirection write) {
        return directions.inverse().containsKey((Object)new ImmutablePair((Object)read, (Object)write));
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        if (this.getTileEntityAge() == 0L) {
            this.findRoute(world, x, y, z);
        }
        this.power = (long)this.omega * (long)this.torque;
        this.getIOSides(world, x, y, z);
        this.transferPower(world, x, y, z, meta);
        this.basicPowerReceiver();
    }

    private void findRoute(World world, int x, int y, int z) {
        ForgeDirection write = null;
        ForgeDirection read = null;
        for (int i = 0; i < 6; ++i) {
            TileEntity te = this.getAdjacentTileEntity(this.dirs[i]);
            if (te instanceof TileEntityIOMachine) {
                TileEntityIOMachine io = (TileEntityIOMachine)te;
                if (read == null && (io.isWritingToCoordinate(x, y, z) || io.isWritingToCoordinate2(x, y, z))) {
                    read = this.dirs[i];
                }
                if (write != null || !io.isReadingFrom(this) && !io.isReadingFrom2(this) && !io.isReadingFrom3(this) && !io.isReadingFrom4(this)) continue;
                write = this.dirs[i];
                continue;
            }
            if (!(te instanceof PowerAcceptor) || write != null || !((PowerAcceptor)te).canReadFrom(this.dirs[i].getOpposite())) continue;
            write = this.dirs[i];
        }
        if (write != null && read != null && read != write && read != write.getOpposite()) {
            this.direction = (Integer)directions.inverse().get((Object)new ImmutablePair(read, write));
        }
    }

    public void getIOSides(World world, int x, int y, int z) {
        ImmutablePair dirs = (ImmutablePair)directions.get((Object)this.direction);
        this.read = (ForgeDirection)dirs.left;
        this.write = (ForgeDirection)dirs.right;
    }

    @Override
    protected void transferPower(World world, int x, int y, int z, int meta) {
        TileEntity te;
        if (this.field_145850_b.field_72995_K && !RotaryAux.getPowerOnClient) {
            return;
        }
        this.torquein = 0;
        this.omegain = 0;
        boolean isCentered = x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e;
        int dx = x + this.read.offsetX;
        int dy = y + this.read.offsetY;
        int dz = z + this.read.offsetZ;
        MachineRegistry m = isCentered ? this.getMachine(this.read) : MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
        TileEntity tileEntity = te = isCentered ? this.getAdjacentTileEntity(this.read) : world.func_147438_o(dx, dy, dz);
        if (this.isProvider(te)) {
            ShaftPowerEmitter sp;
            TileEntityTransmissionMachine devicein;
            if (m == MachineRegistry.SHAFT) {
                devicein = (TileEntityShaft)te;
                if (((TileEntityShaft)devicein).isCross()) {
                    this.readFromCross((TileEntityShaft)devicein);
                    return;
                }
                if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntityShaft)devicein).torque;
                    this.omegain = ((TileEntityShaft)devicein).omega;
                }
            }
            if (te instanceof SimpleProvider) {
                this.copyStandardPower(te);
            }
            if (te instanceof ComplexIO) {
                ComplexIO pwr = (ComplexIO)te;
                ForgeDirection dir = this.getInputForgeDirection().getOpposite();
                this.omegain = pwr.getSpeedToSide(dir);
                this.torquein = pwr.getTorqueToSide(dir);
            }
            if (te instanceof ShaftPowerEmitter && (sp = (ShaftPowerEmitter)te).isEmitting() && sp.canWriteTo(this.read.getOpposite())) {
                this.torquein = sp.getTorque();
                this.omegain = sp.getOmega();
            }
            if (m == MachineRegistry.SPLITTER) {
                devicein = (TileEntitySplitter)te;
                if (((TileEntitySplitter)devicein).isSplitting()) {
                    this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein);
                    this.torquein = this.torque;
                    this.omegain = this.omega;
                    return;
                }
                if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntitySplitter)devicein).torque;
                    this.omegain = ((TileEntitySplitter)devicein).omega;
                }
            }
        } else if (te instanceof WorldRift) {
            WorldRift sr = (WorldRift)te;
            WorldLocation loc = sr.getLinkTarget();
            if (loc != null) {
                this.transferPower(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, meta);
            }
        } else {
            this.omega = 0;
            this.torque = 0;
            this.power = 0L;
            return;
        }
        this.omega = this.omegain;
        this.torque = this.torquein;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("posn", this.direction);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.direction = NBT.func_74762_e("posn");
        if (!NBT.func_74764_b("posn")) {
            this.direction = (Integer)directions.inverse().get((Object)new ImmutablePair((Object)this.read, (Object)this.write));
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.BEVELGEARS;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void onEMP() {
    }

    static {
        for (int i = 0; i < 24; ++i) {
            TileEntityBevelGear.registerDirectionValue(i);
        }
    }
}

