/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.Interfaces.ComplexIO;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntityTransmissionMachine;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import java.util.Collection;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.ProjectRedAPI;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"mrtjp.projectred.api.IBundledTile"})
public class TileEntityDistributionClutch
extends TileEntityTransmissionMachine
implements ComplexIO,
GuiController,
IBundledTile {
    private int[] requestedTorques = new int[4];
    private int[] outputTorques = new int[4];
    private boolean[] enabledSides = new boolean[4];
    private ControlMode control = ControlMode.GUI;

    @Override
    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        if (this.read == null) {
            return new PowerSourceList();
        }
        return PowerSourceList.getAllFrom(this.field_145850_b, this.read, this.field_145851_c + this.read.offsetX, this.field_145848_d + this.read.offsetY, this.field_145849_e + this.read.offsetZ, this, caller);
    }

    @Override
    public void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        if (dir == this.read) {
            for (int i = 2; i < 6; ++i) {
                ForgeDirection dir2 = this.dirs[i];
                if (!this.isOutputtingToSide(dir2)) continue;
                c.add(this.getAdjacentTileEntity(dir2));
            }
        }
    }

    public boolean isOutputtingToSide(ForgeDirection dir) {
        return dir != this.read && this.enabledSides[dir.ordinal() - 2] && (this.requestedTorques[dir.ordinal() - 2] > 0 || this.outputTorques[dir.ordinal() - 2] > 0);
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.DISTRIBCLUTCH;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        if (!RotaryAux.getPowerOnClient && world.field_72995_K) {
            return;
        }
        this.updateControl(world, x, y, z);
        this.intakePower(world, x, y, z, meta);
        this.omega = this.omegain;
        this.distributePower(world, x, y, z);
    }

    private void getIOSides(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 0: {
                this.read = ForgeDirection.EAST;
                break;
            }
            case 1: {
                this.read = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.NORTH;
            }
        }
        this.write = this.read.getOpposite();
    }

    private void updateControl(World world, int x, int y, int z) {
        this.enabledSides[this.write.ordinal() - 2] = true;
        this.enabledSides[this.read.ordinal() - 2] = false;
        if (this.control == ControlMode.REDSTONE) {
            int redstone = world.func_94577_B(x, y, z);
            this.enabledSides[ForgeDirection.NORTH.ordinal() - 2] = (redstone & 1) != 0;
            this.enabledSides[ForgeDirection.EAST.ordinal() - 2] = (redstone & 2) != 0;
            this.enabledSides[ForgeDirection.SOUTH.ordinal() - 2] = (redstone & 4) != 0;
            this.enabledSides[ForgeDirection.WEST.ordinal() - 2] = (redstone & 8) != 0;
        } else if (this.control == ControlMode.BUNDLEDREDSTONE) {
            this.enabledSides[ForgeDirection.NORTH.ordinal() - 2] = this.getBundledInput(world, x, y, z, ReikaDyeHelper.RED) != 0;
            this.enabledSides[ForgeDirection.EAST.ordinal() - 2] = this.getBundledInput(world, x, y, z, ReikaDyeHelper.YELLOW) != 0;
            this.enabledSides[ForgeDirection.SOUTH.ordinal() - 2] = this.getBundledInput(world, x, y, z, ReikaDyeHelper.BLUE) != 0;
            this.enabledSides[ForgeDirection.WEST.ordinal() - 2] = this.getBundledInput(world, x, y, z, ReikaDyeHelper.GREEN) != 0;
        }
    }

    private void distributePower(World world, int x, int y, int z) {
        ForgeDirection dir;
        int i;
        int leftover = this.torquein;
        for (i = 2; i < 6; ++i) {
            dir = this.dirs[i];
            this.outputTorques[dir.ordinal() - 2] = 0;
            if (!this.isOutputtingToSide(dir)) continue;
            int amt = this.calculateOutputTorque(dir, leftover);
            leftover -= amt;
            this.outputTorques[dir.ordinal() - 2] = amt;
        }
        this.outputTorques[this.write.ordinal() - 2] = leftover;
        for (i = 2; i < 6; ++i) {
            dir = this.dirs[i];
            if (this.getAdjacentTileEntity(dir) == null) continue;
            int speed = this.getSpeedToSide(dir);
            int torque = this.getTorqueToSide(dir);
            this.writeToPowerReceiver(dir, speed, torque);
        }
    }

    private void intakePower(World world, int x, int y, int z, int meta) {
        TileEntity te;
        if (!RotaryAux.getPowerOnClient && world.field_72995_K) {
            return;
        }
        this.torquein = 0;
        this.omegain = 0;
        boolean isCentered = x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e;
        int dx = x + this.read.offsetX;
        int dy = y + this.read.offsetY;
        int dz = z + this.read.offsetZ;
        MachineRegistry m = isCentered ? this.getMachine(this.read) : MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
        TileEntity tileEntity = te = isCentered ? this.getAdjacentTileEntity(this.read) : world.func_147438_o(dx, dy, dz);
        if (this.isProvider(te)) {
            ShaftPowerEmitter sp;
            TileEntityTransmissionMachine devicein;
            if (m == MachineRegistry.SHAFT) {
                devicein = (TileEntityShaft)te;
                if (((TileEntityShaft)devicein).isCross()) {
                    this.readFromCross((TileEntityShaft)devicein);
                    return;
                }
                if (devicein.isWritingToCoordinate(x, y, z)) {
                    this.torquein = ((TileEntityShaft)devicein).torque;
                    this.omegain = ((TileEntityShaft)devicein).omega;
                }
            }
            if (te instanceof ComplexIO) {
                ComplexIO pwr = (ComplexIO)te;
                ForgeDirection dir = this.getInputForgeDirection().getOpposite();
                this.omegain = pwr.getSpeedToSide(dir);
                this.torquein = pwr.getTorqueToSide(dir);
            }
            if (te instanceof SimpleProvider) {
                this.copyStandardPower(te);
            }
            if (te instanceof ShaftPowerEmitter && (sp = (ShaftPowerEmitter)te).isEmitting() && sp.canWriteTo(this.read.getOpposite())) {
                this.torquein = sp.getTorque();
                this.omegain = sp.getOmega();
            }
            if (m == MachineRegistry.SPLITTER) {
                devicein = (TileEntitySplitter)te;
                if (((TileEntitySplitter)devicein).isSplitting()) {
                    this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein);
                    this.torquein = this.torque;
                    this.omegain = this.omega;
                    return;
                }
                if (devicein.isWritingToCoordinate(x, y, z)) {
                    this.torquein = ((TileEntitySplitter)devicein).torque;
                    this.omegain = ((TileEntitySplitter)devicein).omega;
                }
            }
        } else if (te instanceof WorldRift) {
            WorldRift sr = (WorldRift)te;
            WorldLocation loc = sr.getLinkTarget();
            if (loc != null) {
                this.intakePower(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, meta);
            }
        } else {
            this.torque = 0;
            this.omega = 0;
        }
    }

    private int calculateOutputTorque(ForgeDirection dir, int available) {
        return Math.min(this.requestedTorques[dir.ordinal() - 2], available);
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74783_a("output", this.outputTorques);
        NBT.func_74783_a("req", this.requestedTorques);
        NBT.func_74768_a("sides", ReikaArrayHelper.booleanToBitflags((boolean[])this.enabledSides));
        NBT.func_74768_a("control", this.control.ordinal());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.requestedTorques = NBT.func_74759_k("req");
        this.outputTorques = NBT.func_74759_k("output");
        this.enabledSides = ReikaArrayHelper.booleanFromBitflags((int)NBT.func_74762_e("sides"), (int)4);
        this.control = ControlMode.list[NBT.func_74762_e("control")];
    }

    @Override
    public int getSpeedToSide(ForgeDirection dir) {
        return this.isOutputtingToSide(dir) ? this.omega : 0;
    }

    @Override
    public int getTorqueToSide(ForgeDirection dir) {
        return this.outputTorques[dir.ordinal() - 2];
    }

    public void setSideEnabled(ForgeDirection dir, boolean flag) {
        this.enabledSides[dir.ordinal() - 2] = flag;
        this.syncAllData(false);
    }

    public boolean isSideEnabled(ForgeDirection dir) {
        return this.enabledSides[dir.ordinal() - 2];
    }

    public int getTorqueRequest(ForgeDirection dir) {
        return this.requestedTorques[dir.ordinal() - 2];
    }

    public void setTorqueRequest(ForgeDirection dir, int amt) {
        this.requestedTorques[dir.ordinal() - 2] = amt;
        this.syncAllData(false);
    }

    public void setTorqueRequests(int[] vals) {
        for (int i = 0; i < 4; ++i) {
            this.requestedTorques[i] = vals[i];
        }
        this.syncAllData(false);
    }

    public int getInputTorque() {
        return this.torquein;
    }

    public byte[] getBundledSignal(int dir) {
        return new byte[16];
    }

    public boolean canConnectBundled(int side) {
        return this.control == ControlMode.BUNDLEDREDSTONE;
    }

    @DependentMethodStripper.ModDependent(value={ModList.PROJRED})
    private int getBundledInput(World world, int x, int y, int z, ReikaDyeHelper color) {
        int ret = 0;
        for (int i = 0; i < 6; ++i) {
            int at;
            byte[] data = ProjectRedAPI.transmissionAPI.getBundledInput(world, x, y, z, i);
            int n = at = data != null ? data[color.ordinal()] & 0xFF : 0;
            if (at <= ret) continue;
            ret = at;
        }
        return ret;
    }

    public void stepMode() {
        this.control = this.control.next();
        while (!this.control.isValid()) {
            this.control = this.control.next();
        }
        this.enabledSides = new boolean[4];
        this.triggerBlockUpdate();
    }

    public static enum ControlMode {
        GUI,
        REDSTONE,
        BUNDLEDREDSTONE,
        COMPUTER;

        private static final ControlMode[] list;

        public ControlMode next() {
            return this.ordinal() == list.length - 1 ? list[0] : list[this.ordinal() + 1];
        }

        public boolean isValid() {
            switch (this) {
                case BUNDLEDREDSTONE: {
                    return ModList.PROJRED.isLoaded();
                }
                case COMPUTER: {
                    return ModList.COMPUTERCRAFT.isLoaded() || ModList.OPENCOMPUTERS.isLoaded();
                }
            }
            return true;
        }

        static {
            list = ControlMode.values();
        }
    }
}

