/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.Interfaces.ComplexIO;
import Reika.RotaryCraft.Auxiliary.Interfaces.NBTMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntity1DTransmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Base.TileEntity.TileEntityTransmissionMachine;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.GearboxTypes;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import vazkii.botania.api.mana.IManaReceiver;

@APIStripper.Strippable(value={"vazkii.botania.api.mana.IManaReceiver", "Reika.ChromatiCraft.API.Interfaces.Repairable"})
public class TileEntityGearbox
extends TileEntity1DTransmitter
implements PipeConnector,
IFluidHandler,
TemperatureTE,
NBTMachine,
IManaReceiver {
    public boolean reduction = true;
    private int damage = 0;
    private GearboxTypes type;
    private final HybridTank tank = new HybridTank("gear", 24000);
    private boolean failed;
    private int temperature;
    private StepTimer tempTimer = new StepTimer(20);
    private GearboxTypes bearingTier;
    private static final int MAX_DAMAGE = 480;
    public static final double BEARINGREDUCTION = 0.25;
    public static final double BEARINGINCREASE = 1.0;

    public TileEntityGearbox(GearboxTypes type) {
        if (type == null) {
            type = GearboxTypes.WOOD;
        }
        this.type = type;
        this.bearingTier = type;
    }

    public TileEntityGearbox() {
        this(GearboxTypes.WOOD);
    }

    public GearboxTypes getGearboxType() {
        return this.type != null ? this.type : GearboxTypes.WOOD;
    }

    public GearboxTypes getBearingTier() {
        return this.bearingTier != null ? this.bearingTier : this.type;
    }

    @SideOnly(value=Side.CLIENT)
    public void setData(GearboxTypes type, int ratio) {
        this.type = type;
        this.ratio = ratio;
    }

    public void setMaterialFromItem(ItemStack is) {
        this.bearingTier = this.type = GearboxTypes.getMaterialFromGearboxItem(is);
        this.syncAllData(true);
    }

    public void setBearingTier(GearboxTypes tier) {
        this.bearingTier = tier;
        this.syncAllData(true);
    }

    private int getBearingTierOffset() {
        return this.getBearingTier().material.ordinal() - this.type.material.ordinal();
    }

    public int getMaxLubricant() {
        return this.type.getMaxLubricant();
    }

    public int getDamage() {
        return this.damage;
    }

    public double getDamagedPowerFactor() {
        return Math.pow(0.99, this.damage);
    }

    public int getDamagePercent() {
        return TileEntityGearbox.getDamagePercent(this.damage);
    }

    @Override
    protected void readFromSplitter(World world, int x, int y, int z, TileEntitySplitter spl) {
        int sratio = spl.getRatioFromMode();
        if (sratio == 0) {
            return;
        }
        boolean favorbent = false;
        if (sratio < 0) {
            favorbent = true;
            sratio = -sratio;
        }
        if (this.reduction) {
            if (x == spl.getWriteX() && z == spl.getWriteZ()) {
                this.omega = spl.omega / this.ratio;
                this.torque = sratio == 1 ? spl.torque / 2 * this.ratio : (favorbent ? spl.torque / sratio * this.ratio : this.ratio * (int)((double)spl.torque * (((double)sratio - 1.0) / (double)sratio)));
            } else if (x == spl.getWriteX2() && z == spl.getWriteZ2()) {
                this.omega = spl.omega / this.ratio;
                this.torque = sratio == 1 ? spl.torque / 2 * this.ratio : (favorbent ? this.ratio * (int)((double)spl.torque * (((double)sratio - 1.0) / (double)sratio)) : spl.torque / sratio * this.ratio);
            } else {
                this.torque = 0;
                this.omega = 0;
                this.power = 0L;
            }
        } else if (x == spl.getWriteX() && z == spl.getWriteZ()) {
            this.omega = spl.omega * this.ratio;
            this.torque = sratio == 1 ? spl.torque / 2 / this.ratio : (favorbent ? spl.torque / sratio / this.ratio : (int)((double)spl.torque * ((double)sratio - 1.0) / (double)sratio) / this.ratio);
        } else if (x == spl.getWriteX2() && z == spl.getWriteZ2()) {
            this.omega = spl.omega * this.ratio;
            this.torque = sratio == 1 ? spl.torque / 2 / this.ratio : (favorbent ? (int)((double)spl.torque * (((double)sratio - 1.0) / (double)sratio)) / this.ratio : spl.torque / sratio / this.ratio);
        } else {
            this.torque = 0;
            this.omega = 0;
            this.power = 0L;
        }
    }

    protected void onPositiveRedstoneEdge() {
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getIOSides(world, x, y, z, meta);
        if ((world.func_72820_D() & 0x1FL) == 0L) {
            ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
        }
        this.transferPower(world, x, y, z, meta);
        this.power = (long)this.omega * (long)this.torque;
        this.getLubeAndApplyDamage(world, x, y, z, meta);
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
        if (!(world.field_72995_K || this.power != 0L || !this.isLiving() || rand.nextInt(20) != 0 || this.damage <= 0 || this.type.needsLubricant() && this.tank.getLevel() < 25)) {
            this.repair(1);
            if (this.type.needsLubricant()) {
                this.tank.removeLiquid(25);
            }
        }
        this.basicPowerReceiver();
    }

    private void getLubeAndApplyDamage(World world, int x, int y, int z, int metadata) {
        boolean oldlube = false;
        if (this.type.needsLubricant() && this.omega > 0 && this.getBearingTier().material.ordinal() < MaterialRegistry.BEDROCK.ordinal()) {
            if (this.tank.isEmpty()) {
                if (!world.field_72995_K && this.damage < 480 && rand.nextInt(40) == 0 && this.getTicksExisted() >= 100) {
                    ++this.damage;
                    RotaryAchievements.DAMAGEGEARS.triggerAchievement(this.getPlacer());
                }
                if (rand.nextDouble() * rand.nextDouble() > this.getDamagedPowerFactor()) {
                    if (this.type.material.isFlammable() && !world.field_72995_K) {
                        ReikaWorldHelper.ignite((World)world, (int)x, (int)y, (int)z);
                    }
                    world.func_72869_a("crit", (double)((float)this.field_145851_c + rand.nextFloat()), (double)((float)this.field_145848_d + rand.nextFloat()), (double)((float)this.field_145849_e + rand.nextFloat()), -0.5 + (double)rand.nextFloat(), (double)rand.nextFloat(), -0.5 + (double)rand.nextFloat());
                    if (rand.nextInt(5) == 0) {
                        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.type.material.getDamageNoise(), 1.0f, 1.0f);
                    }
                }
            } else if (!world.field_72995_K && this.consumesLubricant() && this.tickcount >= 80) {
                this.tank.removeLiquid(Math.max(1, (int)((double)DifficultyEffects.LUBEUSAGE.getChance() * this.getLubricantConsumptionFactor())));
                this.tickcount = 0;
            }
        }
    }

    public boolean consumesLubricant() {
        return this.type.consumesLubricant() && this.getBearingTier().material.ordinal() < MaterialRegistry.DIAMOND.ordinal();
    }

    private double getLubricantConsumptionFactor() {
        double base = (double)this.type.getLubricantConsumeRate(this.omegain) * ReikaMathLibrary.logbase((long)this.omegain, (int)2) / 4.0;
        if (this.type != this.getBearingTier()) {
            base *= this.getBearingLubricantFactor();
        }
        if (this.isLiving()) {
            base *= 4.0;
        }
        return base;
    }

    public double getBearingLubricantFactor() {
        if (!this.getBearingTier().needsLubricant()) {
            return -1.0;
        }
        if (!this.getBearingTier().consumesLubricant()) {
            return 0.0;
        }
        int offset = this.getBearingTierOffset();
        double add = offset > 0 ? -0.25 * (double)offset : (double)(-offset) * 1.0;
        return Math.max(0.1, 1.0 + add);
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        while (metadata > 3) {
            metadata -= 4;
        }
        super.getIOSides(world, x, y, z, metadata, false);
    }

    private void calculateRatio() {
        int tratio = 1 + this.func_145832_p() / 4;
        this.ratio = (int)ReikaMathLibrary.intpow((double)2.0, (int)tratio);
    }

    @Override
    protected void readFromCross(TileEntityShaft cross) {
        if (cross.isWritingTo(this)) {
            if (this.reduction) {
                this.omegain = cross.readomega[0] / this.ratio;
                this.torquein = cross.readtorque[0] * this.ratio;
            } else {
                this.omegain = cross.readomega[0] * this.ratio;
                this.torquein = cross.readtorque[0] / this.ratio;
            }
        } else if (cross.isWritingTo2(this)) {
            if (this.reduction) {
                this.omegain = cross.readomega[1] / this.ratio;
                this.torquein = cross.readtorque[1] * this.ratio;
            } else {
                this.omegain = cross.readomega[1] * this.ratio;
                this.torquein = cross.readtorque[1] / this.ratio;
            }
        } else {
            this.torquein = 0;
            this.omegain = 0;
            return;
        }
    }

    @Override
    protected void transferPower(World world, int x, int y, int z, int meta) {
        TileEntity te;
        this.calculateRatio();
        if (this.field_145850_b.field_72995_K && !RotaryAux.getPowerOnClient) {
            return;
        }
        this.performRatio = true;
        this.torquein = 0;
        this.omegain = 0;
        boolean isCentered = x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e;
        int dx = x + this.read.offsetX;
        int dy = y + this.read.offsetY;
        int dz = z + this.read.offsetZ;
        MachineRegistry m = isCentered ? this.getMachine(this.read) : MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
        TileEntity tileEntity = te = isCentered ? this.getAdjacentTileEntity(this.read) : world.func_147438_o(dx, dy, dz);
        if (this.isProvider(te)) {
            TileEntityTransmissionMachine devicein;
            if (m == MachineRegistry.SHAFT) {
                devicein = (TileEntityShaft)te;
                if (((TileEntityShaft)devicein).isCross()) {
                    this.readFromCross((TileEntityShaft)devicein);
                    this.performRatio = false;
                } else if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntityShaft)devicein).torque;
                    this.omegain = ((TileEntityShaft)devicein).omega;
                }
            } else if (te instanceof SimpleProvider) {
                this.copyStandardPower(te);
            } else if (te instanceof ComplexIO) {
                ComplexIO pwr = (ComplexIO)te;
                ForgeDirection dir = this.getInputForgeDirection().getOpposite();
                this.omegain = pwr.getSpeedToSide(dir);
                this.torquein = pwr.getTorqueToSide(dir);
            } else if (te instanceof ShaftPowerEmitter) {
                ShaftPowerEmitter sp = (ShaftPowerEmitter)te;
                if (sp.isEmitting() && sp.canWriteTo(this.read.getOpposite())) {
                    this.torquein = sp.getTorque();
                    this.omegain = sp.getOmega();
                }
            } else if (m == MachineRegistry.SPLITTER) {
                devicein = (TileEntitySplitter)te;
                if (((TileEntitySplitter)devicein).isSplitting()) {
                    this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein);
                    this.performRatio = false;
                } else if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntitySplitter)devicein).torque;
                    this.omegain = ((TileEntitySplitter)devicein).omega;
                }
            }
        } else if (te instanceof WorldRift) {
            WorldRift sr = (WorldRift)te;
            WorldLocation loc = sr.getLinkTarget();
            if (loc != null) {
                this.transferPower(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, meta);
            }
        } else {
            this.omega = 0;
            this.torque = 0;
            this.power = 0L;
            return;
        }
        if (this.performRatio) {
            if (this.reduction) {
                this.omega = this.omegain / this.ratio;
                if (this.torquein <= 0x3FFFFFFF / this.ratio) {
                    this.torque = this.torquein * this.ratio;
                } else {
                    this.torque = 0x3FFFFFFF;
                    world.func_72869_a("crit", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), -0.5 + (double)rand.nextFloat(), (double)rand.nextFloat(), -0.5 + (double)rand.nextFloat());
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.type.material.getDamageNoise(), 0.1f, 1.0f);
                }
            } else {
                if (this.omegain <= 0x3FFFFFFF / this.ratio) {
                    this.omega = this.omegain * this.ratio;
                } else {
                    this.omega = 0x3FFFFFFF;
                    world.func_72869_a("crit", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), -0.5 + (double)rand.nextFloat(), (double)rand.nextFloat(), -0.5 + (double)rand.nextFloat());
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.type.material.getDamageNoise(), 0.1f, 1.0f);
                }
                this.torque = this.torquein / this.ratio;
            }
        }
        this.torque = (int)((double)this.torque * this.getDamagedPowerFactor());
        int tempEff = this.temperature + Math.max(0, world.func_72972_b(EnumSkyBlock.Block, x, y, z) - 10);
        if ((long)this.torque * (long)this.omega >= 131072L) {
            tempEff += ReikaMathLibrary.logbase2((long)((long)this.torque * (long)this.omega / 131072L));
        }
        if (tempEff <= (this.type.material == MaterialRegistry.WOOD ? -15 : -20)) {
            double c;
            if (this.type.needsLubricant()) {
                double c2 = (double)(-(tempEff + 20)) / 40.0;
                this.omega = (int)((double)this.omega / Math.pow(1.4, c2));
            } else if (this.type.material == MaterialRegistry.WOOD && (c = Math.min(1.0, (double)(-tempEff - 15) * 0.025)) > 0.0 && ReikaRandomHelper.doWithChance((double)c)) {
                ++this.damage;
            }
        }
        if (this.torque <= 0) {
            this.omega = 0;
        }
        if (!this.type.material.isInfiniteStrength()) {
            this.testFailure();
        }
    }

    public void fail(World world, int x, int y, int z) {
        this.failed = true;
        world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.0f, true);
        ItemStack item = null;
        switch (this.type) {
            case WOOD: 
            case LIVINGWOOD: {
                item = ItemStacks.sawdust.func_77946_l();
                break;
            }
            case STONE: 
            case LIVINGROCK: {
                item = new ItemStack(Blocks.field_150351_n, 1, 0);
                break;
            }
            case STEEL: {
                item = ItemStacks.scrap.func_77946_l();
                break;
            }
            case TUNGSTEN: {
                item = ItemStacks.scrap.func_77946_l();
                break;
            }
            case DIAMOND: {
                item = new ItemStack(Items.field_151045_i, 1, 0);
                break;
            }
            case BEDROCK: {
                item = ItemStacks.bedrockdust.func_77946_l();
            }
        }
        for (int i = 0; i < this.getRatio(); ++i) {
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 1.25), (double)((double)z + 0.5), (ItemStack)item);
        }
        world.func_147468_f(x, y, z);
    }

    public boolean repair(int dmg) {
        if (this.damage <= 0) {
            return false;
        }
        this.damage -= dmg;
        if (this.damage < 0) {
            this.damage = 0;
        }
        this.failed = false;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void setDamage(int dmg) {
        this.damage = dmg;
    }

    public void testFailure() {
        if (ReikaEngLibrary.mat_rotfailure((double)this.type.material.rho, (double)0.0625, (double)this.type.getOmegaForRotFailure(this.omega, this.omegain), (double)this.type.material.tensile)) {
            this.fail(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (ReikaEngLibrary.mat_twistfailure((int)Math.max(this.torque, this.torquein), (double)0.0625, (double)(this.type.material.shear / 16.0))) {
            this.fail(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int getLubricantScaled(int par1) {
        if (this.getMaxLubricant() == 0) {
            return 0;
        }
        return this.tank.getLevel() * par1 / this.getMaxLubricant();
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("reduction", this.reduction);
        NBT.func_74768_a("damage", this.damage);
        NBT.func_74757_a("fail", this.failed);
        NBT.func_74768_a("temp", this.temperature);
        NBT.func_74778_a("bearing", this.bearingTier.name());
        this.tank.writeToNBT(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.reduction = NBT.func_74767_n("reduction");
        this.damage = NBT.func_74762_e("damage");
        this.failed = NBT.func_74767_n("fail");
        this.temperature = NBT.func_74762_e("temp");
        if (NBT.func_74764_b("bearing")) {
            this.bearingTier = GearboxTypes.valueOf(NBT.func_74779_i("bearing"));
        }
        this.tank.readFromNBT(NBT);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        NBT.func_74778_a("geartype", this.type.name());
        super.func_145841_b(NBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        GearboxTypes gear = GearboxTypes.WOOD;
        if (NBT.func_74764_b("geartype")) {
            gear = GearboxTypes.valueOf(NBT.func_74779_i("geartype"));
        } else if (NBT.func_74764_b("type")) {
            int idx = NBT.func_74762_e("type");
            if (idx >= MaterialRegistry.TUNGSTEN.ordinal()) {
                ++idx;
            }
            MaterialRegistry mat = MaterialRegistry.matList[idx];
            gear = GearboxTypes.getFromMaterial(mat);
        }
        this.type = gear;
        super.func_145839_a(NBT);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    public int getRedstoneOverride() {
        return this.getMaxLubricant() > 0 ? 15 * this.tank.getLevel() / this.getMaxLubricant() : 0;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.HOSE || m == MachineRegistry.BEDPIPE;
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return side != (this.isFlipped ? ForgeDirection.DOWN : ForgeDirection.UP);
    }

    @Override
    public void onEMP() {
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int space;
        if (this.canFill(from, resource.getFluid()) && (space = this.getMaxLubricant() - this.getLubricant()) > 0) {
            if (resource.amount > space) {
                resource = new FluidStack(resource.getFluid(), space);
            }
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != (this.isFlipped ? ForgeDirection.DOWN : ForgeDirection.UP) && fluid.equals(FluidRegistry.getFluid((String)"rc lubricant")) && !this.isLiving();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int getLubricant() {
        return this.tank.getLevel();
    }

    public void setLubricant(int amt) {
        this.tank.setContents(amt, FluidRegistry.getFluid((String)"rc lubricant"));
    }

    public void fillWithLubricant() {
        this.setLubricant(this.getMaxLubricant());
    }

    public boolean canTakeLubricant(int amt) {
        return this.tank.getLevel() + amt <= this.getMaxLubricant();
    }

    public void addLubricant(int amt) {
        this.tank.addLiquid(amt, FluidRegistry.getFluid((String)"rc lubricant"));
    }

    public void clearLubricant() {
        this.tank.empty();
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side != (this.isFlipped ? ForgeDirection.DOWN : ForgeDirection.UP) ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.NONE;
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.GEARBOX;
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (this.omega > 0 && this.type.generatesHeat(this.omega, Tamb)) {
            ++this.temperature;
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)this.type.material.getDamageNoise(), (float)0.67f, (float)1.0f);
        }
        if (this.temperature > 90 && rand.nextBoolean() && this.type.takesTemperatureDamage()) {
            ++this.damage;
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)this.type.material.getDamageNoise(), (float)1.0f, (float)1.0f);
        }
        if (this.temperature > Tamb) {
            this.temperature = Math.max(Tamb, this.temperature - (this.omega == 0 ? 2 : 1));
        } else if (this.temperature < Tamb) {
            this.temperature = Math.min(Tamb, this.temperature + 3);
        }
        if (this.temperature > 120) {
            this.overheat(world, x, y, z);
        }
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public int getThermalDamage() {
        return 0;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
        if (this.type.material.isFlammable() && !world.field_72995_K) {
            ReikaWorldHelper.ignite((World)world, (int)x, (int)y, (int)z);
        }
    }

    public static int getDamagePercent(int val) {
        return (int)(100.0 * (1.0 - Math.pow(0.99, val)));
    }

    @Override
    public boolean canBeCooledWithFins() {
        return true;
    }

    @Override
    public boolean allowHeatExtraction() {
        return false;
    }

    @Override
    public boolean allowExternalHeating() {
        return true;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public int getMaxTemperature() {
        return 1000;
    }

    @Override
    public NBTTagCompound getTagsToWriteToStack() {
        NBTTagCompound NBT = new NBTTagCompound();
        NBT.func_74768_a("damage", this.getDamage());
        NBT.func_74768_a("lube", this.getLubricant());
        NBT.func_74778_a("bearing", this.bearingTier.name());
        return NBT;
    }

    @Override
    public void setDataFromItemStackTag(NBTTagCompound tag) {
        if (tag != null) {
            this.damage = tag.func_74762_e("damage");
            this.setLubricant(tag.func_74762_e("lube"));
            if (tag.func_74764_b("bearing")) {
                try {
                    this.bearingTier = GearboxTypes.valueOf(tag.func_74779_i("bearing"));
                }
                catch (Exception e) {
                    RotaryCraft.logger.logError((Object)("Invalid gearbox item with data " + tag));
                }
            }
        }
    }

    @Override
    public ArrayList<NBTTagCompound> getCreativeModeVariants() {
        return new ArrayList<NBTTagCompound>();
    }

    @Override
    public ArrayList<String> getDisplayTags(NBTTagCompound NBT) {
        return new ArrayList<String>();
    }

    public boolean isLiving() {
        return ModList.BOTANIA.isLoaded() && (this.type == GearboxTypes.LIVINGROCK || this.type == GearboxTypes.LIVINGWOOD);
    }

    public int getCurrentMana() {
        return this.tank.getLevel();
    }

    public boolean isFull() {
        return this.getLubricant() + 150 >= this.getMaxLubricant();
    }

    public void recieveMana(int mana) {
        this.tank.addLiquid(Math.min(mana, this.getMaxLubricant() - this.getLubricant()), FluidRegistry.getFluid((String)"rc lubricant"));
    }

    public boolean canRecieveManaFromBursts() {
        return this.getGearboxType() == GearboxTypes.LIVINGROCK && !this.isFull();
    }

    public void repairCC(int tier) {
        int mod = Math.max(1, 64 / ReikaMathLibrary.intpow2((int)2, (int)tier));
        if (this.getTicksExisted() % mod == 0) {
            int amt = Math.max(1, Math.min(this.damage / 8, (int)(Math.sqrt(tier) / 20.0)));
            this.repair(amt);
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.BCTRANSPORT})
    public final IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection side) {
        return type == IPipeTile.PipeType.FLUID && this.consumesLubricant() && this.canConnectToPipeOnSide(MachineRegistry.HOSE, side) ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
    }
}

