/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaSpawnerHelper;
import Reika.RotaryCraft.Base.TileEntity.TileEntityLaunchCannon;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityBlockCannon
extends TileEntityLaunchCannon {
    public boolean func_94041_b(int slot, ItemStack is) {
        if (ReikaItemHelper.isBlock((ItemStack)is)) {
            return true;
        }
        return ItemRegistry.SPAWNER.matchItem(is) || ReikaFluidHelper.getFluidForItem((ItemStack)is) != null;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.BLOCKCANNON;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getSummativeSidedPower();
        ++this.tickcount;
        if (this.power < this.MINPOWER) {
            return;
        }
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        this.tickcount = 0;
        if (this.fire(world, x, y, z, 0)) {
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.explode");
            ReikaParticleHelper.EXPLODE.spawnAt(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        }
    }

    private double getBlockMass(BlockKey bk) {
        return ReikaPhysicsHelper.getBlockDensity((Block)bk.blockID);
    }

    private int getReqTorque(BlockKey bk) {
        double m = this.getBlockMass(bk);
        int base = ReikaMathLibrary.ceil2exp((int)((int)((double)this.velocity * m))) / 4;
        return base;
    }

    private BlockToFire getNextToFire() {
        for (int i = 0; i < this.inv.length; ++i) {
            BlockKey bk;
            Fluid f;
            BlockKey bk2;
            ItemStack is;
            if (this.inv[i] == null) continue;
            if (ReikaItemHelper.isBlock((ItemStack)this.inv[i])) {
                is = this.inv[i].func_77946_l();
                bk2 = ReikaItemHelper.getWorldBlockFromItem((ItemStack)is);
                if (this.torque < this.getReqTorque(bk2)) continue;
                return new BlockToFire(this.inv[i], bk2, i);
            }
            if (ItemRegistry.SPAWNER.matchItem(this.inv[i])) {
                is = this.inv[i].func_77946_l();
                bk2 = new BlockKey(Blocks.field_150474_ac, 0);
                if (this.torque < this.getReqTorque(bk2)) continue;
                return new BlockToFire(is, bk2, i);
            }
            FluidStack fs = ReikaFluidHelper.getFluidForItem((ItemStack)this.inv[i]);
            if (fs == null || !(f = fs.getFluid()).canBePlacedInWorld() || this.torque < this.getReqTorque(bk = new BlockKey(f.getBlock(), 0))) continue;
            return new BlockToFire(this.inv[i], bk, i);
        }
        return null;
    }

    private void dropItem(ItemStack is) {
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            TileEntity te = this.getAdjacentTileEntity(dir);
            if (!(te instanceof IInventory) || !ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)((IInventory)te))) continue;
            return;
        }
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)(this.field_145848_d + 1), (double)((double)this.field_145849_e + 0.5), (ItemStack)is);
    }

    private void fireBlock(BlockToFire b, World world, int x, int y, int z) {
        EntityFallingBlock e = new EntityFallingBlock(world, (double)x + 0.5, (double)(y + 1) + 0.5, (double)z + 0.5, ((BlockToFire)b).toFire.blockID, ((BlockToFire)b).toFire.metadata);
        if (((BlockToFire)b).toFire.blockID == Blocks.field_150474_ac) {
            TileEntityMobSpawner spw = new TileEntityMobSpawner();
            ReikaSpawnerHelper.setSpawnerFromItemNBT((ItemStack)b.referenceItem, (TileEntityMobSpawner)spw, (boolean)true);
            NBTTagCompound nbt = new NBTTagCompound();
            spw.func_145841_b(nbt);
            e.field_145810_d = nbt;
        }
        double[] vel = ReikaPhysicsHelper.polarToCartesian((double)((double)this.velocity / 20.0), (double)this.theta, (double)this.phi);
        e.field_70159_w = vel[0];
        e.field_70181_x = vel[1];
        e.field_70179_y = vel[2];
        e.field_145812_b = -10000;
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)e);
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    protected boolean fire(World world, int x, int y, int z, int slot) {
        BlockToFire b = this.getNextToFire();
        if (b == null) {
            return false;
        }
        if (this.inv[b.inventorySlot] == null) {
            return false;
        }
        ReikaInventoryHelper.decrStack((int)b.inventorySlot, (ItemStack[])this.inv);
        this.dropContainers(world, x, y, z, b.referenceItem);
        this.fireBlock(b, world, x, y, z);
        return true;
    }

    private void dropContainers(World world, int x, int y, int z, ItemStack next) {
        ItemStack cont;
        if (FluidContainerRegistry.isFilledContainer((ItemStack)next) && (cont = FluidContainerRegistry.drainFluidContainer((ItemStack)next)) != null) {
            this.dropItem(cont);
        }
    }

    @Override
    public int getMaxLaunchVelocity() {
        if (this.power < this.MINPOWER) {
            return 0;
        }
        return 1000;
    }

    @Override
    public int getMaxTheta() {
        if (this.power < this.MINPOWER) {
            return 0;
        }
        return 1000;
    }

    @Override
    public double getMaxLaunchDistance() {
        if (this.power < this.MINPOWER) {
            return 0.0;
        }
        return 1000.0;
    }

    private static class BlockToFire {
        private final ItemStack referenceItem;
        private final BlockKey toFire;
        private final int inventorySlot;

        private BlockToFire(ItemStack is, BlockKey bk, int s) {
            this.referenceItem = is;
            this.toFire = bk;
            this.inventorySlot = s;
        }
    }
}

