/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.RotaryCraft.API.Interfaces.CannonExplosive;
import Reika.RotaryCraft.Base.TileEntity.TileEntityLaunchCannon;
import Reika.RotaryCraft.Entities.EntityCustomTNT;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityTNTCannon
extends TileEntityLaunchCannon {
    public static final double gTNT = 7.5;
    public static final double torquecap = 32768.0;
    public int selectedFuse;

    @Override
    public int getMaxLaunchVelocity() {
        return (int)Math.sqrt((double)this.power / 67.5);
    }

    @Override
    public int getMaxTheta() {
        if ((double)this.torque > 32768.0) {
            return 90;
        }
        int ang = 2 * (int)Math.ceil(Math.toDegrees(Math.asin((double)this.torque / 32768.0)));
        if (ang > 90) {
            return 90;
        }
        return ang;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public double getMaxLaunchDistance() {
        double v = this.getMaxLaunchVelocity();
        double vy = v * Math.sin(Math.toRadians(45.0));
        double t = vy / 9.81;
        return t * vy;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        int slot;
        super.updateTileEntity();
        this.getSummativeSidedPower();
        if (DragonAPICore.debugtest) {
            ReikaInventoryHelper.addToIInv((Block)Blocks.field_150335_W, (IInventory)this);
        }
        if (this.power < this.MINPOWER) {
            return;
        }
        ++this.tickcount;
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        this.tickcount = 0;
        if (this.targetMode) {
            this.calcTarget(world, x, y, z);
        }
        if ((slot = this.canFire()) >= 0) {
            this.fire(world, x, y, z, slot);
        }
        if (this.targetMode) {
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(256.0, 256.0, 256.0);
            List in = world.func_72872_a(EntityTNTPrimed.class, box);
            for (EntityTNTPrimed tnt : in) {
                if (!tnt.field_70122_E) {
                    tnt.field_70159_w /= 0.8698000001907349;
                    tnt.field_70179_y /= 0.8698000001907349;
                    if (world.field_72995_K) continue;
                    tnt.field_70133_I = true;
                    continue;
                }
                tnt.field_70159_w = 0.0;
                tnt.field_70179_y = 0.0;
                if (world.field_72995_K) continue;
                tnt.field_70133_I = true;
            }
        }
    }

    private int getMinFuse() {
        return 5;
    }

    private void calcTarget(World world, int x, int y, int z) {
        double dx = (double)(this.target[0] - x) - 0.5;
        double dy = this.target[1] - y - 1;
        double dz = (double)(this.target[2] - z) - 0.5;
        double dl = ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz);
        double g = 8.4695 * ReikaMathLibrary.doubpow((double)dl, (double)0.2701);
        if (dy > 0.0) {
            g *= 0.8951 * ReikaMathLibrary.doubpow((double)dy, (double)0.0601);
        }
        this.velocity = 10;
        this.theta = 0;
        while (this.theta <= 0) {
            ++this.velocity;
            double s = ReikaMathLibrary.intpow((double)this.velocity, (int)4) - g * (g * dl * dl + 2.0 * dy * (double)this.velocity * (double)this.velocity);
            double a = (double)(this.velocity * this.velocity) + Math.sqrt(s);
            this.theta = (int)Math.toDegrees(Math.atan(a / (g * dl)));
            this.phi = (int)Math.toDegrees(Math.atan2(dz, dx));
        }
    }

    protected int canFire() {
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack is = this.inv[i];
            if (is == null) continue;
            if (ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150335_W)) {
                return i;
            }
            if (!(is.func_77973_b() instanceof CannonExplosive)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected boolean fire(World world, int x, int y, int z, int slot) {
        ItemStack in = this.inv[slot];
        ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.explode", 0.7f + 0.3f * rand.nextFloat() * 12.0f, 0.1f * rand.nextFloat());
        world.func_72869_a("hugeexplosion", (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.0, 0.0, 0.0);
        double dx = (double)x + 0.5;
        double dy = (double)y + 1.5 - 0.0625;
        double dz = (double)z + 0.5;
        int fuse = this.getFuseTime();
        EntityCustomTNT tnt = null;
        if (ReikaItemHelper.matchStackWithBlock((ItemStack)in, (Block)Blocks.field_150335_W)) {
            tnt = new EntityCustomTNT(world, dx, dy, dz, null, fuse);
        } else if (in.func_77973_b() instanceof CannonExplosive) {
            tnt = ((CannonExplosive)in.func_77973_b()).getExplosiveEntity(in);
            tnt.func_70107_b(dx, dy, dz);
            ((CannonExplosive.ExplosiveEntity)((Object)tnt)).setFuse(fuse);
        }
        if (tnt == null) {
            RotaryCraft.logger.logError((Object)"Invalid item in TNT cannon yet firing was attempted!");
            return false;
        }
        double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)((double)this.velocity / 20.0), (double)this.theta, (double)this.phi);
        ((Entity)tnt).field_70159_w = xyz[0];
        ((Entity)tnt).field_70181_x = xyz[1];
        ((Entity)tnt).field_70179_y = xyz[2];
        if (!world.field_72995_K) {
            ((Entity)tnt).field_70133_I = true;
            world.func_72838_d((Entity)tnt);
        }
        return true;
    }

    private int getFuseTime() {
        return this.targetMode ? 50 : Math.max(this.getMinFuse(), this.selectedFuse);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.selectedFuse = NBT.func_74762_e("selfuse");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("selfuse", this.selectedFuse);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.TNTCANNON;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150335_W);
    }

    public int getRedstoneOverride() {
        if (this.canFire() == -1) {
            return 15;
        }
        return 0;
    }
}

