/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry.Turret;

import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Interfaces.TargetEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityFluidCannon;
import Reika.RotaryCraft.Entities.EntityFlameTurretShot;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class TileEntityFlameTurret
extends TileEntityFluidCannon {
    private static final HashMap<String, FlameAttack> damageMultipliers = new HashMap();

    @Override
    public int getRange() {
        return this.tank.isEmpty() ? 0 : (int)(32.0f * TileEntityFlameTurret.damageMultipliers.get((Object)this.tank.getActualFluid().getName()).rangeMultiplier);
    }

    @Override
    public int getMaxRange() {
        return 32;
    }

    @Override
    protected double[] getTarget(World world, int x, int y, int z) {
        double[] xyzb = new double[4];
        int r = this.getRange();
        AxisAlignedBB range = AxisAlignedBB.func_72330_a((double)(x - r), (double)(y - r), (double)(z - r), (double)(x + 1 + r), (double)(y + 1 + r), (double)(z + 1 + r));
        List inrange = world.func_72872_a(Entity.class, range);
        double mindist = this.getRange() + 2;
        Entity i_at_min = null;
        for (Entity ent : inrange) {
            double dy;
            double reqtheta;
            double dist = ReikaMathLibrary.py3d((double)(ent.field_70165_t - (double)x - 0.5), (double)(ent.field_70163_u - (double)y - 0.5), (double)(ent.field_70161_v - (double)z - 0.5));
            if (!this.isValidTarget(ent) || !ReikaWorldHelper.canBlockSee((World)world, (int)x, (int)y, (int)z, (double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v, (double)this.getRange()) || !((reqtheta = -90.0 + Math.toDegrees(Math.abs(Math.acos((dy = -(ent.field_70163_u - (double)y)) / dist)))) <= (double)(this.dir * -10) && this.dir == -1) && (!(reqtheta >= (double)(this.dir * -10)) || this.dir != 1) || !(dist < mindist) || !(dist >= 6.0)) continue;
            mindist = dist;
            i_at_min = ent;
        }
        if (i_at_min == null) {
            return xyzb;
        }
        this.closestMob = i_at_min;
        xyzb[0] = this.closestMob.field_70165_t + this.randomOffset();
        xyzb[1] = this.closestMob.field_70163_u + (double)this.closestMob.func_70047_e() * 0.25 + this.randomOffset();
        xyzb[2] = this.closestMob.field_70161_v + this.randomOffset();
        xyzb[3] = 1.0;
        return xyzb;
    }

    @Override
    public void fire(World world, double[] xyz) {
        double dist = ReikaMathLibrary.py3d((double)(xyz[0] - (double)this.field_145851_c), (double)(xyz[1] - (double)this.field_145848_d), (double)(xyz[2] - (double)this.field_145849_e));
        double speed = 0.25 * (Math.pow(dist, 0.7) / 7.0) * ReikaRandomHelper.getRandomPlusMinus((double)1.0, (double)0.125);
        this.tank.removeLiquid(1);
        double[] v = ReikaPhysicsHelper.polarToCartesian((double)speed, (double)(this.theta + 20.0f), (double)(-this.phi + 90.0f));
        double dx = v[0];
        double dy = v[1];
        double dz = v[2];
        if (!world.field_72995_K) {
            double y = this.getFiringPositionY(dy);
            world.func_72838_d((Entity)new EntityFlameTurretShot(world, (double)this.field_145851_c + 0.5 + dx, y, (double)this.field_145849_e + 0.5 + dz, v[0], v[1], v[2], this, damageMultipliers.get(this.tank.getActualFluid().getName())));
        }
        if (this.getTicksExisted() % 34 == 0) {
            SoundRegistry.FLAMETURRET.playSoundAtBlock((TileEntity)this, 1.0f, 1.0f);
        }
    }

    @Override
    protected double getThetaOffset() {
        return 20.0;
    }

    @Override
    protected boolean isValidTarget(Entity ent) {
        if (ent.field_70128_L) {
            return false;
        }
        if (ent instanceof TargetEntity) {
            return ((TargetEntity)ent).shouldTarget((TileEntity)this, this.placerUUID);
        }
        if (!(ent instanceof EntityLivingBase)) {
            return false;
        }
        EntityLivingBase elb = (EntityLivingBase)ent;
        return elb.func_110143_aJ() > 0.0f && this.isMobOrUnlistedPlayer(elb);
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.FLAMETURRET;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        if (this.power < this.MINPOWER || this.omega < this.MINSPEED) {
            return;
        }
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        this.tickcount = 0;
        if (!world.field_72995_K && this.target[3] == 1.0 && this.hasAmmo()) {
            this.fire(world, this.target);
        }
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.FUELLINE || m == MachineRegistry.BEDPIPE;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return damageMultipliers.containsKey(f.getName());
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return true;
    }

    static {
        damageMultipliers.put("oil", new FlameAttack(0.75f, 6, 0.4f, 0));
        damageMultipliers.put("fuel", new FlameAttack(1.0f, 3));
        damageMultipliers.put("rc ethanol", new FlameAttack(1.2f, 4, 1.0f, 8));
        damageMultipliers.put("bioethanol", new FlameAttack(1.35f, 4, 1.0f, 8));
        damageMultipliers.put("rc jet fuel", new FlameAttack(1.8f, 6));
        damageMultipliers.put("rocket fuel", new FlameAttack(2.0f, 10));
    }

    public static class FlameAttack {
        public final float damageMultiplier;
        public final int burnTime;
        public final float rangeMultiplier;
        public final int fireBlockLife;
        private static final int DEFAULT_FIRE_LIFE = 4;

        private FlameAttack(float f, int burn) {
            this(f, burn, 1.0f, 4);
        }

        private FlameAttack(float f, int burn, int life) {
            this(f, burn, 1.0f, life);
        }

        private FlameAttack(float f, int burn, float r) {
            this(f, burn, r, 4);
        }

        private FlameAttack(float f, int burn, float r, int life) {
            this.damageMultiplier = f;
            this.burnTime = burn;
            this.rangeMultiplier = r;
            this.fireBlockLife = life;
        }
    }
}

