/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry.Turret;

import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Interfaces.TargetEntity;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.TileEntityInventoriedCannon;
import Reika.RotaryCraft.Entities.EntityGatlingShot;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityMultiCannon
extends TileEntityInventoriedCannon {
    private static final int FIRE_RATE = 1;
    private static final int AMMO_RATE = 10;
    public static final double AMMO_PER_SHOT = 0.1;
    private static final int RELOAD_TIME = 80;
    private static final int FEED_TIME = 4;
    public static final int LOAD_SLOT = 0;
    public static final int CLIP_SLOT = 36;
    private static final double SPIN_RATE = 25.0;
    private static final double SPIN_DELTA = 5.0;
    private static final double JITTER = 0.625;
    public static final String SLIME_NBT = "embedded_rounds";
    private double spinAngle;
    private double spinSpeed;
    private int reloadTimer;
    private int feedTick;

    public double getSpinAngle() {
        return this.spinAngle;
    }

    private void startReload() {
        this.reloadTimer = 80;
        if (this.inv[35] != null) {
            SoundRegistry.GATLINGRELOAD.playSoundAtBlock((TileEntity)this, 0.75f, 0.95f);
        }
    }

    private void doReload() {
        --this.reloadTimer;
        if (this.reloadTimer == 0) {
            ReikaArrayHelper.cycleArray((Object[])this.inv, null);
            SoundRegistry.PROJECTOR.playSoundAtBlock((TileEntity)this, 2.0f, 0.75f);
        }
    }

    public int func_70302_i_() {
        return 37;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 0 && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.ballbearing);
    }

    @Override
    public int getRange() {
        return 120;
    }

    @Override
    public int getMaxRange() {
        return 120;
    }

    @Override
    public boolean hasAmmo() {
        return ReikaItemHelper.matchStacks((ItemStack)ItemStacks.ballbearing, (ItemStack)this.inv[36]);
    }

    @Override
    protected double[] getTarget(World world, int x, int y, int z) {
        double[] xyzb = new double[4];
        int r = this.getRange();
        AxisAlignedBB range = AxisAlignedBB.func_72330_a((double)(x - r), (double)(y - r), (double)(z - r), (double)(x + 1 + r), (double)(y + 1 + r), (double)(z + 1 + r));
        List inrange = world.func_72872_a(Entity.class, range);
        double mindist = this.getRange() + 2;
        Entity i_at_min = null;
        for (Entity ent : inrange) {
            double dy;
            double reqtheta;
            double dist = ReikaMathLibrary.py3d((double)(ent.field_70165_t - (double)x - 0.5), (double)(ent.field_70163_u - (double)y - 0.5), (double)(ent.field_70161_v - (double)z - 0.5));
            if (!this.isValidTarget(ent) || !ReikaWorldHelper.canBlockSee((World)world, (int)x, (int)y, (int)z, (double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v, (double)this.getRange()) || !((reqtheta = -90.0 + Math.toDegrees(Math.abs(Math.acos((dy = -(ent.field_70163_u - (double)y)) / dist)))) <= (double)(this.dir * -10) && this.dir == -1) && (!(reqtheta >= (double)(this.dir * -10)) || this.dir != 1) || !(dist < mindist)) continue;
            mindist = dist;
            i_at_min = ent;
        }
        if (i_at_min == null) {
            return xyzb;
        }
        this.closestMob = i_at_min;
        xyzb[0] = this.closestMob.field_70165_t + this.randomOffset();
        xyzb[1] = this.closestMob.field_70163_u + (double)this.closestMob.func_70047_e() * 0.25 + this.randomOffset();
        xyzb[2] = this.closestMob.field_70161_v + this.randomOffset();
        xyzb[3] = 1.0;
        return xyzb;
    }

    @Override
    public void fire(World world, double[] xyz) {
        double speed = 1.5;
        if (ReikaRandomHelper.doWithChance((double)0.1)) {
            ReikaInventoryHelper.decrStack((int)36, (ItemStack[])this.inv);
            if (this.inv[36] == null) {
                this.startReload();
            }
        }
        double[] v = ReikaPhysicsHelper.polarToCartesian((double)speed, (double)this.theta, (double)(-this.phi + 90.0f));
        double dx = v[0];
        double dy = v[1];
        double dz = v[2];
        if (!world.field_72995_K) {
            double y = this.getFiringPositionY(dy);
            world.func_72838_d((Entity)new EntityGatlingShot(world, (double)this.field_145851_c + 0.5 + dx, y, (double)this.field_145849_e + 0.5 + dz, v[0], v[1], v[2], this));
        }
        SoundRegistry.GATLING.playSoundAtBlock((TileEntity)this, 0.25f, 1.125f);
    }

    @Override
    protected double randomOffset() {
        return 0.625;
    }

    @Override
    protected boolean isValidTarget(Entity ent) {
        if (ent.field_70128_L) {
            return false;
        }
        if (ent instanceof TargetEntity) {
            return ((TargetEntity)ent).shouldTarget((TileEntity)this, this.placerUUID);
        }
        if (!(ent instanceof EntityLivingBase)) {
            return false;
        }
        EntityLivingBase elb = (EntityLivingBase)ent;
        return elb.func_110143_aJ() > 0.0f && this.isMobOrUnlistedPlayer(elb);
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.GATLING;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.spinAngle += this.spinSpeed;
        if (this.power < this.MINPOWER || this.omega < this.MINSPEED) {
            this.spinSpeed = Math.max(this.spinSpeed - 5.0, 0.0);
            return;
        }
        if (!world.field_72995_K) {
            if (this.feedTick > 0) {
                --this.feedTick;
            } else {
                this.continuousFeed();
            }
            if (this.reloadTimer == 0 && this.inv[36] == null) {
                this.startReload();
            }
            if (this.reloadTimer > 0) {
                this.doReload();
                return;
            }
        }
        if (!this.hasAmmo()) {
            this.spinSpeed = Math.max(this.spinSpeed - 5.0, 0.0);
            return;
        }
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        this.tickcount = 0;
        if (!world.field_72995_K) {
            if (this.target[3] == 1.0) {
                if (this.spinSpeed < 25.0) {
                    this.spinSpeed = Math.min(this.spinSpeed + 5.0, 25.0);
                } else {
                    this.fire(world, this.target);
                }
            } else {
                this.spinSpeed = Math.max(this.spinSpeed - 5.0, 0.0);
            }
        }
    }

    private void continuousFeed() {
        for (int i = 35; i > 0; --i) {
            if (this.inv[i - 1] == null) continue;
            boolean flag = false;
            if (this.inv[i] == null) {
                this.inv[i] = this.inv[i - 1];
                this.inv[i - 1] = null;
                flag = true;
            } else if (this.inv[i].field_77994_a < 64) {
                int amt = Math.min(64 - this.inv[i].field_77994_a, this.inv[i - 1].field_77994_a);
                this.inv[i].field_77994_a += amt;
                ReikaInventoryHelper.decrStack((int)(i - 1), (IInventory)this, (int)amt);
                flag = true;
            }
            if (!flag) continue;
            this.feedTick = 4;
            return;
        }
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public int getOperationTime() {
        return 1;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74780_a("spin", this.spinAngle);
        NBT.func_74768_a("reload", this.reloadTimer);
        NBT.func_74768_a("feed", this.feedTick);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.spinAngle = NBT.func_74769_h("spin");
        this.feedTick = NBT.func_74762_e("feed");
        this.reloadTimer = NBT.func_74762_e("reload");
    }

    public boolean isReloading() {
        return this.reloadTimer > 0;
    }
}

