/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry.Turret;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Interfaces.RailGunAmmo;
import Reika.RotaryCraft.API.Interfaces.TargetEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityInventoriedCannon;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityRailGun
extends TileEntityInventoriedCannon {
    private RailGunAmmo.RailGunAmmoType ammoType;

    @Override
    public boolean hasAmmo() {
        this.ammoType = null;
        this.checkAmmo();
        return this.ammoType != null;
    }

    private void checkAmmo() {
        for (int i = 0; i < this.inv.length; ++i) {
            RailGunAmmo.RailGunAmmoType rg = TileEntityRailGun.getAmmo(this.inv[i]);
            if (rg == null || this.torque < rg.getRequiredTorque() || this.ammoType != null && rg.compareTo(this.ammoType) <= 0) continue;
            this.ammoType = rg;
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        if (this.power < this.MINPOWER) {
            return;
        }
        if (!this.hasAmmo()) {
            return;
        }
        if (!this.isAimingAtTarget(world, x, y, z, this.target)) {
            return;
        }
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        this.tickcount = 0;
        if (this.target[3] == 1.0 && !world.field_72995_K) {
            this.fire(world, this.target);
        }
    }

    @Override
    protected double[] getTarget(World world, int x, int y, int z) {
        double[] xyzb = new double[4];
        int r = this.getRange();
        AxisAlignedBB range = AxisAlignedBB.func_72330_a((double)(x - r), (double)(y - r), (double)(z - r), (double)(x + 1 + r), (double)(y + 1 + r), (double)(z + 1 + r));
        List inrange = world.func_72872_a(Entity.class, range);
        double mindist = this.getRange() + 2;
        Entity i_at_min = null;
        for (Entity ent : inrange) {
            double dy;
            double reqtheta;
            double dist = ReikaMathLibrary.py3d((double)(ent.field_70165_t - (double)x - 0.5), (double)(ent.field_70163_u - (double)y - 0.5), (double)(ent.field_70161_v - (double)z - 0.5));
            if (!this.isValidTarget(ent) || !ReikaWorldHelper.canBlockSee((World)world, (int)x, (int)y, (int)z, (double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v, (double)this.getRange()) || !((reqtheta = -90.0 + Math.toDegrees(Math.abs(Math.acos((dy = -(ent.field_70163_u - (double)y)) / dist)))) <= (double)(this.dir * -10) && this.dir == -1) && (!(reqtheta >= (double)(this.dir * -10)) || this.dir != 1) || !(dist < mindist)) continue;
            mindist = dist;
            i_at_min = ent;
        }
        if (i_at_min == null) {
            return xyzb;
        }
        this.closestMob = i_at_min;
        xyzb[0] = this.closestMob.field_70165_t + this.randomOffset();
        xyzb[1] = this.closestMob.field_70163_u + (double)this.closestMob.func_70047_e() * 0.25 + this.randomOffset();
        xyzb[2] = this.closestMob.field_70161_v + this.randomOffset();
        xyzb[3] = 1.0;
        return xyzb;
    }

    @Override
    public void fire(World world, double[] xyz) {
        double y;
        Entity e;
        double speed = 4.0;
        ItemStack is = this.ammoType.getItem();
        int slot = ReikaInventoryHelper.locateInInventory((Item)is.func_77973_b(), (int)is.func_77960_j(), (ItemStack[])this.inv);
        ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
        double[] v = new double[]{xyz[0] - (double)this.field_145851_c, xyz[1] - (double)this.field_145848_d, xyz[2] - (double)this.field_145849_e};
        double dd = ReikaMathLibrary.py3d((double)v[0], (double)v[1], (double)v[2]);
        int i = 0;
        while (i < 3) {
            int n = i++;
            v[n] = v[n] / dd;
        }
        i = 0;
        while (i < 3) {
            int n = i++;
            v[n] = v[n] * speed;
        }
        dd = ReikaMathLibrary.py3d((double)v[0], (double)v[1], (double)v[2]);
        double dx = v[0] / dd;
        double dy = v[1] / dd;
        double dz = v[2] / dd;
        if (!world.field_72995_K && (e = this.ammoType.getProjectileEntity(world, (double)this.field_145851_c + 0.5 + dx, y = this.getFiringPositionY(dy), (double)this.field_145849_e + 0.5 + dz, v[0], v[1], v[2], (TileEntity)this)) != null) {
            world.func_72838_d(e);
        }
    }

    @Override
    public int getRange() {
        return 164;
    }

    public Entity getClosestMob() {
        return this.closestMob;
    }

    @Override
    protected double randomOffset() {
        return 0.0;
    }

    public int func_70302_i_() {
        return 54;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.RAILGUN;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return is.func_77973_b() instanceof RailGunAmmo;
    }

    @Override
    public int getMaxRange() {
        return 256;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    protected boolean isValidTarget(Entity ent) {
        if (ent.field_70128_L) {
            return false;
        }
        if (ent instanceof TargetEntity) {
            return ((TargetEntity)ent).shouldTarget((TileEntity)this, this.placerUUID);
        }
        if (!(ent instanceof EntityLivingBase)) {
            return false;
        }
        EntityLivingBase elb = (EntityLivingBase)ent;
        return elb.func_110143_aJ() > 0.0f && this.isMobOrUnlistedPlayer(elb);
    }

    private static RailGunAmmo.RailGunAmmoType getAmmo(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (is.func_77973_b() instanceof RailGunAmmo) {
            return ((RailGunAmmo)is.func_77973_b()).getAmmo(is);
        }
        return null;
    }
}

