/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.World;

import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPotionHelper;
import Reika.RotaryCraft.API.Interfaces.CustomPotion;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityAerosolizer
extends InventoriedPowerReceiver
implements RangedEffect,
ConditionalOperation,
IFluidHandler {
    public static final int MAXRANGE = Math.max(64, ConfigRegistry.AERORANGE.getValue());
    public static final int CAPACITY = 64;
    private PotionApplication[] potions = new PotionApplication[9];
    private int[] potionLevel = new int[9];
    private int tickcount2 = 0;
    public boolean idle = false;

    public void testIdle() {
        boolean empty = true;
        for (int i = 0; i < 9; ++i) {
            if (this.potions[i] == null) continue;
            empty = false;
        }
        this.idle = empty;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return itemstack.func_77973_b() == Items.field_151069_bo;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.power = (long)this.omega * (long)this.torque;
        this.getSummativeSidedPower();
        ++this.tickcount;
        ++this.tickcount2;
        this.consumeBottlesAndStorePotions();
        if (this.power < this.MINPOWER) {
            return;
        }
        this.testIdle();
        for (int i = 0; i < 9; ++i) {
            if (this.tickcount2 >= 20 / Math.max(this.getMultiplier(i), 1)) {
                AxisAlignedBB room = this.getRoom(world, x, y, z, meta);
                if (this.potionLevel[i] > 0) {
                    this.dispense2(world, x, y, z, meta, room, i);
                }
                if (i == 8) {
                    this.tickcount2 = 0;
                }
            }
            if (this.tickcount >= 2400 && this.potionLevel[i] > 0) {
                int n = i;
                this.potionLevel[n] = this.potionLevel[n] - 1;
                if (i == 8) {
                    this.tickcount = 0;
                }
            }
            if (this.potionLevel[i] > 0) continue;
            this.potionLevel[i] = 0;
            if (i != 8) continue;
            this.tickcount = 0;
        }
    }

    private void consumeBottlesAndStorePotions() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            int num;
            PotionApplication eff;
            ItemStack inslot = this.func_70301_a(i);
            if (inslot == null || (eff = this.getEffectFromItem(inslot)) == null || !this.tryAddPotionToSlot(i, num = inslot.field_77994_a * eff.amount, eff)) continue;
            this.func_70299_a(i, new ItemStack(Items.field_151069_bo, inslot.field_77994_a, 0));
        }
    }

    private boolean tryAddPotionToSlot(int i, int num, PotionApplication eff) {
        if (this.matchEffects(eff, this.potions[i]) && this.potionLevel[i] + num <= 64) {
            this.potions[i] = eff;
            int n = i;
            this.potionLevel[n] = this.potionLevel[n] + num;
            if (this.potionLevel[i] > 64) {
                this.potionLevel[i] = 64;
            }
            return true;
        }
        return false;
    }

    private boolean matchEffects(PotionApplication eff1, PotionApplication eff2) {
        return eff1 == eff2 || eff1 == null || eff2 == null || eff1.equals(eff2);
    }

    public int getPotionColor(int slot) {
        return this.potions[slot] != null ? 0xFF000000 | this.potions[slot].renderColor : -16777216;
    }

    public int getPotionLevel(int slot) {
        return this.potionLevel[slot];
    }

    private PotionApplication getEffectFromItem(ItemStack is) {
        CustomPotion cp;
        Potion p;
        Item i = is.func_77973_b();
        if (i instanceof ItemPotion) {
            int dmg = is.func_77960_j();
            List li = ((ItemPotion)i).func_77832_l(is);
            for (PotionEffect p2 : li) {
                if (Potion.field_76425_a[p2.func_76456_a()].func_76403_b()) continue;
                boolean extended = PotionHelper.func_77914_a((int)dmg, (int)6);
                boolean level2 = p2.func_76458_c() > 0;
                return new PotionApplication(ReikaJavaLibrary.makeListFrom((Object)new PotionEffect(p2.func_76456_a(), 0)), extended ? 3 : 1, level2 ? 1 : 0);
            }
        } else if (i instanceof CustomPotion && (p = (cp = (CustomPotion)i).getPotion(is)) != null && !p.func_76403_b()) {
            boolean extended = cp.isExtended(is);
            boolean level2 = cp.getAmplifier(is) > 0;
            return new PotionApplication(ReikaJavaLibrary.makeListFrom((Object)new PotionEffect(p.field_76415_H, 0)), extended ? 3 : 1, level2 ? 1 : 0);
        }
        return null;
    }

    public int getLiquidScaled(int par1, int par2) {
        return par2 * par1 / 64;
    }

    private AxisAlignedBB getRoom(World world, int x, int y, int z, int meta) {
        int i;
        int minx = x;
        int maxx = x + 1;
        int miny = y;
        int maxy = y + 1;
        int minz = z;
        int maxz = z + 1;
        boolean exit = false;
        for (i = 1; i < this.getRange() && !exit; ++i) {
            if (world.func_147439_a(x + i, y, z).func_149662_c()) {
                exit = true;
                continue;
            }
            maxx = x + i;
        }
        exit = false;
        for (i = 1; i < this.getRange() && !exit; ++i) {
            if (world.func_147439_a(x - i, y, z).func_149662_c()) {
                exit = true;
                continue;
            }
            minx = x - i;
        }
        exit = false;
        for (i = 1; i < this.getRange() && !exit; ++i) {
            if (world.func_147439_a(x, y + i, z).func_149662_c()) {
                exit = true;
                continue;
            }
            maxy = y + i;
        }
        exit = false;
        for (i = 1; i < this.getRange() && !exit; ++i) {
            if (world.func_147439_a(x, y - i, z).func_149662_c()) {
                exit = true;
                continue;
            }
            miny = x - i;
        }
        exit = false;
        for (i = 1; i < this.getRange() && !exit; ++i) {
            if (world.func_147439_a(x, y, z + i).func_149662_c()) {
                exit = true;
                continue;
            }
            maxz = z + i;
        }
        exit = false;
        for (i = 1; i < this.getRange() && !exit; ++i) {
            if (world.func_147439_a(x, y, z - i).func_149662_c()) {
                exit = true;
                continue;
            }
            minz = z - i;
        }
        exit = false;
        return AxisAlignedBB.func_72330_a((double)minx, (double)miny, (double)minz, (double)maxx, (double)maxy, (double)maxz);
    }

    private void dispense2(World world, int x, int y, int z, int meta, AxisAlignedBB room, int i) {
        List effects;
        if (!this.field_145850_b.field_72995_K && this.potions[i] != null && (effects = this.potions[i].effects) != null && !effects.isEmpty()) {
            List inroom = this.field_145850_b.func_72872_a(EntityLivingBase.class, room);
            for (EntityLivingBase mob : inroom) {
                for (PotionEffect effect : effects) {
                    int id = effect.func_76456_a();
                    int bonus = this.getMultiplier(i) - 1;
                    if (effect.func_76458_c() == 1) {
                        bonus *= 2;
                    }
                    mob.func_70690_d(new PotionEffect(id, 100, effect.func_76458_c() + bonus));
                }
            }
        }
    }

    public int getMultiplier(int i) {
        if (this.potions[i] == null) {
            return 0;
        }
        return this.countCopies(this.potions[i]);
    }

    private int countCopies(PotionApplication p) {
        int c = 0;
        for (int i = 0; i < 9; ++i) {
            PotionApplication in = this.potions[i];
            if (in == null || !in.equals(p)) continue;
            ++c;
        }
        return c;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        for (int i = 0; i < 9; ++i) {
            if (NBT.func_74764_b("potion_" + i)) {
                NBTTagCompound tag = NBT.func_74775_l("potion_" + i);
                this.potions[i] = PotionApplication.readFromNBT(tag);
                continue;
            }
            this.potions[i] = null;
        }
        this.potionLevel = NBT.func_74759_k("levels");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        for (int i = 0; i < 9; ++i) {
            if (this.potions[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            this.potions[i].writeToNBT(tag);
            NBT.func_74782_a("potion_" + i, (NBTBase)tag);
        }
        NBT.func_74783_a("levels", this.potionLevel);
    }

    public int func_70302_i_() {
        return 9;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getRange() {
        return MAXRANGE;
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.AEROSOLIZER;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return is.func_77973_b() == Items.field_151068_bn;
    }

    @Override
    public int getMaxRange() {
        return MAXRANGE;
    }

    public int getRedstoneOverride() {
        return (int)((double)ReikaArrayHelper.sumArray((int[])this.potionLevel) / 576.0 * 15.0);
    }

    @Override
    public boolean areConditionsMet() {
        for (int i = 0; i < this.potionLevel.length; ++i) {
            if (this.potionLevel[i] <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Potions";
    }

    public boolean isValidFluid(Fluid f) {
        return f == FluidRegistry.getFluid((String)"poison") || f == FluidRegistry.getFluid((String)"rc chlorine");
    }

    public boolean canReceiveFrom(ForgeDirection from) {
        return from != ForgeDirection.UP;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (doFill && this.canFill(from, resource.getFluid())) {
            for (int i = 0; i < 9; ++i) {
                PotionApplication eff = this.getEffectFromItem(ReikaPotionHelper.getPotionItem((Potion)Potion.field_76436_u, (boolean)false, (boolean)false, (boolean)false));
                if (!this.tryAddPotionToSlot(i, resource.amount, eff)) continue;
                return resource.amount;
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.isValidFluid(fluid) && this.canReceiveFrom(from);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }

    private static class PotionApplication {
        private final List<PotionEffect> effects;
        private final int amount;
        private final int potionLevel;
        public final int renderColor;

        private PotionApplication(List<PotionEffect> li, int amt, int lvl) {
            this.effects = li;
            this.amount = amt;
            this.potionLevel = lvl;
            Collections.sort(this.effects, ReikaPotionHelper.effectSorter);
            this.renderColor = this.calcColor(this.effects);
        }

        private int calcColor(List<PotionEffect> li) {
            int sum = 0;
            for (PotionEffect p : li) {
                sum += Potion.field_76425_a[p.func_76456_a()].func_76401_j();
            }
            return sum / li.size();
        }

        public void writeToNBT(NBTTagCompound NBT) {
            NBTTagList li = new NBTTagList();
            for (PotionEffect eff : this.effects) {
                NBTTagCompound tag = new NBTTagCompound();
                eff.func_82719_a(tag);
                li.func_74742_a((NBTBase)tag);
            }
            NBT.func_74782_a("effects", (NBTBase)li);
            NBT.func_74768_a("amount", this.amount);
            NBT.func_74768_a("level", this.potionLevel);
            NBT.func_74768_a("color", this.renderColor);
        }

        public static PotionApplication readFromNBT(NBTTagCompound NBT) {
            int amt = NBT.func_74762_e("amount");
            int lvl = NBT.func_74762_e("level");
            int c = NBT.func_74762_e("color");
            ArrayList<PotionEffect> fx = new ArrayList<PotionEffect>();
            NBTTagList li = NBT.func_150295_c("effects", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            for (Object o : li.field_74747_a) {
                NBTTagCompound tag = (NBTTagCompound)o;
                PotionEffect p = PotionEffect.func_82722_b((NBTTagCompound)tag);
                fx.add(p);
            }
            return new PotionApplication(fx, amt, lvl);
        }

        public boolean equals(Object o) {
            if (o instanceof PotionApplication) {
                PotionApplication p = (PotionApplication)o;
                return p.potionLevel == this.potionLevel && this.matchEffects(p);
            }
            return false;
        }

        private boolean matchEffects(PotionApplication p) {
            if (this.effects.size() != p.effects.size()) {
                return false;
            }
            for (int i = 0; i < this.effects.size(); ++i) {
                PotionEffect p1 = this.effects.get(i);
                PotionEffect p2 = p.effects.get(i);
                if (p1.func_76456_a() == p2.func_76456_a() && p1.func_76458_c() == p2.func_76458_c()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return (this.amount | this.potionLevel << 8) << 16 | this.effects.hashCode();
        }
    }
}

