/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.World;

import Reika.DragonAPI.Base.OneSlotMachine;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntitySpringPowered;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityLamp
extends TileEntitySpringPowered
implements InertIInv,
RangedEffect,
OneSlotMachine,
BreakAction {
    private BlockArray light = new BlockArray();
    private boolean canlight;
    public static final int MAXRANGE = 12;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.LAMP;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        boolean red = this.hasRedstoneSignal();
        if (!red) {
            this.updateCoil();
        }
        if (world.field_72995_K) {
            return;
        }
        if (red) {
            this.canlight = false;
        }
        if (!this.canlight) {
            this.goDark();
            return;
        }
        if (this.light.isEmpty()) {
            for (int i = 1; i <= this.getRange(); ++i) {
                if (this.canEditAt(world, x + i, y, z)) {
                    this.light.addBlockCoordinate(x + i, y, z);
                }
                if (this.canEditAt(world, x, y + i, z)) {
                    this.light.addBlockCoordinate(x, y + i, z);
                }
                if (this.canEditAt(world, x, y, z + i)) {
                    this.light.addBlockCoordinate(x, y, z + i);
                }
                if (this.canEditAt(world, x - i, y, z)) {
                    this.light.addBlockCoordinate(x - i, y, z);
                }
                if (this.canEditAt(world, x, y - i, z)) {
                    this.light.addBlockCoordinate(x, y - i, z);
                }
                if (!this.canEditAt(world, x, y, z - i)) continue;
                this.light.addBlockCoordinate(x, y, z - i);
            }
            int r = 2;
            while ((double)r <= (double)this.getRange() * 0.8) {
                if (this.canEditAt(world, x + r, y, z + r)) {
                    this.light.addBlockCoordinate(x + r, y, z + r);
                }
                if (this.canEditAt(world, x - r, y, z + r)) {
                    this.light.addBlockCoordinate(x - r, y, z + r);
                }
                if (this.canEditAt(world, x + r, y, z - r)) {
                    this.light.addBlockCoordinate(x + r, y, z - r);
                }
                if (this.canEditAt(world, x - r, y, z - r)) {
                    this.light.addBlockCoordinate(x - r, y, z - r);
                }
                if (this.canEditAt(world, x + r, y + r, z + r)) {
                    this.light.addBlockCoordinate(x + r, y + r, z + r);
                }
                if (this.canEditAt(world, x - r, y + r, z + r)) {
                    this.light.addBlockCoordinate(x - r, y + r, z + r);
                }
                if (this.canEditAt(world, x + r, y + r, z - r)) {
                    this.light.addBlockCoordinate(x + r, y + r, z - r);
                }
                if (this.canEditAt(world, x - r, y + r, z - r)) {
                    this.light.addBlockCoordinate(x - r, y + r, z - r);
                }
                if (this.canEditAt(world, x + r, y - r, z + r)) {
                    this.light.addBlockCoordinate(x + r, y - r, z + r);
                }
                if (this.canEditAt(world, x - r, y - r, z + r)) {
                    this.light.addBlockCoordinate(x - r, y - r, z + r);
                }
                if (this.canEditAt(world, x + r, y - r, z - r)) {
                    this.light.addBlockCoordinate(x + r, y - r, z - r);
                }
                if (this.canEditAt(world, x - r, y - r, z - r)) {
                    this.light.addBlockCoordinate(x - r, y - r, z - r);
                }
                r += 2;
            }
            return;
        }
        for (int n = 0; n < this.light.getSize(); ++n) {
            Coordinate c = this.light.getNthBlock(n);
            if (c.getBlock((IBlockAccess)world) == Blocks.field_150350_a) {
                c.setBlock(world, BlockRegistry.LIGHT.getBlockInstance(), 15);
            }
            this.field_145850_b.func_147451_t(c.xCoord, c.yCoord, c.zCoord);
        }
    }

    public boolean canEditAt(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        return id == Blocks.field_150350_a || id.isAir((IBlockAccess)world, x, y, z);
    }

    private void goDark() {
        for (int n = 0; n < this.light.getSize(); ++n) {
            Coordinate c = this.light.getNthBlock(n);
            if (c.getBlock((IBlockAccess)this.field_145850_b) == BlockRegistry.LIGHT.getBlockInstance()) {
                c.setBlock(this.field_145850_b, Blocks.field_150350_a);
            }
            this.field_145850_b.func_147451_t(c.xCoord, c.yCoord, c.zCoord);
        }
    }

    private void updateCoil() {
        if (!this.hasCoil()) {
            this.canlight = false;
            return;
        }
        ++this.tickcount;
        if (this.tickcount > this.getUnwindTime()) {
            ItemStack is;
            this.inv[0] = is = this.getDecrementedCharged();
            this.tickcount = 0;
        }
        this.canlight = true;
    }

    @Override
    public int getRange() {
        return this.getMaxRange();
    }

    @Override
    public int getMaxRange() {
        return 12;
    }

    private void clearAll() {
        for (int k = 0; k < this.light.getSize(); ++k) {
            Coordinate c = this.light.getNthBlock(k);
            c.setBlock(this.field_145850_b, Blocks.field_150350_a);
        }
    }

    @Override
    public int getBaseDischargeTime() {
        return 120;
    }

    public void breakBlock() {
        this.clearAll();
    }
}

