/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.World;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.ColumnArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.ObjectWeb;
import Reika.DragonAPI.Instantiable.ItemReq;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.SelectableTiles;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerLiquidReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import buildcraft.api.core.IAreaProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityTerraformer
extends InventoriedPowerLiquidReceiver
implements SelectableTiles,
DiscreteFunction {
    private static final ObjectWeb<BiomeGenBase> transforms = new ObjectWeb();
    private static final HashMap<BiomeStep, Collection<ItemReq>> itemReqs = new HashMap();
    private static final HashMap<BiomeStep, Integer> powerReqs = new HashMap();
    private static final HashMap<BiomeStep, FluidStack> liquidReqs = new HashMap();
    private final ColumnArray coords = new ColumnArray();
    private Comparator<Coordinate> positionComparator;
    private BiomeGenBase target;

    public int func_70302_i_() {
        return 54;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        return true;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.TERRAFORMER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.positionComparator = new PositionComparator(this);
        this.getCoordsFromIAP(world, x, y, z);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getSummativeSidedPower();
        ++this.tickcount;
        if (this.coords.isEmpty()) {
            return;
        }
        if (!this.hasRedstoneSignal()) {
            return;
        }
        if (this.tickcount >= this.getOperationTime()) {
            int index = rand.nextInt(this.coords.getSize());
            Coordinate xz = this.coords.getNthColumn(index);
            if (!world.field_72995_K) {
                if (this.setBiome(world, xz.xCoord, xz.zCoord)) {
                    this.coords.remove(index);
                }
                this.tickcount = 0;
            }
        }
    }

    private void getCoordsFromIAP(World world, int x, int y, int z) {
        this.coords.clear();
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            TileEntity te = world.func_147438_o(dx, dy, dz);
            if (!InterfaceCache.AREAPROVIDER.instanceOf((Object)te)) continue;
            this.readIAP(te);
            this.coords.sort(this.positionComparator);
            return;
        }
    }

    @DependentMethodStripper.ClassDependent(value="buildcraft.api.core.IAreaProvider")
    private void readIAP(TileEntity te) {
        IAreaProvider iap = (IAreaProvider)te;
        for (int mx = iap.xMin(); mx <= iap.xMax(); ++mx) {
            for (int mz = iap.zMin(); mz <= iap.zMax(); ++mz) {
                this.addCoordinate(mx, mz, false);
            }
        }
        iap.removeFromWorld();
    }

    @Override
    public int[] getUniqueID() {
        return new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    private boolean setBiome(World world, int x, int z) {
        if (!world.field_72995_K && !ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)world), (int)x, (int)this.field_145848_d, (int)z, (EntityPlayerMP)this.getServerPlacer())) {
            return false;
        }
        BiomeGenBase from = world.func_72807_a(x, z);
        if (!this.isValidTarget(from)) {
            return false;
        }
        if (!DragonAPICore.debugtest && !this.getReqsForTransform(from, this.target)) {
            return false;
        }
        if (this.modifyBlocks()) {
            ReikaWorldHelper.setBiomeAndBlocksForXZ((World)world, (int)x, (int)z, (BiomeGenBase)this.target, (boolean)true);
        } else {
            ReikaWorldHelper.setBiomeForXZ((World)world, (int)x, (int)z, (BiomeGenBase)this.target, (boolean)true);
        }
        return true;
    }

    public boolean modifyBlocks() {
        return ConfigRegistry.BIOMEBLOCKS.getState() && ReikaInventoryHelper.checkForItem((Item)Items.field_151045_i, (ItemStack[])this.inv);
    }

    private void addCoordinate(int x, int z, boolean sort) {
        if (this.hasRedstoneSignal()) {
            return;
        }
        BiomeGenBase biome = this.field_145850_b.func_72807_a(x, z);
        if (this.coords.add(x, z)) {
            RotaryCraft.logger.debug((Object)("Added coordinate " + x + "x, " + z + "z to " + this));
            if (sort) {
                this.coords.sort(this.positionComparator);
            }
        }
    }

    @Override
    public void addTile(int x, int y, int z) {
        this.addCoordinate(x, z, true);
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    private boolean isValidTarget(BiomeGenBase from) {
        return transforms.isDirectionallyConnectedTo((Object)from, (Object)this.target);
    }

    public FluidStack getReqLiquidForTransform(BiomeGenBase from, BiomeGenBase to) {
        BiomeStep li = new BiomeStep(from, to);
        FluidStack liq = liquidReqs.get(li);
        return liq;
    }

    public ArrayList<ItemStack> getItemsForTransform(BiomeGenBase from, BiomeGenBase to) {
        BiomeStep li = new BiomeStep(from, to);
        ArrayList<ItemStack> is = new ArrayList<ItemStack>();
        Collection<ItemReq> req = itemReqs.get(li);
        if (req != null) {
            for (ItemReq r : req) {
                is.add(r.asItemStack());
            }
        }
        return is;
    }

    private boolean getReqsForTransform(BiomeGenBase from, BiomeGenBase to) {
        BiomeStep li = new BiomeStep(from, to);
        int min = powerReqs.get(li);
        FluidStack liq = liquidReqs.get(li);
        Collection<ItemReq> items = itemReqs.get(li);
        if (this.power < (long)min) {
            return false;
        }
        if (liq != null && this.tank.getLevel() < liq.amount) {
            return false;
        }
        if (items != null) {
            for (ItemReq is : items) {
                if (ReikaInventoryHelper.checkForItemStack((Item)is.itemID, (int)is.metadata, (ItemStack[])this.inv)) continue;
                return false;
            }
            for (ItemReq is : items) {
                if (!is.callAndConsume()) continue;
                int slot = ReikaInventoryHelper.locateInInventory((Item)is.itemID, (int)is.metadata, (ItemStack[])this.inv);
                ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
            }
        }
        if (liq != null) {
            this.tank.removeLiquid(liq.amount);
        }
        return true;
    }

    private static void addBiomeTransformation(BiomeGenBase from, BiomeGenBase to, int power, FluidStack liq, ItemReq ... items) {
        ArrayList<BiomeGenBase> li = new ArrayList<BiomeGenBase>();
        li.add(from);
        li.addAll(ReikaBiomeHelper.getChildBiomes((BiomeGenBase)from));
        for (BiomeGenBase from_ : li) {
            BiomeStep step = new BiomeStep(from_, to);
            transforms.addDirectionalConnection((Object)from_, (Object)to);
            itemReqs.put(step, ReikaJavaLibrary.makeListFromArray((Object[])items));
            powerReqs.put(step, power);
            liquidReqs.put(step, liq);
        }
    }

    public BiomeGenBase getTarget() {
        return this.target;
    }

    public void setTarget(BiomeGenBase tg) {
        this.target = tg;
    }

    public Collection<BiomeGenBase> getValidTargetBiomes(BiomeGenBase start) {
        return transforms.getChildren((Object)start);
    }

    public BiomeGenBase getCentralBiome() {
        return this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        int tg = NBT.func_74762_e("tg");
        if (tg != -1) {
            this.target = BiomeGenBase.field_76773_a[tg];
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.target != null) {
            NBT.func_74768_a("tg", this.target.field_76756_M);
        } else {
            NBT.func_74768_a("tg", -1);
        }
    }

    public static ArrayList<BiomeTransform> getTransformList() {
        ArrayList<BiomeTransform> li = new ArrayList<BiomeTransform>();
        for (int i = 0; i < BiomeGenBase.field_76773_a.length; ++i) {
            BiomeGenBase start = BiomeGenBase.field_76773_a[i];
            if (!transforms.hasNode((Object)start)) continue;
            Collection tgs = transforms.getChildren((Object)start);
            for (BiomeGenBase to : tgs) {
                BiomeStep step = new BiomeStep(start, to);
                long power = powerReqs.get(step).intValue();
                FluidStack fs = liquidReqs.get(step);
                Collection<ItemReq> items = itemReqs.get(step);
                li.add(new BiomeTransform(step, power, fs, items));
            }
        }
        return li;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public Fluid getInputFluid() {
        return FluidRegistry.WATER;
    }

    @Override
    public int getCapacity() {
        return 24000;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return true;
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.TERRAFORMER.getOperationTime(this.omega);
    }

    static {
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76769_d, BiomeGenBase.field_150588_X, 65536, FluidRegistry.getFluidStack((String)"water", (int)30), new ItemReq((Block)Blocks.field_150329_H, 1, 0.5f), new ItemReq(Blocks.field_150345_g, 4, 0.05f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_150588_X, BiomeGenBase.field_76772_c, 32768, FluidRegistry.getFluidStack((String)"water", (int)20), new ItemReq((Block)Blocks.field_150329_H, 1, 0.3f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76772_c, BiomeGenBase.field_76767_f, 131072, FluidRegistry.getFluidStack((String)"water", (int)10), new ItemReq(Blocks.field_150345_g, 0, 0.5f), new ItemReq(Blocks.field_150345_g, 2, 0.2f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76767_f, BiomeGenBase.field_76782_w, 262144, FluidRegistry.getFluidStack((String)"water", (int)50), new ItemReq(Blocks.field_150345_g, 0, 0.4f), new ItemReq(Blocks.field_150345_g, 0, 0.6f), new ItemReq((Block)Blocks.field_150329_H, 2, 0.3f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76772_c, BiomeGenBase.field_76780_h, 32768, FluidRegistry.getFluidStack((String)"water", (int)100), new ItemReq(Blocks.field_150345_g, 0, 0.1f), new ItemReq((Block)Blocks.field_150337_Q, 0.05f), new ItemReq((Block)Blocks.field_150338_P, 0.15f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76780_h, BiomeGenBase.field_76771_b, 131072, FluidRegistry.getFluidStack((String)"water", (int)500), new ItemReq[0]);
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76771_b, BiomeGenBase.field_76776_l, 1024, null, new ItemReq(Blocks.field_150432_aD, 1.0f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76772_c, BiomeGenBase.field_76770_e, 65536, null, new ItemReq(Blocks.field_150345_g, 0, 0.05f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76772_c, BiomeGenBase.field_76774_n, 8192, null, new ItemReq(Blocks.field_150433_aE, 1.0f), new ItemReq(Blocks.field_150345_g, 0, 0.05f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76774_n, BiomeGenBase.field_76772_c, 524288, null, new ItemReq((Block)Blocks.field_150329_H, 1, 0.7f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76771_b, BiomeGenBase.field_76789_p, 0x100000, null, new ItemReq(Blocks.field_150346_d, 1.0f), new ItemReq((Block)Blocks.field_150391_bh, 1.0f), new ItemReq((Block)Blocks.field_150337_Q, 0.9f), new ItemReq((Block)Blocks.field_150338_P, 0.9f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76789_p, BiomeGenBase.field_76770_e, 262144, null, new ItemReq((Block)Blocks.field_150349_c, 0.125f), new ItemReq(Blocks.field_150345_g, 0, 0.05f), new ItemReq((Block)Blocks.field_150329_H, 1, 0.25f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76767_f, BiomeGenBase.field_76768_g, 131072, null, new ItemReq(Blocks.field_150345_g, 1, 0.25f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76767_f, BiomeGenBase.field_150584_S, 131072, null, new ItemReq(Blocks.field_150433_aE, 0.3f), new ItemReq(Blocks.field_150345_g, 1, 0.25f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76767_f, BiomeGenBase.field_150585_R, 65536, FluidRegistry.getFluidStack((String)"water", (int)40), new ItemReq(Blocks.field_150345_g, 5, 0.5f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76767_f, BiomeGenBase.field_150583_P, 32768, null, new ItemReq(Blocks.field_150345_g, 2, 0.25f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76768_g, BiomeGenBase.field_150584_S, 32768, null, new ItemReq(Blocks.field_150433_aE, 0.3f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76768_g, BiomeGenBase.field_76774_n, 65536, null, new ItemReq(Blocks.field_150433_aE, 1.0f), new ItemReq(Blocks.field_150345_g, 0, 0.05f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76768_g, BiomeGenBase.field_76767_f, 131072, null, new ItemReq(Blocks.field_150345_g, 0, 0.4f), new ItemReq(Blocks.field_150345_g, 2, 0.1f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76768_g, BiomeGenBase.field_150578_U, 32768, FluidRegistry.getFluidStack((String)"water", (int)20), new ItemReq(Blocks.field_150345_g, 1, 0.1f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76774_n, BiomeGenBase.field_76776_l, 32768, FluidRegistry.getFluidStack((String)"water", (int)100), new ItemReq(Blocks.field_150432_aD, 1.0f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76772_c, BiomeGenBase.field_150588_X, 65536, null, new ItemReq(Blocks.field_150345_g, 4, 0.05f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_150588_X, BiomeGenBase.field_76769_d, 65536, null, new ItemReq((Block)Blocks.field_150354_m, 1.0f), new ItemReq(Blocks.field_150322_A, 0.5f), new ItemReq(Blocks.field_150434_aF, 0.1f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76767_f, BiomeGenBase.field_76772_c, 262144, null, new ItemReq((Block)Blocks.field_150329_H, 1, 0.8f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76782_w, BiomeGenBase.field_76767_f, 65536, null, new ItemReq(Blocks.field_150345_g, 0, 0.5f), new ItemReq(Blocks.field_150345_g, 2, 0.2f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76780_h, BiomeGenBase.field_76772_c, 262144, null, new ItemReq((Block)Blocks.field_150329_H, 1, 0.8f), new ItemReq(Blocks.field_150346_d, 0.8f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76771_b, BiomeGenBase.field_76780_h, 524288, null, new ItemReq(Blocks.field_150345_g, 0, 0.1f), new ItemReq((Block)Blocks.field_150337_Q, 0.05f), new ItemReq((Block)Blocks.field_150338_P, 0.15f), new ItemReq((Block)Blocks.field_150349_c, 0.125f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76776_l, BiomeGenBase.field_76771_b, 524288, null, new ItemReq[0]);
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76770_e, BiomeGenBase.field_76772_c, 262144, null, new ItemReq((Block)Blocks.field_150329_H, 1, 0.6f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76774_n, BiomeGenBase.field_76768_g, 65536, null, new ItemReq(Blocks.field_150345_g, 1, 0.4f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76776_l, BiomeGenBase.field_76774_n, 65536, null, new ItemReq(Blocks.field_150345_g, 0, 0.05f), new ItemReq(Blocks.field_150346_d, 1.0f), new ItemReq((Block)Blocks.field_150349_c, 0.125f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76769_d, BiomeGenBase.field_150589_Z, 32768, null, new ItemReq(Blocks.field_150435_aG, 0.2f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_76771_b, BiomeGenBase.field_150575_M, 1024, FluidRegistry.getFluidStack((String)"water", (int)200), new ItemReq[0]);
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_150589_Z, BiomeGenBase.field_76769_d, 16384, null, new ItemReq((Block)Blocks.field_150354_m, 0.5f), new ItemReq(Blocks.field_150322_A, 0.1f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_150585_R, BiomeGenBase.field_76767_f, 32768, null, new ItemReq(Blocks.field_150345_g, 0, 0.5f), new ItemReq(Blocks.field_150345_g, 2, 0.2f));
        TileEntityTerraformer.addBiomeTransformation(BiomeGenBase.field_150583_P, BiomeGenBase.field_76767_f, 32768, null, new ItemReq(Blocks.field_150345_g, 0, 0.5f));
    }

    private static class PositionComparator
    implements Comparator<Coordinate> {
        private final Coordinate origin;

        private PositionComparator(TileEntityTerraformer te) {
            this.origin = new Coordinate((TileEntity)te);
        }

        @Override
        public int compare(Coordinate o1, Coordinate o2) {
            if (o1.equals((Object)o2)) {
                return 0;
            }
            if (o1.equals((Object)this.origin)) {
                return Integer.MAX_VALUE;
            }
            if (o2.equals((Object)this.origin)) {
                return Integer.MIN_VALUE;
            }
            return o1.xCoord + o1.zCoord - (o2.xCoord + o2.zCoord);
        }
    }

    public static final class BiomeTransform {
        public final BiomeStep change;
        public final long power;
        private final FluidStack fluid;
        private final Collection<ItemReq> items;

        private BiomeTransform(BiomeStep step, long power, FluidStack fs, Collection<ItemReq> li) {
            this.change = step;
            this.power = power;
            this.fluid = fs;
            this.items = li;
        }

        public FluidStack getFluid() {
            return this.fluid != null ? this.fluid.copy() : null;
        }

        public Collection<ItemReq> getItems() {
            return Collections.unmodifiableCollection(this.items);
        }
    }

    public static final class BiomeStep {
        public final BiomeGenBase start;
        public final BiomeGenBase finish;

        private BiomeStep(BiomeGenBase in, BiomeGenBase out) {
            this.start = in;
            this.finish = out;
        }

        public int hashCode() {
            return this.start.hashCode() ^ this.finish.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof BiomeStep) {
                BiomeStep b = (BiomeStep)o;
                return b.start == this.start && b.finish == this.finish;
            }
            return false;
        }
    }
}

