/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.World;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.RotaryCraft.API.Event.WeatherControlEvent;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityWeatherController
extends InventoriedPowerReceiver
implements ConditionalOperation {
    private int cooldown = 0;
    private RainMode rainmode = RainMode.NONE;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.power < this.MINPOWER) {
            return;
        }
        if (!world.func_72937_j(x, y + 1, z)) {
            return;
        }
        WorldInfo wi = world.func_72912_H();
        if (this.rainmode == RainMode.SUPERSTORM) {
            wi.func_76084_b(true);
            wi.func_76069_a(true);
            if (rand.nextInt(20) == 0) {
                int xl = x - 64 + rand.nextInt(129);
                int zl = z - 64 + rand.nextInt(129);
                int yl = world.func_72825_h(xl, zl);
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)xl, (double)yl, (double)zl));
            }
        }
        if (this.cooldown > 0) {
            return;
        }
        this.rainmode = this.getRainMode();
        if (this.rainmode.isRain() && ConfigRegistry.BANRAIN.getState()) {
            this.rainmode = RainMode.NONE;
        }
        if (this.isAlready(world, this.rainmode)) {
            return;
        }
        if (!this.rainmode.hasAction()) {
            return;
        }
        boolean isThunder = world.func_72911_I();
        boolean rain = this.rainmode.isRain();
        boolean thunder = this.rainmode.isThunder();
        boolean storm = this.rainmode == RainMode.SUPERSTORM;
        wi.func_76084_b(rain);
        wi.func_76069_a(thunder);
        MinecraftForge.EVENT_BUS.post((Event)new WeatherControlEvent((TileEntity)this, rain, thunder, storm));
    }

    private boolean isAlready(World world, RainMode m) {
        boolean rain = m.isRain();
        boolean thunder = m.isThunder();
        boolean rain2 = world.func_72896_J();
        boolean thunder2 = world.func_72911_I();
        return rain == rain2 && thunder == thunder2;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    private void fire(ItemStack is, ItemStack is2) {
        EntityItem ei;
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.explode", 1.0f, 1.0f);
        if (is != null) {
            ei = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0625, (double)this.field_145849_e + 0.5, new ItemStack(is.func_77973_b(), 1, is.func_77960_j()));
            ReikaEntityHelper.addRandomDirVelocity((Entity)ei, (double)0.2);
            ei.field_145804_b = 5000;
            ei.field_70292_b = 5900;
            ei.field_70181_x = 3.0;
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72838_d((Entity)ei);
            }
        }
        if (is2 != null) {
            ei = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0625, (double)this.field_145849_e + 0.5, ReikaItemHelper.getSizedItemStack((ItemStack)is2, (int)1));
            ReikaEntityHelper.addRandomDirVelocity((Entity)ei, (double)0.2);
            ei.field_145804_b = 5000;
            ei.field_70292_b = 5900;
            ei.field_70181_x = 3.0;
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72838_d((Entity)ei);
            }
        }
    }

    private int hasSawdust() {
        int sawdust = ReikaInventoryHelper.locateInInventory((ItemStack)ItemStacks.sawdust, (ItemStack[])this.inv, (boolean)false);
        if (sawdust >= 0) {
            return sawdust;
        }
        ArrayList li = OreDictionary.getOres((String)"dustWood");
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack is = this.inv[i];
            if (is == null || !ReikaItemHelper.collectionContainsItemStack((Collection)li, (ItemStack)is)) continue;
            return i;
        }
        return -1;
    }

    private RainMode getRainMode() {
        RainMode rainmode;
        ItemStack is = null;
        ItemStack is2 = null;
        int sawdust = this.hasSawdust();
        boolean silverio = ReikaInventoryHelper.checkForItemStack((ItemStack)ItemStacks.silveriodide, (ItemStack[])this.inv, (boolean)false);
        boolean redstone = ReikaInventoryHelper.checkForItem((Item)Items.field_151137_ax, (ItemStack[])this.inv);
        boolean glowdust = ReikaInventoryHelper.checkForItem((Item)Items.field_151114_aO, (ItemStack[])this.inv);
        if (sawdust >= 0) {
            rainmode = RainMode.SUN;
            is = ItemStacks.sawdust;
        } else if (silverio) {
            rainmode = RainMode.RAIN;
            is = ItemStacks.silveriodide;
            if (redstone) {
                rainmode = RainMode.THUNDER;
                is2 = new ItemStack(Items.field_151137_ax, 1, 0);
            } else if (glowdust) {
                rainmode = RainMode.SUPERSTORM;
                is2 = new ItemStack(Items.field_151114_aO, 1, 0);
            }
        } else {
            rainmode = RainMode.NONE;
        }
        if (this.isAlready(this.field_145850_b, rainmode)) {
            return this.rainmode;
        }
        this.cooldown = 200 + rand.nextInt(400);
        if (rainmode.hasAction()) {
            this.fire(is, is2);
        }
        int slot = -1;
        switch (rainmode) {
            case NONE: {
                break;
            }
            case SUN: {
                slot = sawdust;
                ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
                break;
            }
            case RAIN: {
                slot = ReikaInventoryHelper.locateInInventory((ItemStack)ItemStacks.silveriodide, (ItemStack[])this.inv, (boolean)false);
                ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
                break;
            }
            case THUNDER: {
                slot = ReikaInventoryHelper.locateInInventory((ItemStack)ItemStacks.silveriodide, (ItemStack[])this.inv, (boolean)false);
                ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
                slot = ReikaInventoryHelper.locateInInventory((Item)Items.field_151137_ax, (ItemStack[])this.inv);
                ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
                break;
            }
            case SUPERSTORM: {
                slot = ReikaInventoryHelper.locateInInventory((ItemStack)ItemStacks.silveriodide, (ItemStack[])this.inv, (boolean)false);
                ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
                slot = ReikaInventoryHelper.locateInInventory((Item)Items.field_151114_aO, (ItemStack[])this.inv);
                ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
            }
        }
        return rainmode;
    }

    private boolean isValidWeatherItem(ItemStack is) {
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.sawdust)) {
            return true;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.silveriodide)) {
            return true;
        }
        if (is.func_77973_b() == Items.field_151137_ax) {
            return true;
        }
        if (is.func_77973_b() == Items.field_151114_aO) {
            return true;
        }
        ArrayList li = OreDictionary.getOres((String)"dustWood");
        return ReikaItemHelper.collectionContainsItemStack((Collection)li, (ItemStack)is);
    }

    public int func_70302_i_() {
        return 18;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.WEATHERCONTROLLER;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return this.isValidWeatherItem(is);
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public boolean areConditionsMet() {
        return this.getRainMode().hasAction();
    }

    @Override
    public String getOperationalStatus() {
        return this.cooldown <= 0 ? (this.areConditionsMet() ? "Operational" : "Empty Inventory") : "Idle";
    }

    private static enum RainMode {
        NONE,
        SUN,
        RAIN,
        THUNDER,
        SUPERSTORM;


        public boolean isRain() {
            return this.ordinal() > SUN.ordinal();
        }

        public boolean isThunder() {
            return this.ordinal() > RAIN.ordinal();
        }

        public boolean hasAction() {
            return this != NONE;
        }
    }
}

