/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.api.AEApi;
import appeng.api.config.CraftingMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.core.AELog;
import appeng.core.sync.GuiBridge;
import appeng.me.cache.CraftingGridCache;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import com.github.vfyjxf.nee.block.tile.TilePatternInterface;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.util.BlockPos;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.p455w0rd.wirelesscraftingterminal.common.WCTGuiHandler;
import thaumicenergistics.common.ThEGuiHandler;
import thaumicenergistics.common.container.ContainerPartArcaneCraftingTerminal;

public class PacketCraftingRequest
implements IMessage {
    public static int COMMAND_CREATE_PATTERN = 0;
    public static int COMMAND_REMOVE_PATTERN = 1;
    public static int COMMAND_OPEN_CRAFT_CONFIRM = 2;
    private String modID = "";
    private int command = 3;
    private NBTTagCompound compound;
    private boolean isAutoStart;
    private int craftAmount;

    public PacketCraftingRequest() {
    }

    public PacketCraftingRequest(String modID, int command, NBTTagCompound compound, int craftAmount, boolean isAutoStart) {
        this.modID = modID;
        this.command = command;
        this.compound = compound;
        this.craftAmount = craftAmount;
        this.isAutoStart = isAutoStart;
    }

    public boolean isAutoStart() {
        return this.isAutoStart;
    }

    public void setIsAutoStart(boolean isAutoStart) {
        this.isAutoStart = isAutoStart;
    }

    public int getCraftAmount() {
        return Math.max(1, this.craftAmount);
    }

    public void setCraftAmount(int craftAmount) {
        this.craftAmount = craftAmount;
    }

    public void getModID(String modID) {
        this.modID = modID;
    }

    public void fromBytes(ByteBuf buf) {
        this.modID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.command = buf.readInt();
        this.compound = ByteBufUtils.readTag((ByteBuf)buf);
        this.isAutoStart = buf.readBoolean();
        this.craftAmount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modID);
        buf.writeInt(this.command);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.compound);
        buf.writeBoolean(this.isAutoStart);
        buf.writeInt(this.craftAmount);
    }

    public void openCraftConfirm(Container container, IGrid grid, IAEItemStack requireToCraftStack, EntityPlayerMP player) {
        if (Loader.isModLoaded((String)"thaumicenergistics") && this.modID.equals("thaumicenergistics") && container instanceof ContainerPartArcaneCraftingTerminal) {
            ContainerPartArcaneCraftingTerminal cpact = (ContainerPartArcaneCraftingTerminal)container;
            this.openTHContainerCraftConfirm(grid, requireToCraftStack, (IActionHost)cpact.terminal, player);
        } else if (container instanceof AEBaseContainer) {
            AEBaseContainer baseContainer = (AEBaseContainer)container;
            if (Loader.isModLoaded((String)"thaumicenergistics") && this.modID.equals("thaumicenergistics")) {
                this.openTHContainerCraftConfirm(grid, requireToCraftStack, (IActionHost)baseContainer.getTarget(), player);
            } else if (Loader.isModLoaded((String)"ae2fc") && this.modID.equals("ae2fc")) {
                this.openFCContainerCraftConfirm(baseContainer, grid, requireToCraftStack, player);
            } else if (Loader.isModLoaded((String)"ae2wct") && this.modID.equals("ae2wct")) {
                this.openWCTContainerCraftConfirm(baseContainer, grid, requireToCraftStack, player);
            } else {
                this.openAEContainerCraftConfirm(baseContainer, grid, requireToCraftStack, player);
            }
        }
    }

    private void openContainerCraftConfirm(IGrid grid, IAEItemStack requireToCraftStack, EntityPlayerMP player, BaseActionSource actionSource, Consumer<Future<ICraftingJob>> consumer) {
        Future futureJob = null;
        try {
            ICraftingGrid cg = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
            if (cg instanceof CraftingGridCache) {
                CraftingGridCache cgc = (CraftingGridCache)cg;
                futureJob = cgc.beginCraftingJob(player.field_70170_p, grid, actionSource, requireToCraftStack, CraftingMode.STANDARD, null);
            } else {
                futureJob = cg.beginCraftingJob(player.field_70170_p, grid, actionSource, requireToCraftStack, null);
            }
            consumer.accept(futureJob);
            Container container = player.field_71070_bA;
            if (container instanceof ContainerCraftConfirm) {
                ContainerCraftConfirm ccc = (ContainerCraftConfirm)container;
                ccc.setItemToCraft(requireToCraftStack);
                ccc.setJob(futureJob);
                ccc.setAutoStart(this.isAutoStart);
                ccc.func_75142_b();
            }
        }
        catch (Throwable e) {
            if (futureJob != null) {
                futureJob.cancel(true);
            }
            AELog.debug((Throwable)e);
        }
    }

    private void openAEContainerCraftConfirm(AEBaseContainer baseContainer, IGrid grid, IAEItemStack requireToCraftStack, EntityPlayerMP player) {
        this.openContainerCraftConfirm(grid, requireToCraftStack, player, baseContainer.getActionSource(), job -> {
            ContainerOpenContext openContext = baseContainer.getOpenContext();
            Platform.openGUI((EntityPlayer)player, (TileEntity)openContext.getTile(), (ForgeDirection)openContext.getSide(), (GuiBridge)GuiBridge.GUI_CRAFTING_CONFIRM);
        });
    }

    @Optional.Method(modid="thaumicenergistics")
    private void openTHContainerCraftConfirm(IGrid grid, IAEItemStack requireToCraftStack, IActionHost host, EntityPlayerMP player) {
        this.openContainerCraftConfirm(grid, requireToCraftStack, player, (BaseActionSource)new PlayerSource((EntityPlayer)player, host), job -> ThEGuiHandler.launchGui((int)90, (EntityPlayer)player, (World)player.field_70170_p, (int)0, (int)0, (int)0));
    }

    @Optional.Method(modid="ae2fc")
    private void openFCContainerCraftConfirm(AEBaseContainer baseContainer, IGrid grid, IAEItemStack requireToCraftStack, EntityPlayerMP player) {
        this.openContainerCraftConfirm(grid, requireToCraftStack, player, baseContainer.getActionSource(), job -> {
            ContainerOpenContext openContext = baseContainer.getOpenContext();
            TileEntity tileEntity = openContext.getTile();
            if (tileEntity != null) {
                InventoryHandler.openGui((EntityPlayer)player, (World)player.field_70170_p, (BlockPos)new BlockPos(tileEntity), (ForgeDirection)Objects.requireNonNull(openContext.getSide()), (GuiType)GuiType.FLUID_CRAFTING_CONFIRM);
            } else {
                Object patt13672$temp = baseContainer.getTarget();
                if (patt13672$temp instanceof IWirelessTerminal) {
                    IWirelessTerminal wireless = (IWirelessTerminal)patt13672$temp;
                    InventoryHandler.openGui((EntityPlayer)player, (World)player.field_70170_p, (BlockPos)new BlockPos(wireless.getInventorySlot(), 0, 0), (ForgeDirection)Objects.requireNonNull(openContext.getSide()), (GuiType)GuiType.FLUID_CRAFTING_CONFIRM_ITEM);
                }
            }
        });
    }

    @Optional.Method(modid="ae2wct")
    private void openWCTContainerCraftConfirm(AEBaseContainer baseContainer, IGrid grid, IAEItemStack requireToCraftStack, EntityPlayerMP player) {
        this.openContainerCraftConfirm(grid, requireToCraftStack, player, baseContainer.getActionSource(), job -> {
            int x = (int)player.field_70165_t;
            int y = (int)player.field_70163_u;
            int z = (int)player.field_70161_v;
            WCTGuiHandler.launchGui((int)3, (EntityPlayer)player, (World)player.field_70170_p, (int)x, (int)y, (int)z);
        });
    }

    public static final class Handler
    implements IMessageHandler<PacketCraftingRequest, IMessage> {
        public IMessage onMessage(PacketCraftingRequest message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            IGrid grid = GuiUtils.getGrid(container);
            if (grid == null) {
                return null;
            }
            ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
            if (security == null || !security.hasPermission((EntityPlayer)player, SecurityPermissions.CRAFT)) {
                return null;
            }
            if (message.command == COMMAND_REMOVE_PATTERN) {
                ItemStack resultStack = ItemStack.func_77949_a((NBTTagCompound)message.compound.func_74775_l("out"));
                if (resultStack != null) {
                    this.removeRecipePattern(grid, resultStack, message.compound, (EntityPlayer)player);
                    container.func_75142_b();
                }
            } else if (message.command == COMMAND_OPEN_CRAFT_CONFIRM) {
                IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
                ItemStack resultStack = ItemStack.func_77949_a((NBTTagCompound)message.compound);
                IAEItemStack requireToCraftStack = this.getrequireToCraftStack((IMEMonitor<IAEItemStack>)inv.getItemInventory(), resultStack);
                if (requireToCraftStack != null) {
                    requireToCraftStack.setStackSize((long)message.getCraftAmount());
                    message.openCraftConfirm(container, grid, requireToCraftStack, player);
                }
            } else if (message.command == COMMAND_CREATE_PATTERN) {
                IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
                ItemStack resultStack = ItemStack.func_77949_a((NBTTagCompound)message.compound.func_74775_l("out"));
                this.createRecipePattern(grid, resultStack, message.compound, (EntityPlayer)player);
                IAEItemStack requireToCraftStack = this.getrequireToCraftStack((IMEMonitor<IAEItemStack>)inv.getItemInventory(), resultStack);
                if (requireToCraftStack != null) {
                    requireToCraftStack.setStackSize((long)message.getCraftAmount());
                    message.openCraftConfirm(container, grid, requireToCraftStack, player);
                }
            }
            return null;
        }

        private IAEItemStack getrequireToCraftStack(IMEMonitor<IAEItemStack> storage, ItemStack resultStack) {
            if (resultStack == null) {
                return null;
            }
            for (IAEItemStack aeStack : storage.getStorageList()) {
                if (!resultStack.func_77969_a(aeStack.getItemStack()) || !aeStack.isCraftable()) continue;
                return aeStack.copy();
            }
            return null;
        }

        private boolean createRecipePattern(IGrid grid, ItemStack resultStack, NBTTagCompound patternValue, EntityPlayer player) {
            ItemStack patternStack = (ItemStack)AEApi.instance().definitions().items().encodedPattern().maybeStack(1).orNull();
            if (patternStack == null) {
                return false;
            }
            for (IGridNode gridNode : grid.getMachines(TilePatternInterface.class)) {
                TilePatternInterface tpi;
                IGridHost iGridHost = gridNode.getMachine();
                if (!(iGridHost instanceof TilePatternInterface) || !(tpi = (TilePatternInterface)iGridHost).getProxy().isActive() || !tpi.canPutPattern(resultStack)) continue;
                patternStack = patternStack.func_77946_l();
                patternStack.func_77982_d(patternValue);
                tpi.putPattern(patternStack);
                return true;
            }
            return false;
        }

        private void removeRecipePattern(IGrid grid, ItemStack resultStack, NBTTagCompound patternValue, EntityPlayer player) {
            for (IGridNode gridNode : grid.getMachines(TilePatternInterface.class)) {
                IGridHost iGridHost = gridNode.getMachine();
                if (!(iGridHost instanceof TilePatternInterface)) continue;
                TilePatternInterface tpi = (TilePatternInterface)iGridHost;
                AppEngInternalInventory inventory = tpi.getPatternInventory();
                for (int slotIndex = 0; slotIndex < inventory.func_70302_i_(); ++slotIndex) {
                    ItemStack patternStack = inventory.func_70301_a(slotIndex);
                    if (patternStack == null || !patternValue.equals((Object)patternStack.func_77978_p())) continue;
                    inventory.func_70299_a(slotIndex, null);
                    tpi.updateCraftingList();
                    return;
                }
            }
        }
    }
}

