/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLine;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjExceptionInternal;

public class ImageLines {
    public final ImageInfo imgInfo;
    public final int channels;
    public final int bitDepth;
    public final ImageLine.SampleType sampleType;
    public final boolean samplesUnpacked;
    public final int elementsPerRow;
    public final int rowOffset;
    public final int nRows;
    public final int rowStep;
    public final int[][] scanlines;
    public final byte[][] scanlinesb;

    public ImageLines(ImageInfo imgInfo, ImageLine.SampleType stype, boolean unpackedMode, int rowOffset, int nRows, int rowStep) {
        this.imgInfo = imgInfo;
        this.channels = imgInfo.channels;
        this.bitDepth = imgInfo.bitDepth;
        this.sampleType = stype;
        this.samplesUnpacked = unpackedMode || !imgInfo.packed;
        this.elementsPerRow = unpackedMode ? imgInfo.samplesPerRow : imgInfo.samplesPerRowPacked;
        this.rowOffset = rowOffset;
        this.nRows = nRows;
        this.rowStep = rowStep;
        if (stype == ImageLine.SampleType.INT) {
            this.scanlines = new int[nRows][this.elementsPerRow];
            this.scanlinesb = null;
        } else if (stype == ImageLine.SampleType.BYTE) {
            this.scanlinesb = new byte[nRows][this.elementsPerRow];
            this.scanlines = null;
        } else {
            throw new PngjExceptionInternal("bad ImageLine initialization");
        }
    }

    public int imageRowToMatrixRow(int imrow) {
        int r = (imrow - this.rowOffset) / this.rowStep;
        return r < 0 ? 0 : (r < this.nRows ? r : this.nRows - 1);
    }

    public int imageRowToMatrixRowStrict(int imrow) {
        int mrow = (imrow -= this.rowOffset) >= 0 && imrow % this.rowStep == 0 ? imrow / this.rowStep : -1;
        return mrow < this.nRows ? mrow : -1;
    }

    public int matrixRowToImageRow(int mrow) {
        return mrow * this.rowStep + this.rowOffset;
    }

    public ImageLine getImageLineAtMatrixRow(int mrow) {
        if (mrow < 0 || mrow > this.nRows) {
            throw new PngjException("Bad row " + mrow + ". Should be positive and less than " + this.nRows);
        }
        ImageLine imline = this.sampleType == ImageLine.SampleType.INT ? new ImageLine(this.imgInfo, this.sampleType, this.samplesUnpacked, this.scanlines[mrow], null) : new ImageLine(this.imgInfo, this.sampleType, this.samplesUnpacked, null, this.scanlinesb[mrow]);
        imline.setRown(this.matrixRowToImageRow(mrow));
        return imline;
    }
}

