/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI;

import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Auxiliary.PacketTypes;
import Reika.DragonAPI.Auxiliary.PopupWriter;
import Reika.DragonAPI.Auxiliary.Trackers.CommandableUpdateChecker;
import Reika.DragonAPI.Auxiliary.Trackers.ConfigMatcher;
import Reika.DragonAPI.Auxiliary.Trackers.KeyWatcher;
import Reika.DragonAPI.Auxiliary.Trackers.ModFileVersionChecker;
import Reika.DragonAPI.Auxiliary.Trackers.ModLockController;
import Reika.DragonAPI.Auxiliary.Trackers.SettingInterferenceTracker;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Command.BiomeMapCommand;
import Reika.DragonAPI.Command.EntityListCommand;
import Reika.DragonAPI.Command.IDDumpCommand;
import Reika.DragonAPI.Command.OreDumpCommand;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Effects.StringParticleFX;
import Reika.DragonAPI.Instantiable.Event.Client.ClientLoginEvent;
import Reika.DragonAPI.Instantiable.Event.Client.ClientLogoutEvent;
import Reika.DragonAPI.Instantiable.Event.Client.PlayerInteractEventClient;
import Reika.DragonAPI.Instantiable.Event.RawKeyPressEvent;
import Reika.DragonAPI.Interfaces.PacketHandler;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class APIPacketHandler
implements PacketHandler {
    private final Random rand = new Random();
    protected PacketIDs pack;

    @Override
    public void handleData(ReikaPacketHelper.PacketObj packet, World world, EntityPlayer ep) {
        int i;
        DataInputStream inputStream = packet.getDataIn();
        int control = Integer.MIN_VALUE;
        int[] data = new int[]{};
        long longdata = 0L;
        float floatdata = 0.0f;
        int x = 0;
        int y = 0;
        int z = 0;
        boolean readinglong = false;
        NBTTagCompound NBT = null;
        String stringdata = null;
        try {
            PacketTypes packetType = packet.getType();
            switch (packetType) {
                case SOUND: {
                    int lib = inputStream.readInt();
                    control = inputStream.readInt();
                    SoundEnum s = ReikaSoundHelper.lookupSound(lib, control);
                    double sx = inputStream.readDouble();
                    double sy = inputStream.readDouble();
                    double sz = inputStream.readDouble();
                    float v = inputStream.readFloat();
                    float p = inputStream.readFloat();
                    boolean att = inputStream.readBoolean();
                    ReikaSoundHelper.playClientSound(s, sx, sy, sz, v, p, att);
                    return;
                }
                case FULLSOUND: {
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    break;
                }
                case STRING: {
                    stringdata = packet.readString();
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    break;
                }
                case DATA: {
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    int len = this.pack.getNumberDataInts();
                    data = new int[len];
                    readinglong = this.pack.isLongPacket();
                    if (!readinglong) {
                        for (i = 0; i < len; ++i) {
                            data[i] = inputStream.readInt();
                        }
                        break;
                    }
                    longdata = inputStream.readLong();
                    break;
                }
                case UPDATE: {
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    break;
                }
                case FLOAT: {
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    floatdata = inputStream.readFloat();
                    break;
                }
                case SYNC: {
                    String name = packet.readString();
                    x = inputStream.readInt();
                    y = inputStream.readInt();
                    z = inputStream.readInt();
                    ReikaPacketHelper.updateTileEntityData(world, x, y, z, name, inputStream);
                    return;
                }
                case TANK: {
                    String tank = packet.readString();
                    x = inputStream.readInt();
                    y = inputStream.readInt();
                    z = inputStream.readInt();
                    int level = inputStream.readInt();
                    ReikaPacketHelper.updateTileEntityTankData(world, x, y, z, tank, level);
                    return;
                }
                case RAW: {
                    int i2;
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    int len = this.pack.getNumberDataInts();
                    data = new int[len];
                    readinglong = this.pack.isLongPacket();
                    if (!readinglong) {
                        for (i2 = 0; i2 < len; ++i2) {
                            data[i2] = inputStream.readInt();
                        }
                        break;
                    }
                    longdata = inputStream.readLong();
                    break;
                }
                case NBT: {
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    NBT = ((ReikaPacketHelper.DataPacket)packet).asNBT();
                    break;
                }
                case STRINGINT: {
                    int i2;
                    stringdata = packet.readString();
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    data = new int[this.pack.getNumberDataInts()];
                    for (i2 = 0; i2 < data.length; ++i2) {
                        data[i2] = inputStream.readInt();
                    }
                    break;
                }
            }
            if (packetType.hasCoordinates()) {
                x = inputStream.readInt();
                y = inputStream.readInt();
                z = inputStream.readInt();
            }
        }
        catch (IOException e) {
            DragonAPICore.logError("Error when handling " + (Object)((Object)this.pack) + " packet [" + packet + "]: " + e.toString());
            e.printStackTrace();
            return;
        }
        try {
            switch (this.pack) {
                case BLOCKUPDATE: {
                    world.func_147471_g(x, y, z);
                    world.func_147479_m(x, y, z);
                    break;
                }
                case PARTICLE: 
                case PARTICLEWITHPOS: 
                case PARTICLEWITHPOSVEL: {
                    double pz;
                    double py;
                    double px;
                    if (data[0] < 0 || data[0] >= ReikaParticleHelper.particleList.length) break;
                    if (this.pack == PacketIDs.PARTICLE) {
                        px = (double)x + this.rand.nextDouble();
                        py = (double)y + this.rand.nextDouble();
                        pz = (double)z + this.rand.nextDouble();
                    } else {
                        px = ReikaJavaLibrary.buildDoubleFromInts(data[2], data[3]);
                        py = ReikaJavaLibrary.buildDoubleFromInts(data[4], data[5]);
                        pz = ReikaJavaLibrary.buildDoubleFromInts(data[6], data[7]);
                    }
                    double vx = 0.0;
                    double vy = 0.0;
                    double vz = 0.0;
                    if (this.pack == PacketIDs.PARTICLEWITHPOSVEL) {
                        vx = ReikaJavaLibrary.buildDoubleFromInts(data[8], data[9]);
                        vy = ReikaJavaLibrary.buildDoubleFromInts(data[10], data[11]);
                        vz = ReikaJavaLibrary.buildDoubleFromInts(data[12], data[13]);
                    }
                    for (i = 0; i < data[1]; ++i) {
                        ReikaParticleHelper p = ReikaParticleHelper.particleList[data[0]];
                        world.func_72869_a(p.name, px, py, pz, vx, vy, vz);
                    }
                    break;
                }
                case BIOMECHANGE: {
                    ReikaWorldHelper.setBiomeForXZ(world, x, z, BiomeGenBase.field_76773_a[data[0]], false);
                    world.func_147458_c(x, 0, z, x, world.field_73011_w.getActualHeight(), z);
                    break;
                }
                case KEYUPDATE: {
                    boolean used;
                    if (data.length < 2) {
                        DragonAPICore.logError("Caught key packet missing data (len=" + data.length + ")! Packet=" + packet);
                        break;
                    }
                    int ordinal = data[0];
                    boolean bl = used = data[1] > 0;
                    if (ordinal < 0 || ordinal > KeyWatcher.Key.keyList.length) {
                        DragonAPICore.logError("Caught key packet for key #" + ordinal + " (use=" + used + "), yet no such key exists. Packet=" + packet);
                        break;
                    }
                    KeyWatcher.Key key = KeyWatcher.Key.keyList[ordinal];
                    KeyWatcher.instance.setKey(ep, key, used);
                    MinecraftForge.EVENT_BUS.post((Event)new RawKeyPressEvent(key, ep));
                    break;
                }
                case TILESYNC: {
                    TileEntity te = world.func_147438_o(x, y, z);
                    if (!(te instanceof TileEntityBase) || world.field_72995_K) break;
                    TileEntityBase tile = (TileEntityBase)te;
                    tile.syncAllData(data[0] > 0);
                    break;
                }
                case VTILESYNC: {
                    int tx = NBT.func_74762_e("x");
                    int ty = NBT.func_74762_e("y");
                    int tz = NBT.func_74762_e("z");
                    TileEntity tile = world.func_147438_o(tx, ty, tz);
                    tile.func_145839_a(NBT);
                    break;
                }
                case TILEDELETE: {
                    world.func_147468_f(x, y, z);
                    break;
                }
                case PLAYERDATSYNC: 
                case PLAYERDATSYNC_CLIENT: {
                    for (Object o : NBT.func_150296_c()) {
                        String name = (String)o;
                        NBTBase tag = NBT.func_74781_a(name);
                        ep.getEntityData().func_74782_a(name, tag);
                    }
                    break;
                }
                case PLAYERDATSYNCREQ_CLIENT: {
                    ReikaPlayerAPI.syncCustomData((EntityPlayerMP)ep);
                    break;
                }
                case RERENDER: {
                    if (data[0] > 0) {
                        ReikaRenderHelper.rerenderAllChunksLazily();
                        break;
                    }
                    ReikaRenderHelper.rerenderAllChunks();
                    break;
                }
                case COLOREDPARTICLE: {
                    ReikaParticleHelper.spawnColoredParticlesWithOutset(world, x, y, z, data[0], data[1], data[2], data[3], (double)data[4] / 16.0);
                    break;
                }
                case NUMBERPARTICLE: 
                case STRINGPARTICLE: {
                    break;
                }
                case IDDUMP: 
                case ENTITYDUMP: {
                    break;
                }
                case EXPLODE: {
                    break;
                }
                case OLDMODS: {
                    break;
                }
                case LOGIN: {
                    break;
                }
                case SERVERSOUND: {
                    if (!world.field_72995_K) break;
                    double dx = inputStream.readDouble();
                    double dy = inputStream.readDouble();
                    double dz = inputStream.readDouble();
                    String name = packet.readString();
                    float vol = inputStream.readFloat();
                    float pitch = inputStream.readFloat();
                    boolean flag = inputStream.readBoolean();
                    ReikaSoundHelper.playNormalClientSound(world, dx, dy, dz, name, vol, pitch, flag);
                    break;
                }
                case BREAKPARTICLES: {
                    break;
                }
                case PLAYERKICK: {
                    ((EntityPlayerMP)ep).field_71135_a.func_147360_c(stringdata);
                    break;
                }
                case CONFIGSYNCSTART: {
                    ConfigMatcher.instance.clear(ep);
                    break;
                }
                case CONFIGSYNC: {
                    ConfigMatcher.instance.register(ep, stringdata, data[0]);
                    break;
                }
                case CONFIGSYNCEND: {
                    ConfigMatcher.instance.match((EntityPlayerMP)ep);
                    break;
                }
                case ITEMDROPPER: {
                    break;
                }
                case ITEMDROPPERREQUEST: {
                    Entity e = world.func_73045_a(data[0]);
                    if (!(e instanceof EntityItem) || !e.getEntityData().func_74764_b("dropper")) break;
                    String s = e.getEntityData().func_74779_i("dropper");
                    ReikaPacketHelper.sendStringIntPacket("DragonAPIData", PacketIDs.ITEMDROPPER.ordinal(), (EntityPlayerMP)ep, s, data[0]);
                    break;
                }
                case PLAYERINTERACT: {
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerInteractEventClient(ep, PlayerInteractEvent.Action.values()[data[4]], data[0], data[1], data[2], data[3], world));
                    break;
                }
                case GUIRELOAD: {
                    break;
                }
                case BIOMEPNGSTART: {
                    BiomeMapCommand.startCollecting(data[0], stringdata, data[1], data[2], data[3], data[4], data[5], data[6], data[7] > 0);
                    break;
                }
                case BIOMEPNGDAT: {
                    int hash = data[0];
                    for (int i3 = 0; i3 < 2048; ++i3) {
                        int a = 1 + i3 * 3;
                        BiomeMapCommand.addBiomePoint(hash, data[a], data[a + 1], data[a + 2]);
                    }
                    break;
                }
                case BIOMEPNGEND: {
                    BiomeMapCommand.finishCollectingAndMakeImage(data[0]);
                    break;
                }
                case FILEMATCH: {
                    ModFileVersionChecker.instance.checkFiles((EntityPlayerMP)ep, stringdata);
                    break;
                }
                case ENTITYSYNC: {
                    int id = NBT.func_74762_e("dispatchID");
                    Entity e = world.func_73045_a(id);
                    if (e != null) {
                        e.func_70020_e(NBT);
                        break;
                    }
                    DragonAPICore.logError("Entity does not exist clientside to be synced!");
                    break;
                }
                case LOGOUT: {
                    break;
                }
                case MODULARLOGGER: {
                    ModularLogger.instance.setState(stringdata, data[0] > 0);
                    break;
                }
                case POPUP: {
                    break;
                }
                case GETLATENCY: {
                    int[] l = ReikaJavaLibrary.splitLong(System.currentTimeMillis());
                    ReikaPacketHelper.sendDataPacket("DragonAPIData", PacketIDs.SENDLATENCY.ordinal(), (EntityPlayerMP)ep, data[0], data[1], l[0], l[1]);
                    break;
                }
                case SENDLATENCY: {
                    break;
                }
                case REDSTONECHANGE: {
                    break;
                }
                case ENTITYVERIFY: {
                    ReikaEntityHelper.performEntityVerification((EntityPlayerMP)ep, data[0], data[1], data[2]);
                    break;
                }
                case ENTITYVERIFYFAIL: {
                    Entity e = world.func_73045_a(data[0]);
                    if (e == null) break;
                    e.func_70106_y();
                    DragonAPICore.log("Removing client-only entity " + e);
                    break;
                }
                case CLEARCHAT: {
                    break;
                }
                case MODLOCK: {
                    break;
                }
                case OREDUMP: {
                    break;
                }
                case WORLDID: {
                    break;
                }
                case SETAIR: {
                    world.func_147468_f(data[0], data[1], data[2]);
                }
            }
            if (world.field_72995_K) {
                this.clientHandle(world, x, y, z, this.pack, data, stringdata, ep);
            }
        }
        catch (Exception e) {
            DragonAPICore.logError("Error when handling " + (Object)((Object)this.pack) + " packet [" + packet + "]: " + e.toString());
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void clientHandle(World world, int x, int y, int z, PacketIDs pack, int[] data, String sg, EntityPlayer player) {
        switch (pack) {
            case NUMBERPARTICLE: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new StringParticleFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, String.valueOf(data[0])));
                break;
            }
            case STRINGPARTICLE: {
                StringParticleFX fx = new StringParticleFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, sg);
                fx.setLife(Math.max(15, 3 * sg.length()));
                fx.setScale(Math.max(0.01f, Math.min(1.0f, 0.5f / (float)sg.length())));
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                break;
            }
            case IDDUMP: {
                IDDumpCommand.dumpClientside(data[0]);
                break;
            }
            case ENTITYDUMP: {
                EntityListCommand.dumpClientside();
                break;
            }
            case EXPLODE: {
                ReikaSoundHelper.playSoundAtBlock(world, x, y, z, "random.explode");
                ReikaParticleHelper.EXPLODE.spawnAroundBlock(world, x, y, z, 1);
                break;
            }
            case OLDMODS: {
                CommandableUpdateChecker.instance.onClientReceiveOldModID(sg);
                break;
            }
            case LOGIN: {
                MinecraftForge.EVENT_BUS.post((Event)new ClientLoginEvent(player, data[0] > 0));
                SettingInterferenceTracker.instance.onLogin(player);
                break;
            }
            case LOGOUT: {
                MinecraftForge.EVENT_BUS.post((Event)new ClientLogoutEvent(player));
                break;
            }
            case BREAKPARTICLES: {
                Block b = Block.func_149729_e((int)data[0]);
                ReikaRenderHelper.spawnDropParticles(world, x, y, z, b, data[1]);
                break;
            }
            case ITEMDROPPER: {
                Entity e = world.func_73045_a(data[0]);
                if (!(e instanceof EntityItem)) break;
                e.getEntityData().func_74778_a("dropper", sg);
                break;
            }
            case GUIRELOAD: {
                if (Minecraft.func_71410_x().field_71462_r == null) break;
                Minecraft.func_71410_x().field_71462_r.func_73866_w_();
                break;
            }
            case POPUP: {
                PopupWriter.instance.addMessage(new PopupWriter.Warning(sg, data[0]));
                break;
            }
            case SENDLATENCY: {
                long t3 = System.currentTimeMillis();
                long t1 = ReikaJavaLibrary.buildLong(data[0], data[1]);
                long t2 = ReikaJavaLibrary.buildLong(data[2], data[3]);
                long toServerTime = t2 - t1;
                long toClientTime = t3 - t2;
                ReikaChatHelper.write("Total latency: " + toServerTime + "ms to server, " + toClientTime + "ms from server.");
                break;
            }
            case REDSTONECHANGE: {
                ((TileEntityBase)world.func_147438_o(x, y, z)).onRedstoneChangedClientside(data[0] > 0, data[1] > 0);
                break;
            }
            case CLEARCHAT: {
                ReikaChatHelper.clearChat();
                break;
            }
            case MODLOCK: {
                ModLockController.instance.readSync(player, sg);
                break;
            }
            case OREDUMP: {
                OreDumpCommand.dumpClientside(sg);
                break;
            }
            case WORLDID: {
                long time = ReikaJavaLibrary.buildLong(data[0], data[1]);
                long session = ReikaJavaLibrary.buildLong(data[2], data[3]);
                long index = ReikaJavaLibrary.buildLong(data[4], data[5]);
                ReikaWorldHelper.clientWorldID = new ReikaWorldHelper.WorldIDBase(time, session, index, sg);
                break;
            }
        }
    }

    public static enum PacketIDs {
        BIOMECHANGE,
        BLOCKUPDATE,
        PARTICLE,
        PARTICLEWITHPOS,
        PARTICLEWITHPOSVEL,
        KEYUPDATE,
        TILESYNC,
        VTILESYNC,
        TILEDELETE,
        PLAYERDATSYNC,
        PLAYERDATSYNC_CLIENT,
        PLAYERDATSYNCREQ_CLIENT,
        RERENDER,
        COLOREDPARTICLE,
        NUMBERPARTICLE,
        STRINGPARTICLE,
        IDDUMP,
        ENTITYDUMP,
        EXPLODE,
        OLDMODS,
        LOGIN,
        LOGOUT,
        SERVERSOUND,
        BREAKPARTICLES,
        PLAYERKICK,
        CONFIGSYNC,
        CONFIGSYNCSTART,
        CONFIGSYNCEND,
        ITEMDROPPER,
        ITEMDROPPERREQUEST,
        PLAYERINTERACT,
        GUIRELOAD,
        BIOMEPNGSTART,
        BIOMEPNGDAT,
        BIOMEPNGEND,
        FILEMATCH,
        ENTITYSYNC,
        MODULARLOGGER,
        POPUP,
        GETLATENCY,
        SENDLATENCY,
        REDSTONECHANGE,
        ENTITYVERIFY,
        ENTITYVERIFYFAIL,
        CLEARCHAT,
        MODLOCK,
        OREDUMP,
        WORLDID,
        SETAIR;


        public static PacketIDs getEnum(int index) {
            return PacketIDs.values()[index];
        }

        public boolean isLongPacket() {
            return false;
        }

        public int getNumberDataInts() {
            switch (this) {
                case PARTICLE: {
                    return 2;
                }
                case PARTICLEWITHPOS: {
                    return 8;
                }
                case PARTICLEWITHPOSVEL: {
                    return 14;
                }
                case NUMBERPARTICLE: {
                    return 1;
                }
                case COLOREDPARTICLE: {
                    return 5;
                }
                case BIOMECHANGE: {
                    return 1;
                }
                case KEYUPDATE: {
                    return 2;
                }
                case TILESYNC: {
                    return 1;
                }
                case IDDUMP: {
                    return 1;
                }
                case BREAKPARTICLES: {
                    return 2;
                }
                case CONFIGSYNC: {
                    return 1;
                }
                case ITEMDROPPER: 
                case ITEMDROPPERREQUEST: {
                    return 1;
                }
                case PLAYERINTERACT: {
                    return 5;
                }
                case BIOMEPNGSTART: {
                    return 8;
                }
                case BIOMEPNGDAT: {
                    return 6145;
                }
                case BIOMEPNGEND: {
                    return 1;
                }
                case LOGIN: {
                    return 1;
                }
                case MODULARLOGGER: {
                    return 1;
                }
                case GETLATENCY: {
                    return 2;
                }
                case SENDLATENCY: {
                    return 4;
                }
                case REDSTONECHANGE: {
                    return 2;
                }
                case ENTITYVERIFY: {
                    return 3;
                }
                case ENTITYVERIFYFAIL: {
                    return 2;
                }
                case POPUP: {
                    return 1;
                }
                case WORLDID: {
                    return 6;
                }
                case RERENDER: {
                    return 1;
                }
                case SETAIR: {
                    return 3;
                }
            }
            return 0;
        }
    }
}

