/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Exception.ASMException;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.classloading.FMLForgePlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class InterfaceInjector
implements IClassTransformer {
    private static final boolean DEBUG = true;
    private static final String SKIP_PROPERTY = "Reika.ignoreMismatchedInterfaces";
    private final boolean crashOnError = Boolean.valueOf(System.getProperty("Reika.ignoreMismatchedInterfaces")) == false;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!FMLForgePlugin.RUNTIME_DEOBF && !DependentMethodStripper.runInDev) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Collection<String> c = this.getInterfacesFor(classNode);
        if (c == null) {
            return bytes;
        }
        this.tryInjectInterfaces(classNode, c);
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        classNode.check(classNode.version);
        return writer.toByteArray();
    }

    private Collection<String> getInterfacesFor(ClassNode cn) {
        if (cn.visibleAnnotations != null) {
            for (AnnotationNode ann : cn.visibleAnnotations) {
                if (!ann.desc.equals("LReika/DragonAPI/ASM/InterfaceInjector$Injectable;")) continue;
                for (int x = 0; x < ann.values.size() - 1; x += 2) {
                    Object key = ann.values.get(x);
                    Object values = ann.values.get(x + 1);
                    if (!(key instanceof String) || !key.equals("value") || !(values instanceof List) || ((List)values).isEmpty() || !(((List)values).get(0) instanceof String)) continue;
                    return (List)values;
                }
            }
        }
        return null;
    }

    private void tryInjectInterfaces(ClassNode cn, Collection<String> c) {
        ReikaJavaLibrary.pConsole("DRAGONAPI ASM: Injecting " + c.size() + " interfaces into " + cn.name + ": " + c);
        for (String cl : c) {
            ClassNode inter = this.getInterfaceFromString(cl);
            if (inter == null) {
                ReikaJavaLibrary.pConsole("DRAGONAPI ASM: Interface class " + cl + " not found. Injection failed.");
                continue;
            }
            this.tryInjectInterface(cn, inter);
        }
    }

    private void tryInjectInterface(ClassNode cn, ClassNode inter) {
        ArrayList<MethodNode> missing = new ArrayList<MethodNode>();
        for (MethodNode mn : inter.methods) {
            if (ReikaASMHelper.classContainsMethod(cn, mn) || ReikaASMHelper.checkIfClassInheritsMethod(cn, mn)) continue;
            missing.add(mn);
        }
        if (!missing.isEmpty()) {
            ImproperImplementationException e = new ImproperImplementationException(cn, inter, missing);
            if (this.crashOnError) {
                throw e;
            }
            ReikaJavaLibrary.pConsole("DRAGONAPI ASM: Interface " + inter.name + " could not be injected to " + cn.name + "; improper implementation.");
            e.printStackTrace();
        } else {
            cn.interfaces.add(inter.name);
            ReikaJavaLibrary.pConsole("DRAGONAPI ASM: Interface class " + inter.name + " successfully injected into " + cn.name + ".");
        }
    }

    private ClassNode getInterfaceFromString(String s) {
        try {
            byte[] data = Launch.classLoader.getClassBytes(s);
            if (data == null) {
                return null;
            }
            ClassNode cn = new ClassNode();
            new ClassReader(data).accept((ClassVisitor)cn, 0);
            return cn;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Injectable {
        public String[] value();
    }

    private static class ImproperImplementationException
    extends ASMException {
        private final ClassNode interface_;
        private final Collection<MethodNode> missingMethods;
        private final Collection<String> missingMethodNames = new ArrayList<String>();

        protected ImproperImplementationException(ClassNode cn, ClassNode interf, Collection<MethodNode> ms) {
            super(cn);
            this.interface_ = interf;
            this.missingMethods = ms;
            for (MethodNode m : this.missingMethods) {
                this.missingMethodNames.add(m.name);
            }
        }

        @Override
        public final String getMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.getMessage());
            sb.append("Could not inject interface " + this.interface_.name + ";\n");
            sb.append(this.node.name + " does not implement the following required methods:\n");
            for (MethodNode m : this.missingMethods) {
                sb.append("\t" + m.name + " " + m.desc);
                sb.append("\n");
            }
            sb.append("\nIn all likelihood, the interface has changed and its implementation requires correction.\n");
            sb.append("The following methods were found on the class:\n");
            for (MethodNode m : this.node.methods) {
                sb.append("\t" + m.name + " " + m.desc);
                if (this.missingMethodNames.contains(m.name)) {
                    sb.append(" << Method matches a missing method name but not signature; this is likely the error.");
                }
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

