/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM.Patchers.Hooks.Event.World.Gen;

import Reika.DragonAPI.ASM.Patchers.Patcher;
import Reika.DragonAPI.Exception.InstallationException;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class RiverGenLayerEvent
extends Patcher {
    public RiverGenLayerEvent() {
        super("net.minecraft.world.gen.layer.GenLayerRiverMix", "axv");
    }

    @Override
    protected void apply(ClassNode cn) {
        MethodNode m = ReikaASMHelper.getMethodByName(cn, "func_75904_a", "getInts", "(IIII)[I");
        int version = ReikaASMHelper.forgeVersion_Build;
        if (version == 1614) {
            this.apply_1614(cn, m);
        } else if (version == 1558) {
            this.apply_1558(cn, m);
        } else {
            throw new InstallationException("DragonAPI", "Unsupported Forge version! Use either 1558 or 1614!");
        }
    }

    private void apply_1614(ClassNode cn, MethodNode m) {
        AbstractInsnNode ain = ReikaASMHelper.getFirstOpcode(m.instructions, 126);
        int idx = m.instructions.indexOf(ain);
        AbstractInsnNode first = ReikaASMHelper.getLastInsnBefore(m.instructions, idx, 25, 7);
        AbstractInsnNode last = ReikaASMHelper.getFirstOpcodeAfter(m.instructions, idx, 79);
        InsnList li = new InsnList();
        li.add((AbstractInsnNode)new VarInsnNode(25, 5));
        li.add((AbstractInsnNode)new VarInsnNode(25, 6));
        li.add((AbstractInsnNode)new VarInsnNode(25, 7));
        li.add((AbstractInsnNode)new VarInsnNode(21, 8));
        li.add((AbstractInsnNode)new MethodInsnNode(184, "Reika/DragonAPI/Instantiable/Event/GenLayerRiverEvent", "fire_1614", "([I[I[II)V", false));
        AbstractInsnNode ref = first.getPrevious();
        ReikaASMHelper.deleteFrom(cn, m.instructions, first, last);
        m.instructions.insert(ref, li);
    }

    private void apply_1558(ClassNode cn, MethodNode m) {
        VarInsnNode first = (VarInsnNode)ReikaASMHelper.getFirstInsnAfter(m.instructions, 0, 25, 5);
        JumpInsnNode last = (JumpInsnNode)ReikaASMHelper.getNthOpcode(m.instructions, 159, 2);
        ReikaASMHelper.deleteFrom(cn, m.instructions, first.getNext(), last.getPrevious());
        InsnList li = new InsnList();
        li.add((AbstractInsnNode)new VarInsnNode(21, 8));
        li.add((AbstractInsnNode)new InsnNode(46));
        li.add((AbstractInsnNode)new MethodInsnNode(184, "Reika/DragonAPI/Instantiable/Event/GenLayerRiverEvent", "fire_1558", "(I)Z", false));
        last.setOpcode(153);
        m.instructions.insert((AbstractInsnNode)first, li);
    }
}

