/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary;

import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.Entity.ChunkLoadingEntity;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkManager
implements ForgeChunkManager.LoadingCallback {
    public static final ChunkManager instance = new ChunkManager();
    private final HashMap<WorldLocation, ForgeChunkManager.Ticket> tileTickets = new HashMap();
    private final HashMap<Integer, ForgeChunkManager.Ticket> entityTickets = new HashMap();

    private ChunkManager() {
    }

    public void register() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)DragonAPIInit.instance, (ForgeChunkManager.LoadingCallback)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void unloadWorld(WorldEvent.Unload evt) {
        this.unloadTickets(this.tileTickets, evt.world.field_73011_w.field_76574_g);
        this.unloadTickets(this.entityTickets, evt.world.field_73011_w.field_76574_g);
    }

    private void unloadTickets(HashMap<?, ForgeChunkManager.Ticket> tickets, int world) {
        Iterator<ForgeChunkManager.Ticket> it = tickets.values().iterator();
        while (it.hasNext()) {
            ForgeChunkManager.Ticket t = it.next();
            if (t.world.field_73011_w.field_76574_g != world) continue;
            it.remove();
        }
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            switch (ticket.getType()) {
                case NORMAL: {
                    NBTTagCompound nbt = ticket.getModData();
                    int x = nbt.func_74762_e("tileX");
                    int y = nbt.func_74762_e("tileY");
                    int z = nbt.func_74762_e("tileZ");
                    TileEntity te = world.func_147438_o(x, y, z);
                    if (te instanceof ChunkLoadingTile) {
                        ChunkLoadingTile tile = (ChunkLoadingTile)te;
                        WorldLocation loc = new WorldLocation(te);
                        this.forceTicketChunks(ticket, tile.getChunksToLoad());
                        this.cacheTicket(loc, ticket);
                        break;
                    }
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                    break;
                }
            }
        }
    }

    private void cacheTicket(WorldLocation loc, ForgeChunkManager.Ticket ticket) {
        this.tileTickets.put(loc, ticket);
    }

    private void cacheTicket(Entity loc, ForgeChunkManager.Ticket ticket) {
        this.entityTickets.put(loc.func_145782_y(), ticket);
    }

    public void unloadChunks(TileEntity te) {
        this.unloadChunks(new WorldLocation(te));
    }

    public void unloadChunks(World world, int x, int y, int z) {
        this.unloadChunks(new WorldLocation(world, x, y, z));
    }

    public void unloadChunks(WorldLocation loc) {
        ForgeChunkManager.Ticket ticket = this.tileTickets.remove(loc);
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
    }

    public void unloadChunks(Entity e) {
        ForgeChunkManager.Ticket ticket = this.entityTickets.remove(e.func_145782_y());
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
    }

    public void loadChunks(ChunkLoadingTile te) {
        try {
            WorldLocation loc = new WorldLocation((TileEntity)te);
            ForgeChunkManager.Ticket ticket = this.tileTickets.get(loc);
            if (ticket == null) {
                ticket = this.getNewTileTicket((TileEntity)te);
                this.cacheTicket(loc, ticket);
            }
            this.forceTicketChunks(ticket, te.getChunksToLoad());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadChunks(ChunkLoadingEntity e) {
        try {
            int id = ((Entity)e).func_145782_y();
            ForgeChunkManager.Ticket ticket = this.entityTickets.get(id);
            if (ticket == null) {
                ticket = this.getNewEntityTicket((Entity)e);
                this.cacheTicket((Entity)e, ticket);
            }
            this.forceTicketChunks(ticket, e.getChunksToLoad());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ForgeChunkManager.Ticket getNewTileTicket(TileEntity te) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)DragonAPIInit.instance, (World)te.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        NBTTagCompound nbt = ticket.getModData();
        nbt.func_74768_a("tileX", te.field_145851_c);
        nbt.func_74768_a("tileY", te.field_145848_d);
        nbt.func_74768_a("tileZ", te.field_145849_e);
        return ticket;
    }

    private ForgeChunkManager.Ticket getNewEntityTicket(Entity e) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)DragonAPIInit.instance, (World)e.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        NBTTagCompound nbt = ticket.getModData();
        nbt.func_74768_a("entityID", e.func_145782_y());
        ticket.bindEntity(e);
        return ticket;
    }

    private synchronized void forceTicketChunks(ForgeChunkManager.Ticket ticket, Collection<ChunkCoordIntPair> chunks) {
        ImmutableSet ticketChunks = ticket.getChunkList();
        for (ChunkCoordIntPair coord : ticketChunks) {
            if (chunks.contains(coord)) continue;
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)coord);
        }
        for (ChunkCoordIntPair coord : chunks) {
            if (ticketChunks.contains((Object)coord)) continue;
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)coord);
        }
    }

    public static Collection<ChunkCoordIntPair> getChunkSquare(int x, int z, int r) {
        int x2 = x >> 4;
        int z2 = z >> 4;
        ArrayList<ChunkCoordIntPair> chunkList = new ArrayList<ChunkCoordIntPair>();
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                chunkList.add(new ChunkCoordIntPair(x2 + i, z2 + k));
            }
        }
        return chunkList;
    }

    public String toString() {
        return "TILE: " + this.tileTickets.toString() + " ; ENTITY: " + this.entityTickets.toString();
    }

    public Collection<ChunkCoordIntPair> getChunk(Entity e) {
        return ReikaJavaLibrary.makeListFrom(new ChunkCoordIntPair(MathHelper.func_76128_c((double)e.field_70165_t) >> 4, MathHelper.func_76128_c((double)e.field_70161_v) >> 4));
    }
}

