/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary;

import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.message.Message;

public class LoggingFilters {
    private static final Filter mismatchFilter = new ItemBlockMismatchFilter();
    private static final Filter soundLoaderFilter = new CustomSoundLoaderFilter();
    private static final Filter noTextureFilter = new MissingTextureFilter();

    public static void registerFilter(Filter f, LoggerType type) {
        Logger log = LoggingFilters.getLogger(type);
        if (log == null) {
            throw new RuntimeException("Logger interception is not working! Notify Reika immediately!");
        }
        log.addFilter(f);
    }

    private static Logger getLogger(LoggerType type) {
        switch (type) {
            case FML: {
                return (Logger)FMLRelaunchLog.log.getLogger();
            }
            case SOUND: {
                return (Logger)LogManager.getLogger(SoundHandler.class);
            }
            case TEXTURE: {
                return (Logger)LogManager.getLogger(TextureMap.class);
            }
            case CHAT: {
                return (Logger)LogManager.getLogger(GuiNewChat.class);
            }
            case SERVER: {
                return (Logger)LogManager.getLogger(MinecraftServer.class);
            }
            case WORLD: {
                return (Logger)LogManager.getLogger(WorldServer.class);
            }
        }
        return null;
    }

    public static void registerCoreFilters() {
        LoggingFilters.registerFilter(mismatchFilter, LoggerType.FML);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            LoggingFilters.registerFilter(soundLoaderFilter, LoggerType.SOUND);
            LoggingFilters.registerFilter(noTextureFilter, LoggerType.TEXTURE);
        }
    }

    public static enum LoggerType {
        FML,
        TEXTURE,
        SOUND,
        CHAT,
        SERVER,
        WORLD;


        public boolean isClientOnly() {
            return this == TEXTURE || this == SOUND || this == CHAT;
        }
    }

    private static class MissingTextureFilter
    extends CoreFilter {
        private final String PREFIX = "Using missing texture, unable to load";

        private MissingTextureFilter() {
            super(LoggerType.TEXTURE);
        }

        @Override
        protected String parse(Message msg, Level lvl) {
            String sg = msg.getFormattedMessage();
            if (sg.contains("Using missing texture, unable to load")) {
                String tex = sg.substring("Using missing texture, unable to load".length() + 1);
                ReikaJavaLibrary.pConsole("ERROR: Texture Map could not find texture '" + tex + "'; File not found.");
                return null;
            }
            return "";
        }
    }

    private static class CustomSoundLoaderFilter
    extends CoreFilter {
        private final String PREFIX = "Invalid sounds.json";

        private CustomSoundLoaderFilter() {
            super(LoggerType.SOUND);
        }

        @Override
        protected String parse(Message msg, Level lvl) {
            String sg = msg.getFormattedMessage();
            if (sg.contains("Invalid sounds.json")) {
                return null;
            }
            return "";
        }
    }

    private static class ItemBlockMismatchFilter
    extends CoreFilter {
        private final String PREFIX = "Block <-> ItemBlock name mismatch";
        private final String TAG = "DragonAPI:minecraft";
        private int counter = 0;

        private ItemBlockMismatchFilter() {
            super(LoggerType.FML);
        }

        @Override
        protected String parse(Message msg, Level lvl) {
            if (this.counter > 0) {
                --this.counter;
                return null;
            }
            String sg = msg.getFormattedMessage();
            if (sg.contains("Block <-> ItemBlock name mismatch") && sg.contains("DragonAPI:minecraft")) {
                this.counter = 7;
                return null;
            }
            return "";
        }
    }

    public static abstract class ReplyWithContextFilter
    extends CoreFilter {
        private final String input;
        private final boolean sameStream;
        private boolean nextPrint;

        public ReplyWithContextFilter(Logger log, String seek) {
            super(null);
            this.input = seek;
            this.sameStream = log == LoggingFilters.getLogger(LoggerType.FML);
        }

        @Override
        protected final String parse(Message msg, Level lvl) {
            String sg = msg.getFormattedMessage();
            if (this.nextPrint) {
                this.nextPrint = false;
                ReikaJavaLibrary.pConsole(this.getReply(sg));
            }
            if (sg.contains(this.input)) {
                if (this.sameStream) {
                    this.nextPrint = true;
                } else {
                    ReikaJavaLibrary.pConsole(this.getReply(sg));
                }
            }
            return "";
        }

        protected abstract String getReply(String var1);
    }

    public static final class ReplyFilter
    extends CoreFilter {
        private final String input;
        private final String reply;
        private final boolean sameStream;
        private boolean nextPrint;

        public ReplyFilter(Logger log, String seek, String msg) {
            super(null);
            this.input = seek;
            this.reply = msg;
            this.sameStream = log == LoggingFilters.getLogger(LoggerType.FML);
        }

        @Override
        protected final String parse(Message msg, Level lvl) {
            String sg = msg.getFormattedMessage();
            if (this.nextPrint) {
                this.nextPrint = false;
                ReikaJavaLibrary.pConsole(this.reply);
            }
            if (sg.contains(this.input)) {
                if (this.sameStream) {
                    this.nextPrint = true;
                } else {
                    ReikaJavaLibrary.pConsole(this.reply);
                }
            }
            return "";
        }
    }

    public static abstract class CoreFilter
    implements Filter {
        private static boolean skipNext = false;
        protected final LoggerType type;

        protected CoreFilter(LoggerType log) {
            this.type = log;
        }

        public final Filter.Result getOnMismatch() {
            return Filter.Result.NEUTRAL;
        }

        public final Filter.Result getOnMatch() {
            return Filter.Result.NEUTRAL;
        }

        public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
            return Filter.Result.NEUTRAL;
        }

        public final Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
            return Filter.Result.NEUTRAL;
        }

        public final Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
            return Filter.Result.NEUTRAL;
        }

        public final Filter.Result filter(LogEvent event) {
            if (skipNext) {
                return Filter.Result.NEUTRAL;
            }
            String msg = this.parse(event.getMessage(), event.getLevel());
            if (msg == null) {
                return Filter.Result.DENY;
            }
            if (!msg.isEmpty()) {
                skipNext = true;
                LoggingFilters.getLogger(this.type).log(event.getLevel(), msg);
                skipNext = false;
                return Filter.Result.DENY;
            }
            return Filter.Result.NEUTRAL;
        }

        protected abstract String parse(Message var1, Level var2);
    }
}

