/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerMap;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C03PacketPlayer;

public class AFKTracker {
    public static final AFKTracker instance = new AFKTracker();
    public static final int TIMER = 20 * DragonOptions.AFK.getValue();
    private PlayerMap<Long> lastActivity = new PlayerMap();
    private PlayerMap<PositionData> lastPosition = new PlayerMap();

    private AFKTracker() {
    }

    public boolean isPlayerAFK(EntityPlayer ep) {
        return TIMER > 0 && this.lastActivity.containsKey(ep) && this.lastActivity.get(ep) + (long)TIMER < ep.field_70170_p.func_82737_E();
    }

    public void markPlayerAFK(EntityPlayer ep) {
        this.lastActivity.put(ep, 0L);
    }

    public static void refreshPlayer(NetHandlerPlayServer nh, Packet p) {
        if (TIMER == 0) {
            return;
        }
        if (p.getClass() != C03PacketPlayer.class) {
            EntityPlayerMP ep = nh.field_147369_b;
            if (p instanceof C03PacketPlayer.C04PacketPlayerPosition) {
                C03PacketPlayer.C04PacketPlayerPosition pk = (C03PacketPlayer.C04PacketPlayerPosition)p;
                PositionData pd = new PositionData(pk.func_149464_c(), pk.func_149467_d(), pk.func_149471_f(), pk.func_149472_e(), pk.func_149465_i());
                if (pd.equals(AFKTracker.instance.lastPosition.get((EntityPlayer)ep))) {
                    return;
                }
                AFKTracker.instance.lastPosition.put((EntityPlayer)ep, pd);
            }
            if (instance.isPlayerAFK((EntityPlayer)ep)) {
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, "You are no longer AFK.");
            }
            AFKTracker.instance.lastActivity.put((EntityPlayer)ep, ep.field_70170_p.func_82737_E());
        }
    }

    private static class PositionData {
        private final double posX;
        private final double posY;
        private final double posZ;
        private final double bottomY;
        private final boolean onGround;

        private PositionData(double x, double by, double y, double z, boolean ground) {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.bottomY = by;
            this.onGround = ground;
        }

        public boolean equals(Object o) {
            if (o instanceof PositionData) {
                PositionData pd = (PositionData)o;
                return pd.posX == this.posX && pd.posY == this.posY && pd.posZ == this.posZ && pd.bottomY == this.bottomY && pd.onGround == this.onGround;
            }
            return false;
        }
    }
}

