/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerManager;

public class PlayerChunkTracker
implements TickRegistry.TickHandler {
    public static final PlayerChunkTracker instance = new PlayerChunkTracker();
    private static final int UNREGISTER_THRESHOLD = 40;
    private final HashMap<EntityPlayer, TrackerEntry> trackedPlayers = new HashMap();
    private final HashMap<EntityPlayer, TrackerEntry> queuedWaitingEntries = new HashMap();
    private boolean isInTick = false;

    private PlayerChunkTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick(TickRegistry.TickType type, Object ... tickData) {
        this.isInTick = true;
        HashMap<EntityPlayer, TrackerEntry> hashMap = this.trackedPlayers;
        synchronized (hashMap) {
            Iterator<Map.Entry<EntityPlayer, TrackerEntry>> iterator = this.trackedPlayers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<EntityPlayer, TrackerEntry> entry = iterator.next();
                TrackerEntry tracker = entry.getValue();
                if (entry.getKey().field_70128_L || !tracker.condition.shouldBeTracked(entry.getKey())) {
                    tracker.timeout--;
                } else {
                    tracker.timeout = 40;
                }
                if (tracker.timeout > 0) continue;
                iterator.remove();
                entry.getValue().condition.onUntrack(entry.getKey());
                if (!(entry.getKey() instanceof EntityPlayerMP)) continue;
                EntityPlayerMP emp = (EntityPlayerMP)entry.getKey();
                emp.field_71131_d = Double.MAX_VALUE;
                emp.field_71132_e = Double.MAX_VALUE;
            }
        }
        this.isInTick = false;
        hashMap = this.queuedWaitingEntries;
        synchronized (hashMap) {
            this.trackedPlayers.putAll(this.queuedWaitingEntries);
            this.queuedWaitingEntries.clear();
        }
    }

    public static boolean shouldStopChunkloadingFor(EntityPlayer player) {
        return PlayerChunkTracker.instance.trackedPlayers.containsKey(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startTrackingPlayer(EntityPlayer player, TrackingCondition condition) {
        PlayerChunkTracker pct = instance;
        TrackerEntry newEntry = new TrackerEntry(40, condition);
        if (pct.isInTick) {
            HashMap<EntityPlayer, TrackerEntry> hashMap = pct.queuedWaitingEntries;
            synchronized (hashMap) {
                pct.queuedWaitingEntries.put(player, newEntry);
            }
        }
        HashMap<EntityPlayer, TrackerEntry> hashMap = pct.trackedPlayers;
        synchronized (hashMap) {
            pct.trackedPlayers.put(player, newEntry);
        }
    }

    @Override
    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.SERVER);
    }

    @Override
    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.END;
    }

    @Override
    public String getLabel() {
        return "Player Chunk Tracker";
    }

    public static void tryUpdatePlayerPertinentChunks(PlayerManager pm, EntityPlayerMP mp) {
        if (!PlayerChunkTracker.shouldStopChunkloadingFor((EntityPlayer)mp)) {
            pm.func_72685_d(mp);
        }
    }

    public static interface TrackingCondition {
        public boolean shouldBeTracked(EntityPlayer var1);

        public void onUntrack(EntityPlayer var1);
    }

    public static class TrackerEntry {
        private int timeout;
        private TrackingCondition condition;

        public TrackerEntry(int timeout, TrackingCondition condition) {
            this.timeout = timeout;
            this.condition = condition;
        }
    }
}

