/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;

public class PlayerHandler {
    public static final PlayerHandler instance = new PlayerHandler();
    private final ArrayList<PlayerTracker> trackers = new ArrayList();

    private PlayerHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void registerTracker(PlayerTracker p) {
        this.trackers.add(p);
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (ReikaPlayerAPI.isFake(evt.player)) {
            return;
        }
        for (PlayerTracker p : this.trackers) {
            p.onPlayerLogin(evt.player);
        }
    }

    @SubscribeEvent
    public void onLogout(PlayerEvent.PlayerLoggedOutEvent evt) {
        if (ReikaPlayerAPI.isFake(evt.player)) {
            return;
        }
        for (PlayerTracker p : this.trackers) {
            p.onPlayerLogout(evt.player);
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent evt) {
        if (ReikaPlayerAPI.isFake(evt.player)) {
            return;
        }
        for (PlayerTracker p : this.trackers) {
            p.onPlayerRespawn(evt.player);
        }
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent evt) {
        if (ReikaPlayerAPI.isFake(evt.player)) {
            return;
        }
        for (PlayerTracker p : this.trackers) {
            p.onPlayerChangedDimension(evt.player, evt.fromDim, evt.toDim);
        }
    }

    public static interface PlayerTracker {
        public void onPlayerLogin(EntityPlayer var1);

        public void onPlayerLogout(EntityPlayer var1);

        public void onPlayerChangedDimension(EntityPlayer var1, int var2, int var3);

        public void onPlayerRespawn(EntityPlayer var1);
    }
}

