/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import java.util.Collection;

public class ReflectiveFailureTracker {
    public static final ReflectiveFailureTracker instance = new ReflectiveFailureTracker();
    private final MultiMap<ModEntry, Object> data = new MultiMap();

    private ReflectiveFailureTracker() {
    }

    public void logModReflectiveFailure(ModEntry mod, Exception e) {
        this.data.addValue(mod, new ExceptionLog(this.getClassname(), e));
    }

    public void logModReflectiveFailure(ModEntry mod, String e) {
        this.data.addValue(mod, new StringLog(this.getClassname(), e));
    }

    private String getClassname() {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] tr = Thread.currentThread().getStackTrace();
        for (int i = 2; i <= 3; ++i) {
            if (i >= tr.length) continue;
            sb.append(tr[i].getClassName());
            if (i >= tr.length - 1 || i >= 3) continue;
            sb.append(" / ");
        }
        return sb.toString();
    }

    public void print() {
        if (!this.data.isEmpty()) {
            DragonAPICore.log("===============================================================================================");
            this.log("Some reflective mod handlers have failed.");
            this.log("Please try updating all involved mods, and if this fails to fix the issue, notify the author of the handlers.");
            for (ModEntry mod : this.data.keySet()) {
                Collection<Object> c = this.data.get(mod);
                this.log(String.format("%d failure%s for %s ('%s'):", c.size(), c.size() > 1 ? "s" : "", mod.getDisplayName(), mod.getModLabel()));
                for (Object e : c) {
                    this.log(e.toString());
                }
                DragonAPICore.log("");
            }
            this.log("For further information, including full stacktraces, consult the loading logs, and search for the erroring classes' names.");
            DragonAPICore.log("===============================================================================================");
        }
    }

    private void log(String s) {
        DragonAPICore.logError(s);
    }

    private static class ExceptionLog {
        private final String erroredClass;
        private final Exception error;

        private ExceptionLog(String c, Exception e) {
            this.error = e;
            this.erroredClass = c;
        }

        public final String toString() {
            return this.error.getClass().getSimpleName() + " \"" + this.error.getMessage() + "\" thrown from " + this.erroredClass;
        }
    }

    private static class StringLog {
        private final String erroredClass;
        private final String error;

        private StringLog(String c, String e) {
            this.error = e;
            this.erroredClass = c;
        }

        public final String toString() {
            return this.error.getClass().getSimpleName() + " \"" + this.error;
        }
    }
}

