/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Event.ChunkGenerationEvent;
import Reika.DragonAPI.Instantiable.ResettableRandom;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import com.google.common.base.Charsets;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class RetroGenController {
    public static final RetroGenController instance = new RetroGenController();
    private final HashSet<Integer> worldExclusions = new HashSet();
    private final HashMap<String, GeneratorEntry> retrogens = new HashMap();
    private final HashMap<Integer, DataCache> worldData = new HashMap();

    private RetroGenController() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void addRetroGenerator(RetroactiveGenerator gen, int weight) {
        GeneratorEntry e = new GeneratorEntry(gen, weight);
        this.retrogens.put(e.id, e);
    }

    public void addHybridGenerator(RetroactiveGenerator gen, int weight) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)gen, (int)weight);
    }

    public Set<String> getActiveRetroGenerators() {
        return Collections.unmodifiableSet(this.retrogens.keySet());
    }

    public void excludeWorld(int dim) {
        this.worldExclusions.add(dim);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load evt) {
        for (GeneratorEntry e : this.retrogens.values()) {
            this.loadFile(evt.world, e);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save evt) {
        for (GeneratorEntry e : this.retrogens.values()) {
            this.updateFile(evt.world, e);
        }
    }

    @SubscribeEvent
    public void generateChunk(ChunkGenerationEvent event) {
        Chunk c = event.getChunk();
        DataCache cache = this.getOrCreateCache(c.field_76637_e);
        if (cache == null) {
            return;
        }
        for (String s : this.retrogens.keySet()) {
            cache.generatedChunks.addValue(s, new ChunkCoordIntPair(c.field_76635_g, c.field_76647_h));
        }
    }

    @SubscribeEvent
    public void loadChunk(ChunkEvent.Load event) {
        if (this.retrogens.isEmpty()) {
            return;
        }
        Chunk c = event.getChunk();
        World world = c.field_76637_e;
        if (world.field_72995_K) {
            return;
        }
        if (this.worldExclusions.contains(world.field_73011_w.field_76574_g)) {
            return;
        }
        DataCache cache = this.getOrCreateCache(world);
        ChunkCoordIntPair p = new ChunkCoordIntPair(c.field_76635_g, c.field_76647_h);
        ArrayList<GeneratorEntry> toGen = new ArrayList<GeneratorEntry>();
        for (GeneratorEntry e : this.retrogens.values()) {
            Collection exclude = cache.generatedChunks.get(e.id);
            if (exclude.contains(p) || !e.generator.canGenerateAt(world, c.field_76635_g, c.field_76647_h)) continue;
            toGen.add(e);
        }
        if (toGen.isEmpty()) {
            return;
        }
        Collections.sort(toGen);
        IChunkProvider loader = world.func_72863_F();
        IChunkProvider gen = ((ChunkProviderServer)loader).field_73246_d;
        ResettableRandom rand = ReikaWorldHelper.getModdedGeneratorChunkRand(c.field_76635_g, c.field_76647_h, world);
        for (GeneratorEntry e : toGen) {
            e.generator.generate(rand, c.field_76635_g, c.field_76647_h, world, gen, loader);
            rand.resetSeed();
            cache.generatedChunks.addValue(e.id, p);
        }
    }

    private File getFile(World world, GeneratorEntry e) {
        File f = world.func_72860_G().func_75765_b();
        if (f != null) {
            return new File(f, "/DragonAPI_Retrogen/DIM" + world.field_73011_w.field_76574_g + "/" + e.id + ".dat");
        }
        return null;
    }

    private void loadFile(World world, GeneratorEntry e) {
        DataCache cache = this.getOrCreateCache(world);
        if (cache == null) {
            return;
        }
        File f = this.getFile(world, e);
        if (f != null && f.exists()) {
            List<String> li = ReikaFileReader.getFileAsLines(f, true, Charsets.UTF_8);
            for (String s : li) {
                ChunkCoordIntPair p = this.parseCoordPair(s);
                cache.generatedChunks.addValue(e.id, p);
            }
        }
    }

    private void updateFile(World world, GeneratorEntry e) {
        DataCache cache = this.getOrCreateCache(world);
        if (cache == null) {
            return;
        }
        File f = this.getFile(world, e);
        if (f == null) {
            return;
        }
        try {
            f.delete();
            f.getParentFile().mkdirs();
            f.createNewFile();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        ArrayList<String> li = new ArrayList<String>();
        for (ChunkCoordIntPair p : cache.generatedChunks.get(e.id)) {
            li.add(this.toString(p));
        }
        ReikaFileReader.writeLinesToFile(f, li, true, Charsets.UTF_8);
    }

    private DataCache getOrCreateCache(World world) {
        if (world.field_72995_K) {
            return null;
        }
        DataCache cache = this.worldData.get(world.field_73011_w.field_76574_g);
        if (cache == null || world.func_72905_C() != cache.worldSeed) {
            cache = new DataCache(world);
            this.worldData.put(world.field_73011_w.field_76574_g, cache);
        }
        return cache;
    }

    private ChunkCoordIntPair parseCoordPair(String s) {
        String[] parts = s.split(":");
        return new ChunkCoordIntPair(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }

    private String toString(ChunkCoordIntPair p) {
        return p.field_77276_a + ":" + p.field_77275_b;
    }

    private static class DataCache {
        private final int dimensionID;
        private final long worldSeed;
        private final MultiMap<String, ChunkCoordIntPair> generatedChunks = new MultiMap(MultiMap.CollectionType.HASHSET);

        private DataCache(World world) {
            this.dimensionID = world.field_73011_w.field_76574_g;
            this.worldSeed = world.func_72905_C();
        }

        public String toString() {
            return this.dimensionID + " in " + this.worldSeed + ": " + this.generatedChunks;
        }
    }

    private static class GeneratorEntry
    implements Comparable<GeneratorEntry> {
        private final String id;
        private final RetroactiveGenerator generator;
        private final int weight;

        private GeneratorEntry(RetroactiveGenerator gen, int w) {
            this.id = gen.getIDString();
            this.generator = gen;
            this.weight = w;
        }

        private boolean regenerate(World world, ChunkCoordIntPair pos, IChunkProvider gen, IChunkProvider loader) {
            this.generator.generate(world.field_73012_v, pos.field_77276_a, pos.field_77275_b, world, gen, loader);
            return true;
        }

        @Override
        public int compareTo(GeneratorEntry o) {
            return Integer.compare(this.weight, o.weight);
        }

        public String toString() {
            return this.id + " @ " + this.weight + ": " + this.generator.toString();
        }
    }
}

