/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Auxiliary.PopupWriter;
import Reika.DragonAPI.Auxiliary.Trackers.VersionTransitionTracker;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Event.ProfileEvent;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import com.google.common.base.Charsets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SettingInterferenceTracker
implements ProfileEvent.ProfileEventWatcher {
    public static final SettingInterferenceTracker instance = new SettingInterferenceTracker();
    public static final SettingInterference muteInterference = new SettingInterference(){
        private final EnumSet<SoundCategory> importantSounds = EnumSet.of(SoundCategory.MASTER, SoundCategory.AMBIENT, SoundCategory.BLOCKS, SoundCategory.PLAYERS);

        @Override
        public boolean isCurrentlyRelevant() {
            return true;
        }

        @Override
        public boolean isSetToInterfere() {
            GameSettings gs = Minecraft.func_71410_x().field_71474_y;
            for (SoundCategory s : this.importantSounds) {
                if (!((double)gs.func_151438_a(s) < 0.1)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void drawIcon(Tessellator v5, int x, int y, int size) {
            ReikaTextureHelper.bindFinalTexture(DragonAPICore.class, "Resources/mutewarn.png");
            v5.func_78382_b();
            v5.func_78378_d(0xFFFFFF);
            v5.func_78374_a((double)x, (double)(y + size), 0.0, 0.0, 1.0);
            v5.func_78374_a((double)(x + size), (double)(y + size), 0.0, 1.0, 1.0);
            v5.func_78374_a((double)(x + size), (double)y, 0.0, 1.0, 0.0);
            v5.func_78374_a((double)x, (double)y, 0.0, 0.0, 0.0);
            v5.func_78381_a();
        }

        @Override
        public String getDescription() {
            return "Sounds are muted, despite being used as indicators or warnings in many situations.";
        }

        @Override
        public String getID() {
            return "soundmute";
        }
    };
    private final HashMap<String, SettingInterference> settings = new HashMap();
    private WarningPersistence persistence = WarningPersistence.valueOf(DragonOptions.SETTINGWARN.getString());

    private SettingInterferenceTracker() {
    }

    public void registerSettingHandler(SettingInterference s) {
        if (!this.settings.containsKey(s.getID())) {
            this.settings.put(s.getID(), s);
        }
    }

    public void onLogin(EntityPlayer ep) {
        if (!this.persistence.isActive()) {
            return;
        }
        this.cacheSettings();
        ArrayList<String> li = new ArrayList<String>();
        for (SettingInterference si : this.settings.values()) {
            if (!si.isSetToInterfere()) continue;
            li.add(si.getDescription());
        }
        if (!li.isEmpty()) {
            String s0 = "You have one or more game settings configured in a manner that is likely to cause gameplay problems in some situations; consider changing them, and please do not report any issues that would not have arisen without that setting. See the next messages for more details.";
            PopupWriter.instance.addMessage(s0);
            DragonAPICore.log(s0);
            for (String s : li) {
                PopupWriter.instance.addMessage(s);
                DragonAPICore.log(s);
            }
        }
    }

    @Override
    public void onCall(String tag) {
        if (this.settings.isEmpty()) {
            return;
        }
        switch (tag) {
            case "gui": {
                this.onRender();
            }
        }
    }

    public void onRender() {
        if (!this.settings.isEmpty()) {
            GL11.glPushAttrib((int)1048575);
            Minecraft.func_71410_x().field_71460_t.func_78478_c();
            ReikaRenderHelper.disableEntityLighting();
            ReikaRenderHelper.disableLighting();
            GL11.glEnable((int)3042);
            GL11.glEnable((int)2884);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            Tessellator v5 = Tessellator.field_78398_a;
            int x = 2;
            int y = 2;
            int size = 16;
            for (SettingInterference s : this.settings.values()) {
                if (!s.isSetToInterfere() || !s.isCurrentlyRelevant()) continue;
                s.drawIcon(v5, x, y, size);
                x += size + 4;
            }
            GL11.glPopAttrib();
        }
    }

    private File getSettingCacheFile() {
        return new File(new File(DragonAPICore.getMinecraftDirectory(), "DragonAPI"), "setting_interference_cache.dat");
    }

    private boolean settingsMatchCache() {
        File f = this.getSettingCacheFile();
        if (!f.exists()) {
            return false;
        }
        List<String> li = ReikaFileReader.getFileAsLines(f, true, Charsets.UTF_8);
        HashSet<SettingInterference> set = new HashSet<SettingInterference>();
        HashSet<SettingInterference> set2 = new HashSet<SettingInterference>();
        for (String string : li) {
            SettingInterference si = this.settings.get(string);
            if (si == null) continue;
            set.add(si);
        }
        for (SettingInterference settingInterference : this.settings.values()) {
            if (!settingInterference.isSetToInterfere()) continue;
            set2.add(settingInterference);
        }
        return set.equals(set2);
    }

    private void cacheSettings() {
        try {
            File f = this.getSettingCacheFile();
            f.delete();
            f.getParentFile().mkdirs();
            f.createNewFile();
            ArrayList<String> li = new ArrayList<String>();
            for (SettingInterference s : this.settings.values()) {
                if (!s.isSetToInterfere()) continue;
                li.add(s.getID());
            }
            ReikaFileReader.writeLinesToFile(f, li, true, Charsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum WarningPersistence {
        EVERYLOAD,
        SETTINGCHANGE,
        VERSION,
        ONCE;


        public boolean isActive() {
            switch (this) {
                default: {
                    return true;
                }
                case VERSION: {
                    return VersionTransitionTracker.instance.haveModsUpdated();
                }
                case SETTINGCHANGE: {
                    return !instance.settingsMatchCache();
                }
                case ONCE: 
            }
            return !instance.getSettingCacheFile().exists();
        }
    }

    public static interface SettingInterference {
        public boolean isCurrentlyRelevant();

        public boolean isSetToInterfere();

        @SideOnly(value=Side.CLIENT)
        public void drawIcon(Tessellator var1, int var2, int var3, int var4);

        public String getDescription();

        public String getID();
    }
}

