/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Exception.VanillaIntegrityException;
import Reika.DragonAPI.Exception.WTFException;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;

public final class VanillaIntegrityTracker {
    private final MultiMap<DragonAPIMod, Field> blockList = new MultiMap();
    private final MultiMap<DragonAPIMod, Field> itemList = new MultiMap();
    private static final Class blockClass = Blocks.class;
    private static final Class itemClass = Item.class;
    private static final HashMap<Block, Field> blockFields = new HashMap();
    private static final HashMap<Item, Field> itemFields = new HashMap();
    public static final VanillaIntegrityTracker instance = new VanillaIntegrityTracker();

    private VanillaIntegrityTracker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Field[] blocks = blockClass.getFields();
        for (int i = 0; i < blocks.length; ++i) {
            Field f = blocks[i];
            if (!Modifier.isStatic(f.getModifiers())) continue;
            try {
                Object o = f.get(null);
                if (o == null) {
                    throw new WTFException("Some mod is deleting the value of the block field " + f, true);
                }
                if (!(o instanceof Block)) continue;
                blockFields.put((Block)o, f);
                continue;
            }
            catch (Exception o) {
                // empty catch block
            }
        }
        Field[] items = itemClass.getFields();
        for (int i = 0; i < items.length; ++i) {
            Field f = items[i];
            if (!Modifier.isStatic(f.getModifiers())) continue;
            try {
                Object o = f.get(null);
                if (o == null) {
                    throw new WTFException("Some mod is deleting the value of the item field " + f, true);
                }
                if (!(o instanceof Item)) continue;
                itemFields.put((Item)o, f);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addWatchedBlock(DragonAPIMod mod, Block b) {
        Field f = blockFields.get(b);
        if (f == null) {
            throw new MisuseException("Invalid block specified! No vanilla block has ID " + b + " and class " + b.getClass().getSimpleName());
        }
        this.blockList.addValue(mod, f);
    }

    public void addWatchedItem(DragonAPIMod mod, Item i) {
        Field f = itemFields.get(i);
        if (f == null) {
            throw new MisuseException("Invalid item specified! No vanilla item has ID " + i + " and class " + i.getClass().getSimpleName());
        }
        this.itemList.addValue(mod, f);
    }

    public final void check() {
        Object o2;
        for (DragonAPIMod mod : this.blockList.keySet()) {
            Collection<Field> blocks = this.blockList.get(mod);
            for (Field f : blocks) {
                try {
                    o2 = f.get(null);
                    if (o2 instanceof Block) continue;
                    throw new VanillaIntegrityException(mod, f.getName());
                }
                catch (Exception o2) {
                }
            }
        }
        for (DragonAPIMod mod : this.itemList.keySet()) {
            Collection<Field> items = this.itemList.get(mod);
            for (Field f : items) {
                try {
                    o2 = f.get(null);
                    if (o2 instanceof Item) continue;
                    throw new VanillaIntegrityException(mod, f.getName());
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

