/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary;

import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class VillageTradeHandler
implements VillagerRegistry.IVillageTradeHandler {
    public static final VillageTradeHandler instance = new VillageTradeHandler();
    private static final String NBT_KEY = "tradeChanceCache";
    private final ArrayList<TradeHandler> handlers = new ArrayList();

    private VillageTradeHandler() {
    }

    public void addHandler(TradeHandler h) {
        this.handlers.add(h);
    }

    public void manipulateTradesForVillager(EntityVillager ev, MerchantRecipeList li, Random rand) {
        if (ev.field_70963_i == null) {
            ev.field_70963_i = new MerchantRecipeList();
        }
        for (TradeHandler h : this.handlers) {
            h.manipulateTradesForVillager(ev, li, this);
        }
    }

    public boolean withRandomChance(EntityVillager ev, double c, String key) {
        NBTTagCompound tag = ev.getEntityData().func_74775_l(NBT_KEY);
        if (tag.func_74767_n(key)) {
            return false;
        }
        tag.func_74757_a(key, true);
        ev.getEntityData().func_74782_a(NBT_KEY, (NBTBase)tag);
        return ReikaRandomHelper.doWithChance(c);
    }

    public static class TradeToAdd {
        public final Class<? extends MerchantRecipe> recipeType;
        public final double chanceToAdd;
        public final String recipeID;
        public Function<EntityVillager, Boolean> validityCheck;

        public TradeToAdd(Class<? extends MerchantRecipe> c, double ch, String id) {
            this.recipeID = id;
            this.recipeType = c;
            this.chanceToAdd = ch;
        }

        public TradeToAdd setVillagerType(int type) {
            this.validityCheck = e -> e.func_70946_n() == type;
            return this;
        }

        public TradeToAdd setVillagerType(int ... types) {
            this.validityCheck = e -> new HashSet<Integer>(ReikaJavaLibrary.makeIntListFromArray(types)).contains(e.func_70946_n());
            return this;
        }
    }

    public static abstract class SimpleTradeHandler
    implements TradeHandler {
        @Override
        public void manipulateTradesForVillager(EntityVillager ev, MerchantRecipeList li, VillageTradeHandler h) {
            for (TradeToAdd e : this.getTradesToAdd()) {
                if (!h.withRandomChance(ev, e.chanceToAdd, e.recipeID) || e.validityCheck != null && !e.validityCheck.apply(ev).booleanValue() || this.hasMatchingTrade(ev.field_70963_i, e)) continue;
                try {
                    ev.field_70963_i.add((Object)e.recipeType.newInstance());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private boolean hasMatchingTrade(MerchantRecipeList li, TradeToAdd e) {
            for (Object r : li) {
                if (r == null || !e.recipeType.isAssignableFrom(r.getClass())) continue;
                return true;
            }
            return false;
        }

        protected abstract Collection<TradeToAdd> getTradesToAdd();
    }

    public static interface TradeHandler {
        public void manipulateTradesForVillager(EntityVillager var1, MerchantRecipeList var2, VillageTradeHandler var3);
    }
}

