/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Base;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Interfaces.Registry.OreEnum;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public abstract class EnumOreBlock
extends Block {
    private boolean setHarvest = false;

    protected EnumOreBlock(Material mat) {
        super(mat);
    }

    public final void register() {
        for (int i = 0; i < 16; ++i) {
            OreEnum ore = this.getOre(i);
            if (ore == null) continue;
            this.setHarvestLevel(ore.getHarvestTool(), ore.getHarvestLevel(), i);
        }
        this.setHarvest = true;
    }

    public abstract OreEnum getOre(int var1);

    public final OreEnum getOre(World world, int x, int y, int z) {
        return this.getOre(world.func_72805_g(x, y, z));
    }

    public final int getHarvestLevel(int meta) {
        return super.getHarvestLevel(meta);
    }

    public final void setHarvestLevel(String toolClass, int level, int meta) {
        OreEnum ore = this.getOre(meta);
        if (this.setHarvest && ore.enforceHarvestLevel()) {
            DragonAPICore.log("Harvest level of " + ore + " was not set; it chose to disallow it.");
            return;
        }
        super.setHarvestLevel(toolClass, level, meta);
    }

    public final boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harv) {
        OreEnum ore = this.getOre(world, x, y, z);
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        boolean flag = super.removedByPlayer(world, player, x, y, z, harv);
        if (harv && flag) {
            this.onHarvested(world, x, y, z, b, meta, ore, player);
            if (!ore.dropsSelf(world, x, y, z) && !EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
                ReikaWorldHelper.splitAndSpawnXP(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, EnumOreBlock.droppedXP(ore, world, x, y, z));
            }
        }
        return flag;
    }

    protected void onHarvested(World world, int x, int y, int z, Block b, int meta, OreEnum ore, EntityPlayer ep) {
    }

    private static int droppedXP(OreEnum ore, World world, int x, int y, int z) {
        return ReikaRandomHelper.doWithChance(ore.getXPDropped(world, x, y, z)) ? 1 : 0;
    }
}

