/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Base;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaReflectionHelper;
import Reika.DragonAPI.Libraries.Java.SemanticVersionParser;
import Reika.DragonAPI.ModList;
import java.util.Random;

public abstract class ModHandlerBase {
    protected final Random rand = new Random();

    protected ModHandlerBase() {
        this.verifyInstanceField();
    }

    private void verifyInstanceField() {
        if (!ReikaReflectionHelper.checkForField(this.getClass(), "instance", 2, 8, 16)) {
            throw new MisuseException("A mod handler must have a private static final 'instance' field!");
        }
        if (!ReikaReflectionHelper.checkForMethod(this.getClass(), "getInstance", new Class[0], 1, 8)) {
            throw new MisuseException("A mod handler must have a public static 'getInstance()' method!");
        }
    }

    public abstract boolean initializedProperly();

    public abstract ModList getMod();

    protected void noMod() {
    }

    public boolean hasMod() {
        return this.getMod().isLoaded();
    }

    protected final void logFailure(Exception e) {
        ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)this.getMod(), e);
    }

    public static final class SearchVersionHandler
    implements VersionHandler {
        private final String searchKey;

        public SearchVersionHandler(String key) {
            this.searchKey = key;
        }

        @Override
        public boolean acceptVersion(String version) {
            return version.contains(this.searchKey);
        }

        public String toString() {
            return "[Contains '" + this.searchKey + "']";
        }
    }

    public static final class ClassVersionHandler
    implements VersionHandler {
        private final String className;

        public ClassVersionHandler(String key) {
            this.className = key;
        }

        @Override
        public boolean acceptVersion(String version) {
            return ReikaJavaLibrary.doesClassExist(this.className);
        }

        public String toString() {
            return "[Class '" + this.className + "' exists]";
        }
    }

    public static final class SemanticVersionHandler
    implements VersionHandler {
        private final String minimum;
        private final String maximum;

        public SemanticVersionHandler(String min) {
            this(min, true);
        }

        public SemanticVersionHandler(String ver, boolean isMin) {
            this(isMin ? ver : null, isMin ? null : ver);
        }

        public SemanticVersionHandler(String min, String max) {
            this.minimum = min;
            this.maximum = max;
        }

        @Override
        public boolean acceptVersion(String version) {
            boolean min = this.minimum == null || SemanticVersionParser.isVersionAtLeast(this.minimum, version);
            boolean max = this.maximum == null || SemanticVersionParser.isVersionAtMost(version, this.maximum);
            return min && max;
        }

        public String toString() {
            return (this.minimum != null ? this.minimum : "") + " - " + (this.maximum != null ? this.maximum : "");
        }
    }

    public static final class VersionIgnore
    implements VersionHandler {
        @Override
        public boolean acceptVersion(String version) {
            return true;
        }

        public String toString() {
            return "[Any]";
        }
    }

    public static interface VersionHandler {
        public boolean acceptVersion(String var1);
    }
}

