/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Base;

import Reika.DragonAPI.Base.InertEntity;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ParticleEntity
extends InertEntity
implements IEntityAdditionalSpawnData {
    private int oldBlockX;
    private int oldBlockY;
    private int oldBlockZ;
    private Coordinate spawnLocation;
    private boolean outOfSpawn = false;

    public ParticleEntity(World world) {
        super(world);
        this.func_70105_a((float)this.getHitboxSize(), (float)this.getHitboxSize());
    }

    public ParticleEntity(World world, int x, int y, int z) {
        super(world);
        this.spawnAt(x, y, z);
        this.func_70105_a((float)this.getHitboxSize(), (float)this.getHitboxSize());
    }

    public ParticleEntity(World world, int x, int y, int z, ForgeDirection dir) {
        this(world, x, y, z);
        this.setDirection(dir, true);
    }

    public ParticleEntity(World world, int x, int y, int z, ReikaDirectionHelper.CubeDirections dir) {
        this(world, x, y, z);
        this.setDirection(dir, true);
    }

    protected final void spawnAt(Coordinate c) {
        this.spawnAt(c.xCoord, c.yCoord, c.zCoord);
    }

    protected final void spawnAt(int x, int y, int z) {
        this.oldBlockX = x;
        this.oldBlockY = y;
        this.oldBlockZ = z;
        this.spawnLocation = new Coordinate(x, y, z);
        this.func_70012_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0f, 0.0f);
    }

    public final boolean func_70112_a(double rsq) {
        return rsq <= this.getRenderRangeSquared();
    }

    public abstract double getRenderRangeSquared();

    public Coordinate getSpawnLocation() {
        return this.spawnLocation;
    }

    protected void setDirection(ForgeDirection dir, boolean setPos) {
        if (setPos) {
            this.func_70012_b((double)this.getBlockX() + 0.5, (double)this.getBlockY() + 0.5, (double)this.getBlockZ() + 0.5, 0.0f, 0.0f);
        }
        this.field_70159_w = (double)dir.offsetX * this.getSpeed();
        this.field_70181_x = (double)dir.offsetY * this.getSpeed();
        this.field_70179_y = (double)dir.offsetZ * this.getSpeed();
        this.field_70133_I = true;
    }

    protected void setDirection(ReikaDirectionHelper.CubeDirections dir, boolean setPos) {
        if (setPos) {
            this.func_70012_b((double)this.getBlockX() + 0.5, (double)this.getBlockY() + 0.5, (double)this.getBlockZ() + 0.5, 0.0f, 0.0f);
        }
        this.field_70159_w = (double)dir.directionX * this.getSpeed();
        this.field_70181_x = 0.0;
        this.field_70179_y = (double)dir.directionZ * this.getSpeed();
        this.field_70133_I = true;
    }

    protected void func_70088_a() {
    }

    public abstract double getHitboxSize();

    public abstract boolean despawnOverTime();

    public abstract boolean despawnOverDistance();

    protected double getDespawnDistance() {
        return 0.0;
    }

    public abstract boolean canInteractWithSpawnLocation();

    public final void func_70071_h_() {
        this.func_70030_z();
        if (this.needsSpeedUpdates()) {
            this.updateSpeed();
        }
        if (this.dieOnNoVelocity() && this.field_70159_w == 0.0 && this.field_70181_x == 0.0 && this.field_70179_y == 0.0 && this.field_70173_aa > 20) {
            this.func_70106_y();
            this.onDeath();
            return;
        }
        if (this.field_70163_u > 256.0 || this.field_70163_u < 0.0) {
            this.func_70106_y();
            this.onDeath();
            return;
        }
        if (this.despawnOverTime() && this.field_70173_aa > 120 && ReikaRandomHelper.doWithChance(this.field_70173_aa - 120)) {
            this.func_70106_y();
            this.onDeath();
            return;
        }
        if (this.despawnOverDistance() && this.spawnLocation != null && this.spawnLocation.getDistanceTo(this) >= this.getDespawnDistance()) {
            this.func_70106_y();
            this.onDeath();
            return;
        }
        if (this.isNewBlock()) {
            int x = this.getBlockX();
            int y = this.getBlockY();
            int z = this.getBlockZ();
            this.oldBlockX = x;
            this.oldBlockY = y;
            this.oldBlockZ = z;
            boolean bl = this.outOfSpawn = !new Coordinate(x, y, z).equals(this.spawnLocation);
            if ((this.canInteractWithSpawnLocation() || this.outOfSpawn) && this.onEnterBlock(this.field_70170_p, x, y, z)) {
                this.onDeath();
                this.func_70106_y();
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            double s = this.getHitboxSize();
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72314_b(s, s, s);
            List inbox = this.field_70170_p.func_72872_a(Entity.class, box);
            for (Entity e : inbox) {
                this.func_70108_f(e);
            }
        }
        this.onTick();
    }

    protected boolean dieOnNoVelocity() {
        return true;
    }

    protected boolean needsSpeedUpdates() {
        return false;
    }

    protected void updateSpeed() {
    }

    protected void onDeath() {
    }

    protected abstract void onTick();

    public abstract double getSpeed();

    protected abstract boolean onEnterBlock(World var1, int var2, int var3, int var4);

    @Override
    public abstract void func_70108_f(Entity var1);

    public final int getBlockX() {
        return (int)Math.floor(this.field_70165_t);
    }

    public final int getBlockY() {
        return (int)Math.floor(this.field_70163_u);
    }

    public final int getBlockZ() {
        return (int)Math.floor(this.field_70161_v);
    }

    public final boolean isNewBlock() {
        int z;
        int y;
        int x = this.getBlockX();
        return !this.compareBlocks(x, y = this.getBlockY(), z = this.getBlockZ()) && this.isInsideThreshold(x, y, z);
    }

    private boolean isInsideThreshold(int x, int y, int z) {
        double t = this.getBlockThreshold();
        return ReikaMathLibrary.isValueInsideBounds((double)x + 0.5 - t, (double)x + 0.5 + t, this.field_70165_t) && ReikaMathLibrary.isValueInsideBounds((double)y + 0.5 - t, (double)y + 0.5 + t, this.field_70163_u) && ReikaMathLibrary.isValueInsideBounds((double)z + 0.5 - t, (double)z + 0.5 + t, this.field_70161_v);
    }

    protected double getBlockThreshold() {
        return 0.5;
    }

    private final boolean compareBlocks(int x, int y, int z) {
        return x == this.oldBlockX && y == this.oldBlockY && z == this.oldBlockZ;
    }

    public final AxisAlignedBB func_70046_E() {
        return null;
    }

    @Override
    public final boolean func_85032_ar() {
        return true;
    }

    public final boolean func_90999_ad() {
        return false;
    }

    public void writeSpawnData(ByteBuf data) {
        if (this.spawnLocation != null) {
            this.spawnLocation.writeToBuf(data);
        } else {
            new Coordinate(0, 0, 0).writeToBuf(data);
        }
    }

    public void readSpawnData(ByteBuf data) {
        this.spawnLocation = Coordinate.readFromBuf(data);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.spawnLocation = Coordinate.readFromNBT("spawn", tag);
    }

    protected void func_70014_b(NBTTagCompound tag) {
        if (this.spawnLocation != null) {
            this.spawnLocation.writeToNBT("spawn", tag);
        }
    }

    public final void func_70076_C() {
        this.onDeath();
        super.func_70076_C();
    }
}

