/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Command.DragonClientCommand;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.IntBuffer;
import java.util.Locale;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class DumpTextureBufferCommand
extends DragonClientCommand {
    public void func_71515_b(ICommandSender ics, String[] args) {
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "terrain": {
                ReikaTextureHelper.bindTerrainTexture();
                break;
            }
            case "items": {
                ReikaTextureHelper.bindItemTexture();
                break;
            }
            case "particles": {
                ReikaTextureHelper.bindParticleTexture();
                break;
            }
            case "enchant": {
                ReikaTextureHelper.bindEnchantmentTexture();
            }
        }
        int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int len = w * h;
        IntBuffer pixelBuffer = BufferUtils.createIntBuffer((int)len);
        int[] pixelValues = new int[len];
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
        pixelBuffer.get(pixelValues);
        this.flipPixelArray(pixelValues, w, h);
        BufferedImage img = new BufferedImage(w, h, 2);
        for (int k = 0; k < h; ++k) {
            for (int i = 0; i < w; ++i) {
                img.setRGB(i, h - 1 - k, pixelValues[k * w + i]);
            }
        }
        try {
            File root = new File(Minecraft.func_71410_x().field_71412_D, "TextureExport");
            root.mkdirs();
            File f = new File(root, args[0] + ".png");
            ImageIO.write((RenderedImage)img, "png", f);
            DumpTextureBufferCommand.sendChatToSender(ics, "Texture exported to " + f.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void flipPixelArray(int[] data, int width, int height) {
        int[] temp = new int[width];
        int k = height / 2;
        for (int l = 0; l < k; ++l) {
            System.arraycopy(data, l * width, temp, 0, width);
            System.arraycopy(data, (height - 1 - l) * width, data, l * width, width);
            System.arraycopy(temp, 0, data, (height - 1 - l) * width, width);
        }
    }

    @Override
    public String getCommandString() {
        return "dumptexture";
    }
}

