/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;

public class FindBiomeCommand
extends DragonCommandBase {
    public void func_71515_b(ICommandSender ics, String[] args) {
        int[] nArray;
        EntityPlayerMP ep = FindBiomeCommand.func_71521_c((ICommandSender)ics);
        int step = 256;
        int x0 = MathHelper.func_76128_c((double)ep.field_70165_t);
        int z0 = MathHelper.func_76128_c((double)ep.field_70161_v);
        BiomeGenBase target = null;
        if (args.length == 1) {
            try {
                target = BiomeGenBase.field_76773_a[Integer.parseInt(args[0])];
            }
            catch (NumberFormatException e) {
                target = ReikaBiomeHelper.getBiomeByName(args[0]);
            }
        }
        if (target != null) {
            int[] nArray2 = new int[5];
            nArray2[0] = 2048;
            nArray2[1] = 8192;
            nArray2[2] = 16384;
            nArray2[3] = 32768;
            nArray = nArray2;
            nArray2[4] = 65536;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 4096;
        }
        int[] rstep = nArray;
        boolean found = false;
        for (int i = 0; i < rstep.length && !found; ++i) {
            int r = rstep[i];
            MultiMap<String, Coordinate> map = new MultiMap<String, Coordinate>();
            for (int x = -r; x <= r; x += step) {
                for (int z = -r; z <= r; z += step) {
                    BiomeGenBase b = ReikaWorldHelper.getNaturalGennedBiomeAt(ep.field_70170_p, x0 + x, z0 + z);
                    if (target != null && b == target) {
                        found = true;
                    }
                    map.addValue(b.field_76791_y, new Coordinate(x0 + x, 0, z0 + z));
                }
            }
            if (target == null) {
                for (String n : map.keySet()) {
                    FindBiomeCommand.sendChatToSender(ics, "Search R=" + r + ": " + n + ": " + map.get(n));
                }
                continue;
            }
            FindBiomeCommand.sendChatToSender(ics, "Search R=" + r + ": " + target.field_76791_y + ": " + map.get(target.field_76791_y));
        }
    }

    @Override
    public String getCommandString() {
        return "findbiome";
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }
}

