/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerMap;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.EnumSet;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;

public class PopulateMinimapCommand
extends DragonCommandBase {
    private static boolean init = false;

    private static void init() {
        TickRegistry.instance.registerTickHandler(PopulationTickHandler.instance);
    }

    public void func_71515_b(ICommandSender ics, String[] args) {
        if (args.length < 1 || args.length > 3) {
            PopulateMinimapCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Invalid arguments. Format: /populatemap [range] <stepsize> <delay>");
            return;
        }
        if (!init) {
            PopulateMinimapCommand.init();
            init = true;
        }
        if (args[0].equalsIgnoreCase("clear")) {
            PopulationTickHandler.instance.movements.clear();
            return;
        }
        int r = Integer.parseInt(args[0]);
        int d = args.length >= 2 ? Integer.parseInt(args[1]) : 500;
        int t = args.length >= 3 ? Integer.parseInt(args[2]) : 100;
        EntityPlayerMP ep = PopulateMinimapCommand.func_71521_c((ICommandSender)ics);
        PopulationTickHandler.instance.movements.put((EntityPlayer)ep, new PlayerMovement((EntityPlayer)ep, r, d, t));
    }

    @Override
    public String getCommandString() {
        return "populatemap";
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }

    private static class PlayerMovement {
        private final EntityPlayer player;
        private final int stepSize;
        private final int delayTime;
        private final int range;
        private final int originX;
        private final int originZ;
        private int cooldown;
        private int posX;
        private int posZ;

        private PlayerMovement(EntityPlayer ep, int r, int s, int t) {
            this.player = ep;
            this.originX = MathHelper.func_76128_c((double)ep.field_70165_t);
            this.originZ = MathHelper.func_76128_c((double)ep.field_70161_v);
            this.range = r;
            this.stepSize = s;
            this.delayTime = t;
            this.posX = -this.range;
            this.posZ = -this.range;
        }

        private boolean update() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.cooldown = this.delayTime;
            boolean flag1 = false;
            boolean flag2 = false;
            this.posX += this.stepSize;
            if (this.posX > this.originX + this.range) {
                this.posX = this.originX - this.range;
                flag1 = true;
            }
            if (flag1) {
                this.posZ += this.stepSize;
                if (this.posZ > this.originZ + this.range) {
                    this.posZ = this.originZ - this.range;
                    flag2 = true;
                }
                if (flag2) {
                    DragonAPICore.log("Map population of radius " + this.range + " complete.");
                    return true;
                }
            }
            this.player.func_70634_a((double)this.posX, 110.0, (double)this.posZ);
            DragonAPICore.log("Populating map: Stepping player " + this.player.func_70005_c_() + " to " + this.posX + ", " + this.posZ);
            return false;
        }
    }

    private static class PopulationTickHandler
    implements TickRegistry.TickHandler {
        private static final PopulationTickHandler instance = new PopulationTickHandler();
        private PlayerMap<PlayerMovement> movements = new PlayerMap();

        private PopulationTickHandler() {
        }

        @Override
        public void tick(TickRegistry.TickType type, Object ... tickData) {
            PlayerMovement p;
            EntityPlayer ep = (EntityPlayer)tickData[0];
            if (!ep.field_70170_p.field_72995_K && (p = this.movements.get(ep)) != null && p.update()) {
                this.movements.remove(ep);
            }
        }

        @Override
        public EnumSet<TickRegistry.TickType> getType() {
            return EnumSet.of(TickRegistry.TickType.PLAYER);
        }

        @Override
        public boolean canFire(TickEvent.Phase p) {
            return p == TickEvent.Phase.START;
        }

        @Override
        public String getLabel() {
            return "mappopulate";
        }
    }
}

