/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Auxiliary.Trackers.WorldgenProfiler;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class WorldGenProfilerCommand
extends DragonCommandBase {
    public void func_71515_b(ICommandSender ics, String[] args) {
        if (args.length < 1) {
            WorldGenProfilerCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Wrong number of arguments. Specify 'disable', 'enable', or 'display'.");
            return;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "disable": {
                WorldgenProfiler.finishProfiling();
                WorldGenProfilerCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "Profiling finished.");
                break;
            }
            case "enable": {
                World world;
                World world2 = ics instanceof EntityPlayerMP ? WorldGenProfilerCommand.func_71521_c((ICommandSender)ics).field_70170_p : (world = DimensionManager.getWorld((int)Integer.parseInt(args[1])));
                if (WorldgenProfiler.enableProfiling(world)) {
                    WorldGenProfilerCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "Profiling started in world #" + world.field_73011_w.field_76574_g + ".");
                    break;
                }
                WorldGenProfilerCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Profiling already running or its hooks are not enabled!");
                break;
            }
            case "display": {
                int worldid = WorldgenProfiler.getWorld();
                List<WorldgenProfiler.GeneratorProfile> li = WorldgenProfiler.getProfilingData();
                int chunks = WorldgenProfiler.getProfiledChunks().size();
                long total = WorldgenProfiler.getTotalProfilingTime();
                String totalt = String.format("%.6f", (double)total / 1000000.0);
                String desc = "Profiling data for world #" + worldid + " contains " + li.size() + " generators across " + chunks + " chunks, total time " + totalt + " ms:";
                DragonAPICore.log(desc);
                for (WorldgenProfiler.GeneratorProfile g : li) {
                    long time = g.getAverageTime();
                    String s = ReikaStringParser.padToLength("'" + g.identifier + "'", 96, " ");
                    double percent = (double)g.getTotalTime() * 100.0 / (double)total;
                    String sg = String.format("Generator %s - Average Time Per Chunk: %7.3f microseconds (%2.3f%s); Spilled chunks: %4d", s, (double)time / 1000.0, percent, "%%", g.getSpilledChunks());
                    DragonAPICore.log(sg);
                }
                WorldGenProfilerCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "Profiling data written to log.");
                break;
            }
            default: {
                WorldGenProfilerCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Invalid argument. Specify 'disable', 'enable', or 'display'.");
            }
        }
    }

    @Override
    public String getCommandString() {
        return "profilegen";
    }

    @Override
    protected boolean isAdminOnly() {
        return DragonOptions.ADMINPROFILERS.getState();
    }
}

