/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO.Shaders;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.IO.Shaders.ShaderLibrary;
import Reika.DragonAPI.IO.Shaders.ShaderProgram;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import com.google.common.base.Charsets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

@SideOnly(value=Side.CLIENT)
public class ShaderRegistry {
    private static final HashMap<String, ShaderProgram> shaders = new HashMap();
    private static final EnumMap<ShaderDomain, ArrayList<ShaderProgram>> shaderSets = new EnumMap(ShaderDomain.class);
    private static final int GLSL_VERSION = 120;
    private static String BASE_DATA;
    private static WorldShaderSystem worldShaderSystem;
    private static ShaderProgram currentlyRunning;
    private static ShaderDomain activeType;
    private static final HashSet<String> reloadKeyPressed;

    private ShaderRegistry() {
        throw new RuntimeException("The class " + this.getClass() + " cannot be instantiated!");
    }

    public static void registerWorldShaderSystem(WorldShaderSystem ws) {
        if (worldShaderSystem != null) {
            throw new RegistrationException(ws.getMod(), "A world shader system (" + worldShaderSystem + ") is already registered, so another (" + ws + ") cannot be.");
        }
        worldShaderSystem = ws;
    }

    public static ShaderProgram createShader(DragonAPIMod mod, String id, Class root, String pathPre, ShaderDomain dom) {
        if (!OpenGlHelper.field_148824_g) {
            return null;
        }
        ShaderLibrary.loadLibraries();
        if (shaders.containsKey(id)) {
            ShaderRegistry.error(mod, id, "Shader id " + id + " is already in use!", null);
        }
        ShaderProgram sh = new ShaderProgram(mod, root, pathPre, id, dom);
        try {
            sh.load();
        }
        catch (IOException e) {
            ShaderRegistry.error(mod, id, "Shader program data could not be loaded!", null, e);
        }
        shaders.put(sh.identifier, sh);
        ShaderRegistry.addShaderToSet(dom, sh);
        DragonAPICore.log("Registered " + mod.getTechnicalName() + " shader " + sh);
        return sh;
    }

    private static void addShaderToSet(ShaderDomain dom, ShaderProgram s) {
        ArrayList<ShaderProgram> li = shaderSets.get((Object)dom);
        if (li == null) {
            li = new ArrayList();
            shaderSets.put(dom, li);
        }
        li.add(s);
        Collections.sort(li);
    }

    private static void removeShaderFromSet(ShaderDomain dom, ShaderProgram s) {
        ArrayList<ShaderProgram> li = shaderSets.get((Object)dom);
        if (li != null) {
            li.remove(s);
        }
    }

    public static void reloadShader(String id) throws IOException {
        DragonAPICore.log("Reloading shader " + id);
        ShaderProgram sp = shaders.get(id);
        for (ShaderLibrary lib : sp.getLibraries()) {
            DragonAPICore.log("Reloading shader library " + lib.name);
            lib.reload();
        }
        sp.load();
    }

    public static void runShader(String id) {
        ShaderRegistry.runShader(shaders.get(id));
    }

    public static boolean runShader(ShaderProgram sh) {
        if (!OpenGlHelper.field_148824_g || sh == null) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return false;
        }
        if (currentlyRunning != null && currentlyRunning != sh) {
            ShaderRegistry.error(sh.owner, sh.identifier, "Cannot start one shader while another is running!", null);
        }
        if (ShaderRegistry.reloadKey()) {
            if (!reloadKeyPressed.contains(sh.identifier)) {
                reloadKeyPressed.add(sh.identifier);
                try {
                    ShaderRegistry.reloadShader(sh.identifier);
                }
                catch (IOException e) {
                    ShaderRegistry.error(sh.owner, sh.identifier, "Shader threw IOException during reload!", null, e);
                }
            }
        } else {
            reloadKeyPressed.remove(sh.identifier);
        }
        currentlyRunning = sh;
        if (GuiScreen.func_146271_m() && Keyboard.isKeyDown((int)56) && Keyboard.isKeyDown((int)46) && ReikaObfuscationHelper.isDeObfEnvironment()) {
            return false;
        }
        if (currentlyRunning.needsErrorChecking()) {
            while (GL11.glGetError() != 0) {
            }
        }
        return sh.run();
    }

    private static boolean reloadKey() {
        return GuiScreen.func_146271_m() && GuiScreen.func_146272_n() && Keyboard.isKeyDown((int)45);
    }

    public static void completeShader() {
        if (!OpenGlHelper.field_148824_g) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (currentlyRunning == null) {
            ShaderRegistry.error(DragonAPIInit.instance, null, "Cannot stop a shader when none is running!", null);
        }
        GL20.glUseProgram((int)0);
        currentlyRunning.checkForError();
        currentlyRunning = null;
    }

    static int constructShader(DragonAPIMod mod, String name, InputStream data, ShaderTypes type, Collection<ShaderLibrary> libs) throws IOException {
        int id;
        if (data == null) {
            ShaderRegistry.error(mod, name, "Shader has null program data!", type);
        }
        if ((id = GL20.glCreateShader((int)type.glValue)) == 0) {
            ShaderRegistry.error(mod, name, "Shader was not able to be assigned an ID!", type);
        }
        if (BASE_DATA == null) {
            BASE_DATA = ShaderRegistry.readData(DragonAPIInit.instance, "base", type, DragonAPICore.class.getResourceAsStream("Resources/Shader/base.txt"), libs);
        }
        String sdata = "#version 120\n";
        if (type == ShaderTypes.FRAGMENT) {
            sdata = sdata + "uniform sampler2D bgl_RenderedTexture;\n";
        }
        sdata = sdata + BASE_DATA + "\n";
        sdata = sdata + ShaderRegistry.readData(mod, name, type, data, libs);
        GL20.glShaderSource((int)id, (CharSequence)sdata);
        GL20.glCompileShader((int)id);
        if (GL20.glGetShaderi((int)id, (int)35713) == 0) {
            ShaderRegistry.error(mod, name, "Shader was not able to be constructed: " + ShaderRegistry.parseError(id), type);
        }
        return id;
    }

    static void error(DragonAPIMod mod, String id, String msg, ShaderTypes type) {
        ShaderRegistry.error(mod, id, msg, type, null);
    }

    static void error(DragonAPIMod mod, String id, String msg, ShaderTypes type, Exception e) {
        String t;
        ShaderProgram p;
        if (id != null && (p = shaders.get(id)) != null) {
            p.markErrored();
        }
        String string = t = type != null ? type.name() : "";
        if (DragonAPICore.hasGameLoaded()) {
            String s = t + " shader error: " + msg;
            mod.getModLogger().logError(s);
            ReikaChatHelper.write(s);
            if (e != null) {
                e.printStackTrace();
            }
        } else {
            String msg2 = msg;
            if (type != null) {
                msg2 = t + " " + msg2;
            }
            if (id != null) {
                msg2 = id + " " + msg2;
            }
            throw new RegistrationException(mod, msg2, e);
        }
    }

    private static String readData(DragonAPIMod mod, String id, ShaderTypes type, InputStream data, Collection<ShaderLibrary> libs) {
        StringBuilder sb = new StringBuilder();
        List<String> li = ReikaFileReader.getFileAsLines(data, true, Charsets.UTF_8);
        for (String s : li) {
            ShaderLibrary lib;
            String[] parts;
            if (s.startsWith("#import")) {
                parts = s.split(" ");
                lib = ShaderLibrary.getLibrary(parts[1]);
                if (lib == null) {
                    ShaderRegistry.error(mod, id, "Invalid import - no such library '" + parts[1] + "'", type);
                }
                libs.add(lib);
                s = "\n\n" + lib.getCode();
            } else if (s.startsWith("#generate")) {
                parts = s.split(" ");
                try {
                    lib = ShaderLibrary.getCompute(parts[1], Arrays.copyOfRange(parts, 2, parts.length));
                    if (lib == null) {
                        ShaderRegistry.error(mod, id, "Invalid generate - no such generator '" + parts[1] + "'", type);
                    }
                    libs.add(lib);
                    s = "\n\n" + lib.getCode();
                }
                catch (Exception e) {
                    ShaderRegistry.error(mod, id, "Invalid generate - threw reflective error for '" + parts[1] + "': " + e.toString(), type);
                    e.printStackTrace();
                }
            }
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void flagShaderDomain(ShaderDomain sd) {
        activeType = sd;
        if (sd == ShaderDomain.WORLD && worldShaderSystem != null) {
            worldShaderSystem.onPreWorldRender();
        }
    }

    public static void completeActiveShaderType() {
        if (activeType != null) {
            if (activeType == ShaderDomain.WORLD && worldShaderSystem != null) {
                worldShaderSystem.onPostWorldRender();
            }
            activeType = null;
        }
    }

    public static void applyWorldShaders(IntBuffer lists) {
        if (worldShaderSystem == null || !worldShaderSystem.apply(lists)) {
            GL11.glCallLists((IntBuffer)lists);
        }
    }

    public static void runShaderDomain(Framebuffer fb, int w, int h, ShaderDomain sd) {
        ShaderRegistry.flagShaderDomain(sd);
        ArrayList<ShaderProgram> li = shaderSets.get((Object)sd);
        if (li != null) {
            for (ShaderProgram s : li) {
                ReikaRenderHelper.renderFrameBufferToItself(fb, w, h, s);
            }
        }
        ShaderRegistry.completeActiveShaderType();
    }

    public static String parseError(int programID) {
        return GL20.glGetShaderInfoLog((int)programID, (int)524288);
    }

    static {
        reloadKeyPressed = new HashSet();
    }

    public static interface WorldShaderSystem {
        public DragonAPIMod getMod();

        public void onPreWorldRender();

        public boolean apply(IntBuffer var1);

        public void onPostWorldRender();
    }

    public static enum ShaderTypes {
        FRAGMENT(35632, "frag"),
        VERTEX(35633, "vert"),
        TESSELLATION(36487, "tess");

        public final int glValue;
        public final String extension;

        private ShaderTypes(int id, String s) {
            this.glValue = id;
            this.extension = s;
        }
    }

    public static enum ShaderDomain {
        WORLD,
        TESR,
        ENTITY,
        GUI,
        GLOBAL,
        GLOBALNOGUI;

    }
}

