/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class BasicInventory
implements IInventory {
    public final int inventorySize;
    public final int stackLimit;
    public final String name;
    protected ItemStack[] inv;

    public BasicInventory(String n, int size) {
        this(n, size, 64);
    }

    public BasicInventory(String n, int size, int limit) {
        this.inventorySize = size;
        this.stackLimit = limit;
        this.inv = new ItemStack[size];
        this.name = n;
    }

    public final int func_70302_i_() {
        return this.inventorySize;
    }

    public final ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public final ItemStack func_70298_a(int slot, int decr) {
        return ReikaInventoryHelper.decrStackSize(this, slot, decr);
    }

    public final ItemStack func_70304_b(int slot) {
        return ReikaInventoryHelper.getStackInSlotOnClosing(this, slot);
    }

    public final void func_70299_a(int slot, ItemStack is) {
        this.inv[slot] = is;
        this.onSlotChange(slot);
    }

    protected void onSlotChange(int slot) {
    }

    public final String func_145825_b() {
        return this.name;
    }

    public final boolean func_145818_k_() {
        return true;
    }

    public final int func_70297_j_() {
        return this.stackLimit;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer ep) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public final ItemStack[] getItems() {
        return Arrays.copyOf(this.inv, this.inv.length);
    }

    public void writeToNBT(NBTTagCompound root, String tag) {
        NBTTagCompound NBT = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        NBT.func_74782_a("Items", (NBTBase)nbttaglist);
        root.func_74782_a(tag, (NBTBase)NBT);
    }

    public void readFromNBT(NBTTagCompound root, String tag) {
        this.inv = new ItemStack[this.func_70302_i_()];
        NBTTagCompound NBT = root.func_74775_l(tag);
        if (NBT == null || NBT.func_82582_d()) {
            return;
        }
        NBTTagList nbttaglist = NBT.func_150295_c("Items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.inv.length) continue;
            this.inv[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
    }
}

