/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.command.IEntitySelector;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class CompoundAABB {
    private final Random rand = new Random();
    private final Collection<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
    private final WeightedRandom<AxisAlignedBB> boxVolumes = new WeightedRandom();
    private double minX = 2.147483647E9;
    private double minY = 2.147483647E9;
    private double minZ = 2.147483647E9;
    private double maxX = -2.147483648E9;
    private double maxY = -2.147483648E9;
    private double maxZ = -2.147483648E9;

    public CompoundAABB() {
    }

    public CompoundAABB(BlockArray arr) {
        for (BlockArray b : arr.splitToRectangles()) {
            this.addAABB(b.asAABB());
        }
    }

    public CompoundAABB addAABB(AxisAlignedBB box) {
        this.boxes.add(box);
        this.boxVolumes.addEntry(box, ReikaAABBHelper.getVolume(box));
        this.minX = Math.min(this.minX, box.field_72340_a);
        this.minY = Math.min(this.minY, box.field_72338_b);
        this.minZ = Math.min(this.minZ, box.field_72339_c);
        this.maxX = Math.max(this.maxX, box.field_72336_d);
        this.maxY = Math.max(this.maxY, box.field_72337_e);
        this.maxZ = Math.max(this.maxZ, box.field_72334_f);
        return this;
    }

    public ArrayList getEntitiesWithinAABB(Class c, World world) {
        return this.selectEntitiesWithinAABB(c, world, null);
    }

    public ArrayList selectEntitiesWithinAABB(Class c, World world, IEntitySelector sel) {
        HashSet set = new HashSet();
        for (AxisAlignedBB box : this.boxes) {
            set.addAll(world.func_82733_a(c, box, sel));
        }
        return new ArrayList(set);
    }

    public AxisAlignedBB getRandomComponentBox(boolean proportionToSize) {
        return proportionToSize ? this.boxVolumes.getRandomEntry() : ReikaJavaLibrary.getRandomCollectionEntry(this.rand, this.boxes);
    }

    public double getVolume() {
        double ret = 0.0;
        for (AxisAlignedBB box : this.boxes) {
            ret += ReikaAABBHelper.getVolume(box);
        }
        return ret;
    }

    public double minX() {
        return this.minX;
    }

    public double minY() {
        return this.minY;
    }

    public double minZ() {
        return this.minZ;
    }

    public double maxX() {
        return this.maxX;
    }

    public double maxY() {
        return this.maxY;
    }

    public double maxZ() {
        return this.maxZ;
    }
}

