/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Auxiliary.BlockArrayComputer;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.AbstractSearch;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Interfaces.Block.SemiTransparent;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;

public class BlockArray
implements Iterable<Coordinate> {
    private static final int DEPTH_LIMIT = BlockArray.getMaxDepth();
    protected static final Random rand = new Random();
    private final ArrayList<Coordinate> blocks = new ArrayList();
    private final HashSet<Coordinate> keys = new HashSet();
    protected boolean overflow = false;
    protected World refWorld;
    private int minX = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int minZ = Integer.MAX_VALUE;
    private int maxZ = Integer.MIN_VALUE;
    public int maxDepth = DEPTH_LIMIT;
    public boolean clampToChunkLoad = false;
    public boolean extraSpread = false;
    public boolean taxiCabDistance = false;
    private final BlockArrayComputer computer;
    public BlockBox bounds = BlockBox.infinity();
    private static final Comparator<Coordinate> heightComparator = new HeightComparator(false);
    private static final Comparator<Coordinate> heightComparator2 = new HeightComparator(true);

    public BlockArray() {
        this(null);
    }

    private static int getMaxDepth() {
        int get = ReikaJavaLibrary.getMaximumRecursiveDepth();
        return get > 1000 ? get - 250 : Integer.MAX_VALUE;
    }

    public BlockArray(Collection<Coordinate> li) {
        this.computer = new BlockArrayComputer(this);
        if (li != null) {
            for (Coordinate c : li) {
                this.addBlockCoordinate(c.xCoord, c.yCoord, c.zCoord);
            }
        }
    }

    public BlockArray setWorld(World world) {
        this.refWorld = world;
        return this;
    }

    public boolean addBlockCoordinate(int x, int y, int z) {
        if (this.overflow) {
            return false;
        }
        if (this.hasBlock(x, y, z)) {
            return false;
        }
        if (!this.bounds.isBlockInside(x, y, z)) {
            return false;
        }
        Coordinate c = new Coordinate(x, y, z);
        this.addKey(c);
        this.setLimits(x, y, z);
        return true;
    }

    protected void addKey(Coordinate c) {
        this.blocks.add(c);
        this.keys.add(c);
    }

    public boolean addBlockCoordinateIf(World world, int x, int y, int z, Block b, int meta) {
        return this.addBlockCoordinateIf(world, x, y, z, new BlockKey(b, meta));
    }

    public boolean addBlockCoordinateIf(World world, int x, int y, int z, Block b) {
        return this.addBlockCoordinateIf(world, x, y, z, new BlockKey(b));
    }

    public boolean addBlockCoordinateIf(World world, int x, int y, int z, BlockKey bk) {
        if (bk.matchInWorld(world, x, y, z)) {
            return this.addBlockCoordinate(x, y, z);
        }
        return false;
    }

    public boolean addBlockCoordinateIf(World world, int x, int y, int z, Collection<BlockKey> bk) {
        if (bk.contains(BlockKey.getAt((IBlockAccess)world, x, y, z))) {
            return this.addBlockCoordinate(x, y, z);
        }
        return false;
    }

    public void remove(int x, int y, int z) {
        Coordinate c = new Coordinate(x, y, z);
        this.removeKey(c);
        if (this.isEdge(x, y, z)) {
            this.recalcLimits();
        }
    }

    protected void removeKey(Coordinate c) {
        this.blocks.remove(c);
        this.keys.remove(c);
    }

    protected boolean containsKey(Coordinate c) {
        return this.keys.contains(c);
    }

    public void recalcLimits() {
        this.resetLimits();
    }

    private void resetLimits() {
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.minZ = Integer.MAX_VALUE;
        this.maxZ = Integer.MIN_VALUE;
        for (Coordinate c : this.blocks) {
            this.setLimits(c.xCoord, c.yCoord, c.zCoord);
        }
    }

    public final boolean isEdge(int x, int y, int z) {
        return this.isEdgeX(x) || this.isEdgeY(y) || this.isEdgeZ(z);
    }

    public final boolean isEdgeX(int x) {
        return x == this.minX || x == this.maxX;
    }

    public final boolean isEdgeY(int y) {
        return y == this.minY || y == this.maxY;
    }

    public final boolean isEdgeZ(int z) {
        return z == this.minZ || z == this.maxZ;
    }

    public final int getMinX() {
        return this.minX;
    }

    public final int getMaxX() {
        return this.maxX;
    }

    public final int getMinY() {
        return this.minY;
    }

    public final int getMaxY() {
        return this.maxY;
    }

    public final int getMinZ() {
        return this.minZ;
    }

    public final int getMaxZ() {
        return this.maxZ;
    }

    public final int getSizeX() {
        return this.isEmpty() ? 0 : this.maxX - this.minX + 1;
    }

    public final int getSizeY() {
        return this.isEmpty() ? 0 : this.maxY - this.minY + 1;
    }

    public final int getSizeZ() {
        return this.isEmpty() ? 0 : this.maxZ - this.minZ + 1;
    }

    public final int getVolume() {
        return this.getSizeX() * this.getSizeY() * this.getSizeZ();
    }

    private final void setLimits(int x, int y, int z) {
        if (x < this.minX) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
    }

    public Coordinate getNextBlock() {
        if (this.isEmpty()) {
            return null;
        }
        return this.blocks.get(0);
    }

    public Coordinate getNthBlock(int n) {
        if (this.isEmpty()) {
            return null;
        }
        return this.blocks.get(n);
    }

    public Set<Coordinate> keySet() {
        return Collections.unmodifiableSet(this.keys);
    }

    public List<Coordinate> list() {
        return Collections.unmodifiableList(this.blocks);
    }

    public Coordinate getNextAndMoveOn() {
        if (this.isEmpty()) {
            return null;
        }
        Coordinate next = this.getNextBlock();
        this.remove(0);
        if (this.isEmpty()) {
            this.overflow = false;
        }
        return next;
    }

    public final int getBottomBlockAtXZ(int x, int z) {
        int minY = Integer.MAX_VALUE;
        for (Coordinate c : this.keySet()) {
            if (c.yCoord >= minY) continue;
            minY = c.yCoord;
        }
        return minY;
    }

    public final int getSize() {
        return this.blocks.size();
    }

    public void clear() {
        this.blocks.clear();
        this.keys.clear();
        this.overflow = false;
    }

    public final boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    public final boolean hasBlock(int x, int y, int z) {
        return this.containsKey(new Coordinate(x, y, z));
    }

    public final boolean hasBlock(Coordinate c) {
        return this.containsKey(c);
    }

    public void recursiveAdd(IBlockAccess world, int x, int y, int z, Block id) {
        this.recursiveAdd(world, x, y, z, x, y, z, id, 0, new HashMap<Coordinate, Integer>());
    }

    private void recursiveAdd(IBlockAccess world, int x0, int y0, int z0, int x, int y, int z, Block id, int depth, HashMap<Coordinate, Integer> map) {
        if (this.overflow) {
            return;
        }
        if (depth > this.maxDepth) {
            return;
        }
        if (this.taxiCabDistance && Math.abs(x - x0) + Math.abs(y - y0) + Math.abs(z - z0) > this.maxDepth) {
            return;
        }
        if (world.func_147439_a(x, y, z) != id) {
            return;
        }
        Coordinate c = new Coordinate(x, y, z);
        if (map.containsKey(c) && depth >= map.get(c)) {
            return;
        }
        this.addBlockCoordinate(x, y, z);
        map.put(c, depth);
        try {
            if (this.extraSpread) {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.recursiveAdd(world, x0, y0, z0, x + i, y + j, z + k, id, depth + 1, map);
                        }
                    }
                }
            } else {
                this.recursiveAdd(world, x0, y0, z0, x + 1, y, z, id, depth + 1, map);
                this.recursiveAdd(world, x0, y0, z0, x - 1, y, z, id, depth + 1, map);
                this.recursiveAdd(world, x0, y0, z0, x, y + 1, z, id, depth + 1, map);
                this.recursiveAdd(world, x0, y0, z0, x, y - 1, z, id, depth + 1, map);
                this.recursiveAdd(world, x0, y0, z0, x, y, z + 1, id, depth + 1, map);
                this.recursiveAdd(world, x0, y0, z0, x, y, z - 1, id, depth + 1, map);
            }
        }
        catch (StackOverflowError e) {
            this.throwOverflow(depth);
            e.printStackTrace();
        }
    }

    public void recursiveAddWithMetadata(IBlockAccess world, int x, int y, int z, Block id, int meta) {
        this.recursiveAddWithMetadata(world, x, y, z, x, y, z, id, meta, 0, new HashMap<Coordinate, Integer>());
    }

    private void recursiveAddWithMetadata(IBlockAccess world, int x0, int y0, int z0, int x, int y, int z, Block id, int meta, int depth, HashMap<Coordinate, Integer> map) {
        if (this.overflow) {
            return;
        }
        if (depth > this.maxDepth) {
            return;
        }
        if (this.taxiCabDistance && Math.abs(x - x0) + Math.abs(y - y0) + Math.abs(z - z0) > this.maxDepth) {
            return;
        }
        if (world.func_147439_a(x, y, z) != id) {
            return;
        }
        if (world.func_72805_g(x, y, z) != meta) {
            return;
        }
        Coordinate c = new Coordinate(x, y, z);
        if (map.containsKey(c) && depth >= map.get(c)) {
            return;
        }
        this.addBlockCoordinate(x, y, z);
        map.put(c, depth);
        try {
            if (this.extraSpread) {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.recursiveAddWithMetadata(world, x0, y0, z0, x + i, y + j, z + k, id, meta, depth + 1, map);
                        }
                    }
                }
            } else {
                this.recursiveAddWithMetadata(world, x0, y0, z0, x + 1, y, z, id, meta, depth + 1, map);
                this.recursiveAddWithMetadata(world, x0, y0, z0, x - 1, y, z, id, meta, depth + 1, map);
                this.recursiveAddWithMetadata(world, x0, y0, z0, x, y + 1, z, id, meta, depth + 1, map);
                this.recursiveAddWithMetadata(world, x0, y0, z0, x, y - 1, z, id, meta, depth + 1, map);
                this.recursiveAddWithMetadata(world, x0, y0, z0, x, y, z + 1, id, meta, depth + 1, map);
                this.recursiveAddWithMetadata(world, x0, y0, z0, x, y, z - 1, id, meta, depth + 1, map);
            }
        }
        catch (StackOverflowError e) {
            this.throwOverflow(depth);
            e.printStackTrace();
        }
    }

    public void recursiveAddWithBounds(IBlockAccess world, int x, int y, int z, Block id, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.recursiveAddWithBounds(world, x, y, z, x, y, z, id, x1, y1, z1, x2, y2, z2, 0);
    }

    private void recursiveAddWithBounds(IBlockAccess world, int x0, int y0, int z0, int x, int y, int z, Block id, int x1, int y1, int z1, int x2, int y2, int z2, int depth) {
        if (this.overflow) {
            return;
        }
        if (depth > this.maxDepth) {
            return;
        }
        if (this.taxiCabDistance && Math.abs(x - x0) + Math.abs(y - y0) + Math.abs(z - z0) > this.maxDepth) {
            return;
        }
        if (x < x1 || y < y1 || z < z1 || x > x2 || y > y2 || z > z2) {
            return;
        }
        if (world.func_147439_a(x, y, z) != id) {
            return;
        }
        if (this.hasBlock(x, y, z)) {
            return;
        }
        this.addBlockCoordinate(x, y, z);
        try {
            if (this.extraSpread) {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.recursiveAddWithBounds(world, x0, y0, z0, x + i, y + j, z + k, id, x1, y1, z1, x2, y2, z2, depth + 1);
                        }
                    }
                }
            } else {
                this.recursiveAddWithBounds(world, x0, y0, z0, x + 1, y, z, id, x1, y1, z1, x2, y2, z2, depth + 1);
                this.recursiveAddWithBounds(world, x0, y0, z0, x - 1, y, z, id, x1, y1, z1, x2, y2, z2, depth + 1);
                this.recursiveAddWithBounds(world, x0, y0, z0, x, y + 1, z, id, x1, y1, z1, x2, y2, z2, depth + 1);
                this.recursiveAddWithBounds(world, x0, y0, z0, x, y - 1, z, id, x1, y1, z1, x2, y2, z2, depth + 1);
                this.recursiveAddWithBounds(world, x0, y0, z0, x, y, z + 1, id, x1, y1, z1, x2, y2, z2, depth + 1);
                this.recursiveAddWithBounds(world, x0, y0, z0, x, y, z - 1, id, x1, y1, z1, x2, y2, z2, depth + 1);
            }
        }
        catch (StackOverflowError e) {
            this.throwOverflow(depth);
            e.printStackTrace();
        }
    }

    public void recursiveAddWithBoundsNoFluidSource(IBlockAccess world, int x, int y, int z, Block id, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.recursiveAddWithBoundsNoFluidSource(world, x, y, z, x, y, z, id, x1, y1, z1, x2, y2, z2, 0);
    }

    private void recursiveAddWithBoundsNoFluidSource(IBlockAccess world, int x0, int y0, int z0, int x, int y, int z, Block id, int x1, int y1, int z1, int x2, int y2, int z2, int depth) {
        if (this.overflow) {
            return;
        }
        if (depth > this.maxDepth) {
            return;
        }
        if (this.taxiCabDistance && Math.abs(x - x0) + Math.abs(y - y0) + Math.abs(z - z0) > this.maxDepth) {
            return;
        }
        if (x < x1 || y < y1 || z < z1 || x > x2 || y > y2 || z > z2) {
            return;
        }
        if (world.func_147439_a(x, y, z) != id) {
            return;
        }
        if (world.func_72805_g(x, y, z) == 0) {
            return;
        }
        if (this.hasBlock(x, y, z)) {
            return;
        }
        this.addBlockCoordinate(x, y, z);
        try {
            if (this.extraSpread) {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.recursiveAddWithBoundsNoFluidSource(world, x0, y0, z0, x + i, y + j, z + k, id, x1, y1, z1, x2, y2, z2, depth + 1);
                        }
                    }
                }
            } else {
                this.recursiveAddWithBoundsNoFluidSource(world, x0, y0, z0, x + 1, y, z, id, x1, y1, z1, x2, y2, z2, depth + 1);
                this.recursiveAddWithBoundsNoFluidSource(world, x0, y0, z0, x - 1, y, z, id, x1, y1, z1, x2, y2, z2, depth + 1);
                this.recursiveAddWithBoundsNoFluidSource(world, x0, y0, z0, x, y + 1, z, id, x1, y1, z1, x2, y2, z2, depth + 1);
                this.recursiveAddWithBoundsNoFluidSource(world, x0, y0, z0, x, y - 1, z, id, x1, y1, z1, x2, y2, z2, depth + 1);
                this.recursiveAddWithBoundsNoFluidSource(world, x0, y0, z0, x, y, z + 1, id, x1, y1, z1, x2, y2, z2, depth + 1);
                this.recursiveAddWithBoundsNoFluidSource(world, x0, y0, z0, x, y, z - 1, id, x1, y1, z1, x2, y2, z2, depth + 1);
            }
        }
        catch (StackOverflowError e) {
            this.throwOverflow(depth);
            e.printStackTrace();
        }
    }

    public void recursiveAddWithBoundsRanged(IBlockAccess world, int x, int y, int z, Block id, int x1, int y1, int z1, int x2, int y2, int z2, int r) {
        this.recursiveAddWithBoundsRanged(world, x, y, z, x, y, z, id, x1, y1, z1, x2, y2, z2, r, 0);
    }

    private void recursiveAddWithBoundsRanged(IBlockAccess world, int x0, int y0, int z0, int x, int y, int z, Block id, int x1, int y1, int z1, int x2, int y2, int z2, int r, int depth) {
        if (this.overflow) {
            return;
        }
        if (depth > this.maxDepth) {
            return;
        }
        if (this.taxiCabDistance && Math.abs(x - x0) + Math.abs(y - y0) + Math.abs(z - z0) > this.maxDepth) {
            return;
        }
        if (x < x1 || y < y1 || z < z1 || x > x2 || y > y2 || z > z2) {
            return;
        }
        if (world.func_147439_a(x, y, z) != id) {
            return;
        }
        if (this.hasBlock(x, y, z)) {
            return;
        }
        this.addBlockCoordinate(x, y, z);
        try {
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    for (int k = -r; k <= r; ++k) {
                        this.recursiveAddWithBoundsRanged(world, x0, y0, z0, x + i, y + j, z + k, id, x1, y1, z1, x2, y2, z2, r, depth + 1);
                    }
                }
            }
        }
        catch (StackOverflowError e) {
            this.throwOverflow(depth);
            e.printStackTrace();
        }
    }

    public void recursiveAddMultipleWithBounds(IBlockAccess world, int x, int y, int z, Set<BlockKey> ids, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.recursiveAddMultipleWithBounds(world, x, y, z, x, y, z, ids, x1, y1, z1, x2, y2, z2, 0, new HashMap<Coordinate, Integer>());
    }

    private void recursiveAddMultipleWithBounds(IBlockAccess world, int x0, int y0, int z0, int x, int y, int z, Set<BlockKey> ids, int x1, int y1, int z1, int x2, int y2, int z2, int depth, HashMap<Coordinate, Integer> map) {
        Coordinate c;
        if (this.overflow) {
            return;
        }
        if (depth > this.maxDepth) {
            return;
        }
        if (this.taxiCabDistance && Math.abs(x - x0) + Math.abs(y - y0) + Math.abs(z - z0) > this.maxDepth) {
            return;
        }
        if (x < x1 || y < y1 || z < z1 || x > x2 || y > y2 || z > z2) {
            return;
        }
        boolean flag = false;
        BlockKey bk = BlockKey.getAt(world, x, y, z);
        if (ids.contains(bk)) {
            flag = true;
        }
        if (!flag) {
            return;
        }
        if (this.hasBlock(x, y, z)) {
            // empty if block
        }
        if (map.containsKey(c = new Coordinate(x, y, z)) && depth >= map.get(c)) {
            return;
        }
        this.addBlockCoordinate(x, y, z);
        map.put(c, depth);
        try {
            if (this.extraSpread) {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.recursiveAddMultipleWithBounds(world, x0, y0, z0, x + i, y + j, z + k, ids, x1, y1, z1, x2, y2, z2, depth + 1, map);
                        }
                    }
                }
            } else {
                this.recursiveAddMultipleWithBounds(world, x0, y0, z0, x + 1, y, z, ids, x1, y1, z1, x2, y2, z2, depth + 1, map);
                this.recursiveAddMultipleWithBounds(world, x0, y0, z0, x - 1, y, z, ids, x1, y1, z1, x2, y2, z2, depth + 1, map);
                this.recursiveAddMultipleWithBounds(world, x0, y0, z0, x, y + 1, z, ids, x1, y1, z1, x2, y2, z2, depth + 1, map);
                this.recursiveAddMultipleWithBounds(world, x0, y0, z0, x, y - 1, z, ids, x1, y1, z1, x2, y2, z2, depth + 1, map);
                this.recursiveAddMultipleWithBounds(world, x0, y0, z0, x, y, z + 1, ids, x1, y1, z1, x2, y2, z2, depth + 1, map);
                this.recursiveAddMultipleWithBounds(world, x0, y0, z0, x, y, z - 1, ids, x1, y1, z1, x2, y2, z2, depth + 1, map);
            }
        }
        catch (StackOverflowError e) {
            this.throwOverflow(depth);
            e.printStackTrace();
        }
    }

    public void recursiveMultiAddWithBounds(IBlockAccess world, int x, int y, int z, int x1, int y1, int z1, int x2, int y2, int z2, Block ... ids) {
        this.recursiveMultiAddWithBounds(world, x, y, z, x, y, z, x1, y1, z1, x2, y2, z2, 0, ids);
    }

    private void recursiveMultiAddWithBounds(IBlockAccess world, int x0, int y0, int z0, int x, int y, int z, int x1, int y1, int z1, int x2, int y2, int z2, int depth, Block ... ids) {
        int i;
        if (this.overflow) {
            return;
        }
        if (depth > this.maxDepth) {
            return;
        }
        if (this.taxiCabDistance && Math.abs(x - x0) + Math.abs(y - y0) + Math.abs(z - z0) > this.maxDepth) {
            return;
        }
        if (x < x1 || y < y1 || z < z1 || x > x2 || y > y2 || z > z2) {
            return;
        }
        boolean flag = false;
        for (i = 0; i < ids.length; ++i) {
            if (world.func_147439_a(x, y, z) != ids[i]) continue;
            flag = true;
        }
        if (!flag) {
            return;
        }
        if (this.hasBlock(x, y, z)) {
            return;
        }
        this.addBlockCoordinate(x, y, z);
        try {
            if (this.extraSpread) {
                for (i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.recursiveMultiAddWithBounds(world, x0, y0, z0, x + i, y + j, z + k, x1, y1, z1, x2, y2, z2, depth + 1, ids);
                        }
                    }
                }
            } else {
                this.recursiveMultiAddWithBounds(world, x0, y0, z0, x + 1, y, z, x1, y1, z1, x2, y2, z2, depth + 1, ids);
                this.recursiveMultiAddWithBounds(world, x0, y0, z0, x - 1, y, z, x1, y1, z1, x2, y2, z2, depth + 1, ids);
                this.recursiveMultiAddWithBounds(world, x0, y0, z0, x, y + 1, z, x1, y1, z1, x2, y2, z2, depth + 1, ids);
                this.recursiveMultiAddWithBounds(world, x0, y0, z0, x, y - 1, z, x1, y1, z1, x2, y2, z2, depth + 1, ids);
                this.recursiveMultiAddWithBounds(world, x0, y0, z0, x, y, z + 1, x1, y1, z1, x2, y2, z2, depth + 1, ids);
                this.recursiveMultiAddWithBounds(world, x0, y0, z0, x, y, z - 1, x1, y1, z1, x2, y2, z2, depth + 1, ids);
            }
        }
        catch (StackOverflowError e) {
            this.throwOverflow(depth);
            e.printStackTrace();
        }
    }

    public void recursiveAddWithBoundsMetadata(IBlockAccess world, int x, int y, int z, Block id, int meta, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.recursiveAddWithBoundsMetadata(world, x, y, z, x, y, z, id, meta, x1, y1, z1, x2, y2, z2, 0, new HashMap<Coordinate, Integer>());
    }

    private void recursiveAddWithBoundsMetadata(IBlockAccess world, int x0, int y0, int z0, int x, int y, int z, Block id, int meta, int x1, int y1, int z1, int x2, int y2, int z2, int depth, HashMap<Coordinate, Integer> map) {
        Coordinate c;
        if (this.overflow) {
            return;
        }
        if (depth > this.maxDepth) {
            return;
        }
        if (this.taxiCabDistance && Math.abs(x - x0) + Math.abs(y - y0) + Math.abs(z - z0) > this.maxDepth) {
            return;
        }
        if (x < x1 || y < y1 || z < z1 || x > x2 || y > y2 || z > z2) {
            return;
        }
        if (this.clampToChunkLoad && world instanceof World && !((World)world).func_72904_c(x, y, z, x, y, z)) {
            return;
        }
        if (world.func_147439_a(x, y, z) != id || world.func_72805_g(x, y, z) != meta) {
            return;
        }
        if (this.hasBlock(x, y, z)) {
            // empty if block
        }
        if (map.containsKey(c = new Coordinate(x, y, z)) && depth >= map.get(c)) {
            return;
        }
        this.addBlockCoordinate(x, y, z);
        map.put(c, depth);
        try {
            if (this.extraSpread) {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.recursiveAddWithBoundsMetadata(world, x0, y0, z0, x + i, y + j, z + k, id, meta, x1, y1, z1, x2, y2, z2, depth + 1, map);
                        }
                    }
                }
            } else {
                this.recursiveAddWithBoundsMetadata(world, x0, y0, z0, x + 1, y, z, id, meta, x1, y1, z1, x2, y2, z2, depth + 1, map);
                this.recursiveAddWithBoundsMetadata(world, x0, y0, z0, x - 1, y, z, id, meta, x1, y1, z1, x2, y2, z2, depth + 1, map);
                this.recursiveAddWithBoundsMetadata(world, x0, y0, z0, x, y + 1, z, id, meta, x1, y1, z1, x2, y2, z2, depth + 1, map);
                this.recursiveAddWithBoundsMetadata(world, x0, y0, z0, x, y - 1, z, id, meta, x1, y1, z1, x2, y2, z2, depth + 1, map);
                this.recursiveAddWithBoundsMetadata(world, x0, y0, z0, x, y, z + 1, id, meta, x1, y1, z1, x2, y2, z2, depth + 1, map);
                this.recursiveAddWithBoundsMetadata(world, x0, y0, z0, x, y, z - 1, id, meta, x1, y1, z1, x2, y2, z2, depth + 1, map);
            }
        }
        catch (StackOverflowError e) {
            this.throwOverflow(depth);
            e.printStackTrace();
        }
    }

    public void recursiveAddCallbackWithBounds(World world, int x, int y, int z, int x1, int y1, int z1, int x2, int y2, int z2, AbstractSearch.PropagationCondition f) {
        this.recursiveAddCallbackWithBounds(world, x, y, z, x, y, z, x1, y1, z1, x2, y2, z2, f, 0, new HashMap<Coordinate, Integer>());
    }

    private void recursiveAddCallbackWithBounds(World world, int x0, int y0, int z0, int x, int y, int z, int x1, int y1, int z1, int x2, int y2, int z2, AbstractSearch.PropagationCondition f, int depth, HashMap<Coordinate, Integer> map) {
        Coordinate c;
        if (this.overflow) {
            return;
        }
        if (depth > this.maxDepth) {
            return;
        }
        if (this.taxiCabDistance && Math.abs(x - x0) + Math.abs(y - y0) + Math.abs(z - z0) > this.maxDepth) {
            return;
        }
        if (x < x1 || y < y1 || z < z1 || x > x2 || y > y2 || z > z2) {
            return;
        }
        if (!f.isValidLocation(world, x, y, z, new Coordinate(x0, y0, z0))) {
            return;
        }
        if (this.hasBlock(x, y, z)) {
            // empty if block
        }
        if (map.containsKey(c = new Coordinate(x, y, z)) && depth >= map.get(c)) {
            return;
        }
        this.addBlockCoordinate(x, y, z);
        map.put(c, depth);
        try {
            if (this.extraSpread) {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.recursiveAddCallbackWithBounds(world, x0, y0, z0, x + i, y + j, z + k, x1, y1, z1, x2, y2, z2, f, depth + 1, map);
                        }
                    }
                }
            } else {
                this.recursiveAddCallbackWithBounds(world, x0, y0, z0, x + 1, y, z, x1, y1, z1, x2, y2, z2, f, depth + 1, map);
                this.recursiveAddCallbackWithBounds(world, x0, y0, z0, x - 1, y, z, x1, y1, z1, x2, y2, z2, f, depth + 1, map);
                this.recursiveAddCallbackWithBounds(world, x0, y0, z0, x, y + 1, z, x1, y1, z1, x2, y2, z2, f, depth + 1, map);
                this.recursiveAddCallbackWithBounds(world, x0, y0, z0, x, y - 1, z, x1, y1, z1, x2, y2, z2, f, depth + 1, map);
                this.recursiveAddCallbackWithBounds(world, x0, y0, z0, x, y, z + 1, x1, y1, z1, x2, y2, z2, f, depth + 1, map);
                this.recursiveAddCallbackWithBounds(world, x0, y0, z0, x, y, z - 1, x1, y1, z1, x2, y2, z2, f, depth + 1, map);
            }
        }
        catch (StackOverflowError e) {
            this.throwOverflow(depth);
            e.printStackTrace();
        }
    }

    public void iterativeAddCallbackWithBounds(World world, int x0, int y0, int z0, int x1, int y1, int z1, int x2, int y2, int z2, AbstractSearch.PropagationCondition f) {
        Coordinate root = new Coordinate(x0, y0, z0);
        if (!f.isValidLocation(world, x0, y0, z0, root)) {
            return;
        }
        HashSet<Coordinate> next = new HashSet<Coordinate>();
        next.add(root);
        while (!next.isEmpty()) {
            HashSet<Coordinate> toNext = new HashSet<Coordinate>();
            for (Coordinate c : next) {
                if (c.xCoord < x1 || c.yCoord < y1 || c.zCoord < z1 || c.xCoord > x2 || c.yCoord > y2 || c.zCoord > z2) continue;
                this.addBlockCoordinate(c.xCoord, c.yCoord, c.zCoord);
                if (this.extraSpread) {
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                Coordinate c2 = c.offset(i, j, k);
                                if (this.keys.contains(c2) || !f.isValidLocation(world, c2.xCoord, c2.yCoord, c2.zCoord, c)) continue;
                                toNext.add(c2);
                            }
                        }
                    }
                    continue;
                }
                for (Coordinate c2 : c.getAdjacentCoordinates()) {
                    if (this.keys.contains(c2) || !f.isValidLocation(world, c2.xCoord, c2.yCoord, c2.zCoord, c)) continue;
                    toNext.add(c2);
                }
            }
            next = toNext;
        }
    }

    public void recursiveAddLiquidWithBounds(IBlockAccess world, int x, int y, int z, int x1, int y1, int z1, int x2, int y2, int z2, Fluid liquid) {
        this.recursiveAddLiquidWithBounds(world, x, y, z, x, y, z, x1, y1, z1, x2, y2, z2, 0, liquid);
    }

    private void recursiveAddLiquidWithBounds(IBlockAccess world, int x0, int y0, int z0, int x, int y, int z, int x1, int y1, int z1, int x2, int y2, int z2, int depth, Fluid liquid) {
        if (this.overflow) {
            return;
        }
        if (depth > this.maxDepth) {
            return;
        }
        if (this.taxiCabDistance && Math.abs(x - x0) + Math.abs(y - y0) + Math.abs(z - z0) > this.maxDepth) {
            return;
        }
        if (x < x1 || y < y1 || z < z1 || x > x2 || y > y2 || z > z2) {
            return;
        }
        Fluid f2 = ReikaWorldHelper.getFluid(world, x, y, z);
        if (f2 == null) {
            return;
        }
        if (liquid != null && f2 != liquid) {
            return;
        }
        if (this.hasBlock(x, y, z)) {
            return;
        }
        this.addBlockCoordinate(x, y, z);
        try {
            if (this.extraSpread) {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.recursiveAddLiquidWithBounds(world, x0, y0, z0, x + i, y + j, z + k, x1, y1, z1, x2, y2, z2, depth + 1, liquid);
                        }
                    }
                }
            } else {
                this.recursiveAddLiquidWithBounds(world, x0, y0, z0, x + 1, y, z, x1, y1, z1, x2, y2, z2, depth + 1, liquid);
                this.recursiveAddLiquidWithBounds(world, x0, y0, z0, x - 1, y, z, x1, y1, z1, x2, y2, z2, depth + 1, liquid);
                this.recursiveAddLiquidWithBounds(world, x0, y0, z0, x, y + 1, z, x1, y1, z1, x2, y2, z2, depth + 1, liquid);
                this.recursiveAddLiquidWithBounds(world, x0, y0, z0, x, y - 1, z, x1, y1, z1, x2, y2, z2, depth + 1, liquid);
                this.recursiveAddLiquidWithBounds(world, x0, y0, z0, x, y, z + 1, x1, y1, z1, x2, y2, z2, depth + 1, liquid);
                this.recursiveAddLiquidWithBounds(world, x0, y0, z0, x, y, z - 1, x1, y1, z1, x2, y2, z2, depth + 1, liquid);
            }
        }
        catch (StackOverflowError e) {
            this.throwOverflow(depth);
            e.printStackTrace();
        }
    }

    private void recursiveAddWithinSphere(IBlockAccess world, int x0, int y0, int z0, int x, int y, int z, Block id, int dx, int dy, int dz, double r, int depth) {
        if (this.overflow) {
            return;
        }
        if (depth > this.maxDepth) {
            return;
        }
        if (this.taxiCabDistance && Math.abs(x - x0) + Math.abs(y - y0) + Math.abs(z - z0) > this.maxDepth) {
            return;
        }
        if (world.func_147439_a(x, y, z) != id) {
            return;
        }
        if (this.hasBlock(x, y, z)) {
            return;
        }
        if (ReikaMathLibrary.py3d(x - x0, y - y0, z - z0) > r) {
            return;
        }
        this.addBlockCoordinate(x, y, z);
        try {
            if (this.extraSpread) {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.recursiveAddWithinSphere(world, x0, y0, z0, x + i, y + j, z + k, id, x0, y0, z0, r, depth + 1);
                        }
                    }
                }
            } else {
                this.recursiveAddWithinSphere(world, x0, y0, z0, x + 1, y, z, id, dx, dy, dz, r, depth + 1);
                this.recursiveAddWithinSphere(world, x0, y0, z0, x - 1, y, z, id, dx, dy, dz, r, depth + 1);
                this.recursiveAddWithinSphere(world, x0, y0, z0, x, y + 1, z, id, dx, dy, dz, r, depth + 1);
                this.recursiveAddWithinSphere(world, x0, y0, z0, x, y - 1, z, id, dx, dy, dz, r, depth + 1);
                this.recursiveAddWithinSphere(world, x0, y0, z0, x, y, z + 1, id, dx, dy, dz, r, depth + 1);
                this.recursiveAddWithinSphere(world, x0, y0, z0, x, y, z - 1, id, dx, dy, dz, r, depth + 1);
            }
        }
        catch (StackOverflowError e) {
            this.throwOverflow(depth);
            e.printStackTrace();
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty[]";
        }
        StringBuilder list = new StringBuilder();
        list.append(this.getSize() + ": ");
        for (int i = 0; i < this.getSize(); ++i) {
            Coordinate c = this.getNthBlock(i);
            if (this.refWorld != null) {
                Block id = c.getBlock((IBlockAccess)this.refWorld);
                int meta = c.getBlockMetadata((IBlockAccess)this.refWorld);
                list.append(id + ":" + meta + " @ ");
            }
            list.append(c.toString());
            if (i == this.getSize() - 1) continue;
            list.append(";");
        }
        return list.toString();
    }

    public void addLineOfClear(World world, int x, int y, int z, int range, int stepx, int stepy, int stepz) {
        block20: {
            block21: {
                block19: {
                    if (stepx == 0 && stepy == 0 && stepz == 0) {
                        throw new MisuseException("The addLineOfClear() method requires a specified direction!");
                    }
                    if (stepx == 0) break block19;
                    if (stepy != 0 || stepz != 0) {
                        throw new MisuseException("The addLineOfClear() method is only designed for 1D lines!");
                    }
                    if (stepx != -1 && stepx != 1) {
                        throw new MisuseException("The addLineOfClear() method is only designed for solid lines!");
                    }
                    if (stepx == 1) {
                        for (int i = x + 1; i <= x + range; ++i) {
                            if (this.addIfClear(world, i, y, z)) continue;
                            return;
                        }
                    } else {
                        for (int i = x - 1; i >= x - range; --i) {
                            if (this.addIfClear(world, i, y, z)) continue;
                            return;
                        }
                    }
                    break block20;
                }
                if (stepy == 0) break block21;
                if (stepx != 0 || stepz != 0) {
                    throw new MisuseException("The addLineOfClear() method is only designed for 1D lines!");
                }
                if (stepy != -1 && stepy != 1) {
                    throw new MisuseException("The addLineOfClear() method is only designed for solid lines!");
                }
                if (stepy == 1) {
                    for (int i = y + 1; i <= y + range; ++i) {
                        if (this.addIfClear(world, x, i, z)) continue;
                        return;
                    }
                } else {
                    for (int i = y - 1; i >= y - range; --i) {
                        if (this.addIfClear(world, x, i, z)) continue;
                        return;
                    }
                }
                break block20;
            }
            if (stepz == 0) break block20;
            if (stepy != 0 || stepx != 0) {
                throw new MisuseException("The addLineOfClear() method is only designed for 1D lines!");
            }
            if (stepz != -1 && stepz != 1) {
                throw new MisuseException("The addLineOfClear() method is only designed for solid lines!");
            }
            if (stepz == 1) {
                for (int i = z + 1; i <= z + range; ++i) {
                    if (this.addIfClear(world, x, y, i)) continue;
                    return;
                }
            } else {
                for (int i = z - 1; i >= z - range; --i) {
                    if (this.addIfClear(world, x, y, i)) continue;
                    return;
                }
            }
        }
    }

    public boolean addIfClear(World world, int x, int y, int z) {
        int meta;
        SemiTransparent b;
        Block id = world.func_147439_a(x, y, z);
        if (id == Blocks.field_150350_a) {
            this.addBlockCoordinate(x, y, z);
            return true;
        }
        if (!id.func_149678_a(world.func_72805_g(x, y, z), false) && !BlockLiquid.class.isAssignableFrom(id.getClass())) {
            this.addBlockCoordinate(x, y, z);
            return true;
        }
        if (id instanceof SemiTransparent && (b = (SemiTransparent)id).isOpaque(meta = world.func_72805_g(x, y, z))) {
            return false;
        }
        return !id.func_149662_c();
    }

    public void addSphere(World world, int x, int y, int z, Block id, double r) {
        if (r == 0.0) {
            return;
        }
        try {
            this.recursiveAddWithinSphere((IBlockAccess)world, x, y, z, x + 1, y, z, id, x, y, z, r, 0);
            this.recursiveAddWithinSphere((IBlockAccess)world, x, y, z, x, y + 1, z, id, x, y, z, r, 0);
            this.recursiveAddWithinSphere((IBlockAccess)world, x, y, z, x, y, z + 1, id, x, y, z, r, 0);
            this.recursiveAddWithinSphere((IBlockAccess)world, x, y, z, x - 1, y, z, id, x, y, z, r, 0);
            this.recursiveAddWithinSphere((IBlockAccess)world, x, y, z, x, y - 1, z, id, x, y, z, r, 0);
            this.recursiveAddWithinSphere((IBlockAccess)world, x, y, z, x, y, z - 1, id, x, y, z, r, 0);
        }
        catch (StackOverflowError e) {
            this.throwOverflow(0);
            e.printStackTrace();
        }
    }

    protected void throwOverflow(int depth) {
        this.overflow = true;
        DragonAPICore.logError("Stack overflow at depth " + depth + "/" + this.maxDepth + "!");
    }

    public Coordinate getRandomBlock() {
        return this.isEmpty() ? null : this.getNthBlock(rand.nextInt(this.getSize()));
    }

    private void remove(int index) {
        Coordinate c = this.blocks.remove(index);
        this.keys.remove(c);
    }

    public boolean isOverflowing() {
        return this.overflow;
    }

    public boolean hasWorldReference() {
        return this.refWorld != null;
    }

    public final BlockArray offset(ForgeDirection dir, int dist) {
        return this.offset(dir.offsetX * dist, dir.offsetY * dist, dir.offsetZ * dist);
    }

    public BlockArray offset(int x, int y, int z) {
        ArrayList<Coordinate> temp = new ArrayList<Coordinate>(this.blocks);
        this.keys.clear();
        this.blocks.clear();
        for (Coordinate c : temp) {
            Coordinate c2 = c.offset(x, y, z);
            this.blocks.add(c2);
            this.keys.add(c2);
        }
        this.resetLimits();
        return this;
    }

    public final int sink(World world) {
        boolean canSink = true;
        int n = 0;
        while (canSink) {
            for (int i = 0; i < this.blocks.size(); ++i) {
                Coordinate c = this.getNthBlock(i);
                int x = c.xCoord;
                int y = c.yCoord;
                int z = c.zCoord;
                if (ReikaWorldHelper.softBlocks((IBlockAccess)world, x, y - 1, z)) continue;
                canSink = false;
            }
            if (!canSink) continue;
            this.offset(0, -1, 0);
            ++n;
        }
        return n;
    }

    public final int sink(World world, Blocks ... overrides) {
        boolean canSink = true;
        int n = 0;
        while (canSink) {
            for (int i = 0; i < this.blocks.size(); ++i) {
                Coordinate c = this.getNthBlock(i);
                int x = c.xCoord;
                int y = c.yCoord;
                int z = c.zCoord;
                Block idy = world.func_147439_a(x, y - 1, z);
                if (ReikaWorldHelper.softBlocks((IBlockAccess)world, x, y - 1, z) || ReikaArrayHelper.contains(overrides, idy)) continue;
                canSink = false;
            }
            if (!canSink) continue;
            this.offset(0, -1, 0);
            ++n;
        }
        return n;
    }

    public final int sink(World world, Material ... overrides) {
        boolean canSink = true;
        int n = 0;
        while (canSink) {
            for (int i = 0; i < this.blocks.size(); ++i) {
                Coordinate c = this.getNthBlock(i);
                int x = c.xCoord;
                int y = c.yCoord;
                int z = c.zCoord;
                if (this.minY <= 0 || y <= 0) {
                    canSink = false;
                    break;
                }
                Material idy = ReikaWorldHelper.getMaterial((IBlockAccess)world, x, y - 1, z);
                if (ReikaWorldHelper.softBlocks((IBlockAccess)world, x, y - 1, z) || ReikaArrayHelper.contains(overrides, idy) || !idy.func_76220_a()) continue;
                canSink = false;
                break;
            }
            if (!canSink) continue;
            this.offset(0, -1, 0);
            ++n;
        }
        return n;
    }

    public final ArrayList<ItemStack> getAllDroppedItems(World world, int fortune, EntityPlayer ep) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        ArrayList<ItemStack> nbt = new ArrayList<ItemStack>();
        ItemHashMap<Integer> map = new ItemHashMap().enableNBT();
        for (int i = 0; i < this.blocks.size(); ++i) {
            Coordinate c = this.getNthBlock(i);
            int x = c.xCoord;
            int y = c.yCoord;
            int z = c.zCoord;
            Block b = world.func_147439_a(x, y, z);
            if (b == null || b == Blocks.field_150350_a) continue;
            int metadata = world.func_72805_g(x, y, z);
            ArrayList drop = b.getDrops(world, x, y, z, metadata, fortune);
            BlockEvent.HarvestDropsEvent evt = new BlockEvent.HarvestDropsEvent(x, y, z, world, b, metadata, fortune, 1.0f, drop, ep, false);
            MinecraftForge.EVENT_BUS.post((Event)evt);
            drop = evt.drops;
            for (ItemStack is : drop) {
                if (is.field_77990_d != null) {
                    nbt.add(is);
                    continue;
                }
                if (map.containsKey(is)) {
                    int cur = (Integer)map.get(is);
                    map.put(is, Integer.valueOf(cur += is.field_77994_a));
                    continue;
                }
                map.put(is, Integer.valueOf(is.field_77994_a));
            }
        }
        for (ItemStack is : map.keySet()) {
            int max;
            int count = (Integer)map.get(is);
            if (count > (max = is.func_77976_d())) {
                while (count > 0) {
                    int add = Math.min(count, max);
                    li.add(ReikaItemHelper.getSizedItemStack(is, add));
                    count -= add;
                }
                continue;
            }
            li.add(ReikaItemHelper.getSizedItemStack(is, count));
        }
        li.addAll(nbt);
        return li;
    }

    public final BlockArray copy() {
        BlockArray copy = this.instantiate();
        this.copyTo(copy);
        return copy;
    }

    protected BlockArray instantiate() {
        return new BlockArray();
    }

    public void copyTo(BlockArray copy) {
        copy.refWorld = this.refWorld;
        copy.overflow = this.overflow;
        copy.blocks.clear();
        copy.blocks.addAll(this.blocks);
        copy.keys.clear();
        copy.keys.addAll(this.keys);
        copy.recalcLimits();
    }

    public void addAll(BlockArray arr) {
        for (Coordinate c : arr.blocks) {
            if (this.keys.contains(c)) continue;
            this.addBlockCoordinate(c.xCoord, c.yCoord, c.zCoord);
        }
    }

    public void addAll(BlockBox box) {
        for (int x = box.minX; x <= box.maxX; ++x) {
            for (int z = box.minZ; z <= box.maxZ; ++z) {
                for (int y = box.minY; y <= box.maxY; ++y) {
                    this.addBlockCoordinate(x, y, z);
                }
            }
        }
    }

    public final boolean isAtLeastXPercentNot(World world, double percent, Block id, int meta) {
        double s = this.getSize();
        int ct = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            Coordinate c = this.getNthBlock(i);
            int x = c.xCoord;
            int y = c.yCoord;
            int z = c.zCoord;
            Block id2 = world.func_147439_a(x, y, z);
            int meta2 = world.func_72805_g(x, y, z);
            if (id2 == id && meta2 == meta) continue;
            ++ct;
        }
        return (double)ct / s * 100.0 >= percent;
    }

    public final boolean isAtLeastXPercent(World world, double percent, Block id) {
        return this.isAtLeastXPercent(world, percent, id, -1);
    }

    public final boolean isAtLeastXPercent(World world, double percent, Block id, int meta) {
        double s = this.getSize();
        int ct = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            Coordinate c = this.getNthBlock(i);
            int x = c.xCoord;
            int y = c.yCoord;
            int z = c.zCoord;
            Block id2 = world.func_147439_a(x, y, z);
            int meta2 = world.func_72805_g(x, y, z);
            if (id2 != id || meta != -1 && meta2 != meta) continue;
            ++ct;
        }
        return (double)ct / s * 100.0 >= percent;
    }

    public final boolean isAtLeastXPercentSolid(World world, double percent) {
        return this.isAtLeastXPercentNot(world, percent, Blocks.field_150350_a, 0);
    }

    public void setTo(Block b) {
        this.setTo(b, 0);
    }

    public void setTo(Block b, int meta) {
        if (this.refWorld != null) {
            for (int i = 0; i < this.getSize(); ++i) {
                Coordinate c = this.getNthBlock(i);
                c.setBlock(this.refWorld, b, meta);
            }
        } else {
            throw new MisuseException("Cannot apply operations to a null world!");
        }
    }

    public void clearArea() {
        this.setTo(Blocks.field_150350_a);
    }

    public void writeToNBT(String label, NBTTagCompound NBT) {
        NBTTagList li = new NBTTagList();
        for (int i = 0; i < this.getSize(); ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            Coordinate c = this.getNthBlock(i);
            tag.func_74768_a("x", c.xCoord);
            tag.func_74768_a("y", c.yCoord);
            tag.func_74768_a("z", c.zCoord);
            li.func_74742_a((NBTBase)tag);
        }
        NBT.func_74782_a(label, (NBTBase)li);
        NBTTagCompound limit = new NBTTagCompound();
        limit.func_74768_a("minx", this.minX);
        limit.func_74768_a("miny", this.minY);
        limit.func_74768_a("minz", this.minZ);
        limit.func_74768_a("maxx", this.maxX);
        limit.func_74768_a("maxy", this.maxY);
        limit.func_74768_a("maxz", this.maxZ);
        NBT.func_74782_a(label + "_lim", (NBTBase)limit);
    }

    public void readFromNBT(String label, NBTTagCompound NBT) {
        this.clear();
        NBTTagList tag = NBT.func_150295_c(label, ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        if (tag == null || tag.func_74745_c() == 0) {
            return;
        }
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            NBTTagCompound coord = tag.func_150305_b(i);
            int x = coord.func_74762_e("x");
            int y = coord.func_74762_e("y");
            int z = coord.func_74762_e("z");
            this.addBlockCoordinate(x, y, z);
        }
        NBTTagCompound limit = NBT.func_74775_l(label + "_lim");
        this.minX = limit.func_74762_e("minx");
        this.minY = limit.func_74762_e("miny");
        this.minZ = limit.func_74762_e("minz");
        this.maxX = limit.func_74762_e("maxx");
        this.maxY = limit.func_74762_e("maxy");
        this.maxZ = limit.func_74762_e("maxz");
    }

    public void shaveToCube() {
        int s1;
        if (this.isEmpty()) {
            return;
        }
        boolean changed = false;
        do {
            s1 = this.getSize();
            HashSet<Coordinate> set = new HashSet<Coordinate>(this.blocks);
            for (Coordinate c : set) {
                int n = this.countNeighbors(c);
                if (n >= 11) continue;
                this.removeKey(c);
            }
        } while (changed = this.getSize() != s1);
        this.resetLimits();
    }

    private int countNeighbors(Coordinate c) {
        int n = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (!this.keys.contains(c.offset(i, j, k))) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public void XORWith(BlockArray b) {
        HashSet<Coordinate> set = new HashSet<Coordinate>();
        set.addAll(this.blocks);
        set.addAll(b.blocks);
        this.clear();
        for (Coordinate c : set) {
            if (!(this.keys.contains(c) ^ b.keys.contains(c))) continue;
            this.addKey(c);
        }
    }

    public static BlockArray getXORBox(BlockArray b1, BlockArray b2) {
        BlockArray b = b1.instantiate();
        HashSet<Coordinate> set = new HashSet<Coordinate>();
        set.addAll(b1.blocks);
        set.addAll(b2.blocks);
        for (Coordinate c : set) {
            if (!(b2.keys.contains(c) ^ b1.keys.contains(c))) continue;
            b.addKey(c);
        }
        return b;
    }

    public void intersectWith(BlockArray b) {
        Iterator<Coordinate> it = this.blocks.iterator();
        while (it.hasNext()) {
            Coordinate c = it.next();
            if (b.keys.contains(c)) continue;
            it.remove();
            this.keys.remove(c);
        }
        this.resetLimits();
    }

    public static BlockArray getIntersectedBox(BlockArray b1, BlockArray b2) {
        BlockArray b = b1.instantiate();
        for (Coordinate c : b1.blocks) {
            if (!b2.keys.contains(c)) continue;
            b.addKey(c);
        }
        return b;
    }

    public void unifyWith(BlockArray b) {
        for (Coordinate c : b.blocks) {
            this.addKey(c);
        }
        this.resetLimits();
    }

    public static BlockArray getUnifiedBox(BlockArray b1, BlockArray b2) {
        BlockArray b = b1.instantiate();
        for (Coordinate c : b1.blocks) {
            b.addKey(c);
        }
        for (Coordinate c : b2.blocks) {
            b.addKey(c);
        }
        return b;
    }

    public final AxisAlignedBB asAABB() {
        return AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)(this.maxX + 1), (double)(this.maxY + 1), (double)(this.maxZ + 1));
    }

    public final BlockBox asBlockBox() {
        return new BlockBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public void reverseBlockOrder() {
        Collections.reverse(this.blocks);
    }

    public void sortBlocksByHeight(boolean reverse) {
        this.sort(reverse ? heightComparator2 : heightComparator);
    }

    public void sortBlocksByDistance(Coordinate loc) {
        this.sort(new InwardsComparator(loc));
    }

    public void sort(Comparator<Coordinate> comparator) {
        Collections.sort(this.blocks, comparator);
    }

    public BlockArray rotate90Degrees(int ox, int oz, boolean left) {
        BlockArray b = this.instantiate();
        for (Coordinate c : this.blocks) {
            Coordinate c2 = c.rotate90About(ox, oz, left);
            b.addBlockCoordinate(c2.xCoord, c2.yCoord, c2.zCoord);
        }
        return b;
    }

    public BlockArray rotate180Degrees(int ox, int oz) {
        BlockArray b = this.instantiate();
        for (Coordinate c : this.blocks) {
            Coordinate c2 = c.rotate180About(ox, oz);
            b.addBlockCoordinate(c2.xCoord, c2.yCoord, c2.zCoord);
        }
        return b;
    }

    public BlockArray flipX() {
        BlockArray b = this.instantiate();
        for (Coordinate c : this.blocks) {
            Coordinate c2 = new Coordinate(-c.xCoord, c.yCoord, c.zCoord);
            b.addBlockCoordinate(c2.xCoord, c2.yCoord, c2.zCoord);
        }
        return b;
    }

    public BlockArray flipZ() {
        BlockArray b = this.instantiate();
        for (Coordinate c : this.blocks) {
            Coordinate c2 = new Coordinate(c.xCoord, c.yCoord, -c.zCoord);
            b.addBlockCoordinate(c2.xCoord, c2.yCoord, c2.zCoord);
        }
        return b;
    }

    public static BlockArray fromBounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        BlockArray b = new BlockArray();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    b.addBlockCoordinate(x, y, z);
                }
            }
        }
        return b;
    }

    public void expand(int amt, boolean rounded) {
        HashSet<Coordinate> set = new HashSet<Coordinate>();
        for (Coordinate c : this.blocks) {
            int i;
            if (rounded) {
                for (i = -amt; i <= amt; ++i) {
                    for (int j = -amt; j <= amt; ++j) {
                        for (int k = -amt; k <= amt; ++k) {
                            Coordinate c2 = c.offset(i, j, k);
                            if (this.keys.contains(c2)) continue;
                            set.add(c2);
                        }
                    }
                }
                continue;
            }
            for (i = 0; i < 6; ++i) {
                for (int k = 1; k <= amt; ++k) {
                    Coordinate c2 = c.offset(ForgeDirection.VALID_DIRECTIONS[i], k);
                    if (this.keys.contains(c2)) continue;
                    set.add(c2);
                }
            }
        }
        for (Coordinate c : set) {
            this.addKey(c);
        }
    }

    public Collection<BlockArray> splitToRectangles() {
        ArrayList<BlockArray> li = new ArrayList<BlockArray>();
        HashSet<Coordinate> locs = new HashSet<Coordinate>(this.keys);
        while (!locs.isEmpty()) {
            ArrayList<Coordinate> locList = new ArrayList<Coordinate>(locs);
            int idx = rand.nextInt(locs.size());
            Coordinate c = locList.remove(idx);
            locs.remove(c);
            ArrayList<Coordinate> block = new ArrayList<Coordinate>();
            block.add(c);
            ArrayList<ForgeDirection> dirs = ReikaDirectionHelper.getRandomOrderedDirections(true);
            while (!dirs.isEmpty()) {
                ForgeDirection dir = dirs.remove(0);
                int d = 1;
                boolean flag = true;
                while (flag) {
                    ArrayList<Coordinate> add = new ArrayList<Coordinate>();
                    for (Coordinate in : block) {
                        Coordinate offset = in.offset(dir, d);
                        if (block.contains(offset)) continue;
                        if (!locs.contains(offset)) {
                            flag = false;
                            break;
                        }
                        add.add(offset);
                    }
                    if (!flag) continue;
                    for (Coordinate in : add) {
                        block.add(in);
                        locs.remove(in);
                    }
                }
            }
            li.add(new BlockArray(block));
        }
        return li;
    }

    @Override
    public Iterator<Coordinate> iterator() {
        return new BlockArrayIterator();
    }

    private final class BlockArrayIterator
    implements Iterator<Coordinate> {
        private int index;

        private BlockArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return BlockArray.this.blocks.size() > this.index + 1;
        }

        @Override
        public Coordinate next() {
            Coordinate c = (Coordinate)BlockArray.this.blocks.get(this.index);
            ++this.index;
            return c;
        }

        @Override
        public void remove() {
            BlockArray.this.remove(this.index);
        }
    }

    public static abstract class BlockTypePrioritizer
    implements Comparator<Coordinate> {
        private final World world;

        protected BlockTypePrioritizer(World world) {
            this.world = world;
        }

        @Override
        public final int compare(Coordinate c1, Coordinate c2) {
            BlockKey b1 = c1.getBlockKey((IBlockAccess)this.world);
            BlockKey b2 = c2.getBlockKey((IBlockAccess)this.world);
            return this.compare(b1, b2);
        }

        @Override
        protected abstract int compare(BlockKey var1, BlockKey var2);
    }

    private class InwardsComparator
    implements Comparator<Coordinate> {
        private final Coordinate location;

        private InwardsComparator(Coordinate c) {
            this.location = c;
        }

        @Override
        public int compare(Coordinate o1, Coordinate o2) {
            return (int)Math.signum(o2.getDistanceTo(this.location) - o1.getDistanceTo(this.location));
        }
    }

    private static class HeightComparator
    implements Comparator<Coordinate> {
        private final boolean reverse;

        private HeightComparator(boolean rev) {
            this.reverse = rev;
        }

        @Override
        public int compare(Coordinate o1, Coordinate o2) {
            return this.reverse ? o2.yCoord - o1.yCoord : o1.yCoord - o2.yCoord;
        }
    }
}

