/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.AbstractSearch;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class DepthFirstSearch
extends AbstractSearch {
    private final LinkedList<Coordinate> currentPath = new LinkedList();
    private Comparator stepValue;
    private boolean isDone;

    public DepthFirstSearch(int x, int y, int z, AbstractSearch.PropagationCondition p, AbstractSearch.TerminationCondition t) {
        super(x, y, z, p, t);
        this.currentPath.add(this.root);
    }

    @Override
    public boolean tick(World world) {
        if (this.isDone) {
            return true;
        }
        if (this.stepValue == null && this.termination instanceof AbstractSearch.FixedPositionTarget) {
            this.stepValue = new Coordinate.DistanceComparator(((AbstractSearch.FixedPositionTarget)((Object)this.termination)).getTarget(), false);
        }
        Coordinate c = this.currentPath.getLast();
        ArrayList<Coordinate> li = this.getNextSearchCoordsFor(world, c);
        if (this.stepValue != null) {
            Collections.sort(li, this.stepValue);
        }
        for (Coordinate c2 : li) {
            if (c2.yCoord < 0 || c2.yCoord >= 256 || this.searchedCoords.contains(c2) || this.currentPath.size() > this.depthLimit || !this.limit.isBlockInside(c.xCoord, c.yCoord, c.zCoord) || !this.isValidLocation(world, c2.xCoord, c2.yCoord, c2.zCoord, this.currentPath.getLast())) continue;
            this.currentPath.add(c2);
            if (this.termination.isValidTerminus(world, c2.xCoord, c2.yCoord, c2.zCoord)) {
                this.result.addAll(this.currentPath);
                this.isDone = true;
                return true;
            }
            this.searchedCoords.add(c2);
            return false;
        }
        this.currentPath.removeLast();
        if (this.currentPath.isEmpty()) {
            this.isDone = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public void clear() {
        this.searchedCoords.clear();
        this.currentPath.clear();
        this.result.clear();
        System.gc();
    }

    public static LinkedList<Coordinate> getPath(World world, double x, double y, double z, AbstractSearch.TerminationCondition t, AbstractSearch.PropagationCondition c) {
        DepthFirstSearch s = new DepthFirstSearch(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), c, t);
        while (!s.tick(world)) {
        }
        return s.result.isEmpty() ? null : s.getResult().getPath();
    }
}

