/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.SlicedBlockBlueprint;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.StructuredBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;

public class FilledBlockArray
extends StructuredBlockArray {
    private final HashMap<Coordinate, BlockCheck> data = new HashMap();
    private final HashMap<Coordinate, BlockKey> placementOverrides = new HashMap();
    public static boolean logMismatches;

    public FilledBlockArray(World world) {
        super(world);
    }

    @Override
    public void copyTo(BlockArray copy) {
        super.copyTo(copy);
        if (copy instanceof FilledBlockArray) {
            ((FilledBlockArray)copy).data.putAll(this.data);
            ((FilledBlockArray)copy).placementOverrides.putAll(this.placementOverrides);
        }
    }

    public void loadBlock(int x, int y, int z) {
        this.setBlock(x, y, z, this.world.func_147439_a(x, y, z), this.world.func_72805_g(x, y, z));
    }

    public void loadBlockTo(int x, int y, int z, int xt, int yt, int zt) {
        this.setBlock(xt, yt, zt, this.world.func_147439_a(x, y, z), this.world.func_72805_g(x, y, z));
    }

    public void setBlock(int x, int y, int z, Block id) {
        this.setBlock(x, y, z, new BlockKey(id));
    }

    public void setBlock(int x, int y, int z, Block id, int meta) {
        this.setBlock(x, y, z, new BlockKey(id, meta));
    }

    public void setTile(int x, int y, int z, Block id, int meta, TileEntity te, String ... tags) {
        this.setBlock(x, y, z, new BasicTileEntityCheck(id, meta, te, tags));
    }

    public void setFluid(int x, int y, int z, Fluid f) {
        this.setFluid(x, y, z, f, true, true);
    }

    public void setFluid(int x, int y, int z, Fluid f, boolean needSource, boolean allowSource) {
        super.addBlockCoordinate(x, y, z);
        FluidCheck fc = new FluidCheck(f);
        fc.needsSourceBlock = needSource;
        fc.allowSourceBlock = allowSource;
        this.data.put(new Coordinate(x, y, z), fc);
    }

    public void setBlock(int x, int y, int z, BlockCheck bk) {
        super.addBlockCoordinate(x, y, z);
        this.data.put(new Coordinate(x, y, z), bk);
    }

    public void setEmpty(int x, int y, int z, boolean soft, boolean nonsolid, Block ... exceptions) {
        super.addBlockCoordinate(x, y, z);
        this.data.put(new Coordinate(x, y, z), new EmptyCheck(soft, nonsolid, exceptions));
    }

    public void addEmpty(int x, int y, int z, boolean soft, boolean nonsolid, Block ... exceptions) {
        super.addBlockCoordinate(x, y, z);
        this.addBlockToCoord(new Coordinate(x, y, z), new EmptyCheck(soft, nonsolid, exceptions));
    }

    public void addBlock(int x, int y, int z, Block id) {
        this.addBlock(x, y, z, new BlockKey(id));
    }

    public void addBlock(int x, int y, int z, Block id, int meta) {
        this.addBlock(x, y, z, new BlockKey(id, meta));
    }

    public void addBlock(int x, int y, int z, BlockCheck b) {
        super.addBlockCoordinate(x, y, z);
        this.addBlockToCoord(new Coordinate(x, y, z), b);
    }

    private void addBlock(int x, int y, int z, BlockKey bk) {
        super.addBlockCoordinate(x, y, z);
        this.addBlockToCoord(new Coordinate(x, y, z), bk);
    }

    private void addBlockToCoord(Coordinate c, BlockCheck bk) {
        BlockCheck bc = this.data.get(c);
        if (bc == null || bc instanceof EmptyCheck) {
            MultiKey mk = new MultiKey();
            if (bc != null) {
                mk.add(bc);
            }
            mk.add(bk);
            this.data.put(c, mk);
            bc = mk;
        } else if (bc instanceof BlockKey) {
            MultiKey mk = new MultiKey();
            mk.add(bc);
            mk.add(bk);
            this.data.put(c, mk);
        } else {
            ((MultiKey)bc).add(bk);
        }
    }

    public void setPlacementOverride(int x, int y, int z, Block id, int meta) {
        this.placementOverrides.put(new Coordinate(x, y, z), new BlockKey(id, meta));
    }

    private BlockCheck getBlockKey(int x, int y, int z) {
        return this.data.get(new Coordinate(x, y, z));
    }

    @Override
    public boolean addBlockCoordinate(int x, int y, int z) {
        if (super.addBlockCoordinate(x, y, z)) {
            this.data.put(new Coordinate(x, y, z), BlockKey.getAt((IBlockAccess)this.world, x, y, z));
            return true;
        }
        return false;
    }

    public void place() {
        this.placeExcept(null, 3);
    }

    public void place(int flags) {
        this.placeExcept(null, flags);
    }

    public void placeExcept(Coordinate e, int flags) {
        for (Map.Entry<Coordinate, BlockCheck> et : this.data.entrySet()) {
            Coordinate c = et.getKey();
            if (c.equals(e)) continue;
            BlockKey po = this.placementOverrides.get(c);
            if (po != null) {
                po.place(this.world, c.xCoord, c.yCoord, c.zCoord, flags);
                continue;
            }
            et.getValue().place(this.world, c.xCoord, c.yCoord, c.zCoord, flags);
        }
    }

    public void placeExcept(int flags, PlacementExclusionHook h) {
        for (Map.Entry<Coordinate, BlockCheck> et : this.data.entrySet()) {
            BlockCheck bc;
            Coordinate c = et.getKey();
            if (h.skipPlacement(c, bc = et.getValue())) continue;
            BlockKey po = this.placementOverrides.get(c);
            if (po != null) {
                po.place(this.world, c.xCoord, c.yCoord, c.zCoord, flags);
                continue;
            }
            bc.place(this.world, c.xCoord, c.yCoord, c.zCoord, flags);
        }
    }

    public ItemStack getDisplayAt(int x, int y, int z) {
        BlockCheck bk = this.getBlockKey(x, y, z);
        return bk != null ? bk.getDisplay() : null;
    }

    public boolean hasBlockAt(int x, int y, int z, Block b) {
        return this.hasBlockAt(x, y, z, b, -1);
    }

    public boolean hasBlockAt(int x, int y, int z, Block b, int meta) {
        BlockCheck bc = this.getBlockKey(x, y, z);
        return bc != null ? bc.match(b, meta) : false;
    }

    public boolean matchInWorld() {
        return this.matchInWorld(null);
    }

    public boolean matchInWorld(BlockMatchFailCallback call) {
        if (this.world.field_72995_K) {
            return true;
        }
        for (Coordinate c : this.data.keySet()) {
            int x = c.xCoord;
            int y = c.yCoord;
            int z = c.zCoord;
            BlockCheck bk = this.getBlockKey(x, y, z);
            if (bk.matchInWorld(this.world, x, y, z)) continue;
            if (logMismatches) {
                ReikaJavaLibrary.pConsole(x + "," + y + "," + z + " > Wanted [" + bk.getClass().getSimpleName() + "] " + bk.asBlockKey().blockID.func_149732_F() + ":" + bk.asBlockKey().metadata + ", found " + this.world.func_147439_a(x, y, z).func_149732_F() + "[" + this.world.func_147439_a(x, y, z) + "]:" + this.world.func_72805_g(x, y, z));
            }
            if (call != null) {
                call.onBlockFailure(this.world, x, y, z, bk);
            }
            return false;
        }
        return true;
    }

    public int countErrors() {
        if (this.world.field_72995_K) {
            return 0;
        }
        int ret = 0;
        for (Coordinate c : this.data.keySet()) {
            int x = c.xCoord;
            int y = c.yCoord;
            int z = c.zCoord;
            BlockCheck bk = this.getBlockKey(x, y, z);
            if (bk.matchInWorld(this.world, x, y, z)) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public BlockKey getBlockKeyAt(int x, int y, int z) {
        return this.hasBlock(x, y, z) ? this.data.get(new Coordinate(x, y, z)).asBlockKey() : null;
    }

    public boolean isMultiKey(int x, int y, int z) {
        return this.data.get(new Coordinate(x, y, z)) instanceof MultiKey;
    }

    public MultiKey getMultiKeyAt(int x, int y, int z) {
        if (!this.hasBlock(x, y, z)) {
            return null;
        }
        BlockCheck b = this.data.get(new Coordinate(x, y, z));
        return b instanceof MultiKey ? (MultiKey)b : null;
    }

    public ArrayList<BlockKey> getMultiListAt(int x, int y, int z) {
        if (!this.hasBlock(x, y, z)) {
            return null;
        }
        BlockCheck b = this.data.get(new Coordinate(x, y, z));
        if (b instanceof MultiKey) {
            ArrayList<BlockKey> li = new ArrayList<BlockKey>();
            for (BlockCheck bc : ((MultiKey)b).keys) {
                li.add(bc.asBlockKey());
            }
            return li;
        }
        return ReikaJavaLibrary.makeListFrom(b.asBlockKey());
    }

    @Override
    public Block getBlockAt(int x, int y, int z) {
        return this.hasBlock(x, y, z) ? this.data.get((Object)new Coordinate((int)x, (int)y, (int)z)).asBlockKey().blockID : null;
    }

    @Override
    public int getMetaAt(int x, int y, int z) {
        return this.hasBlock(x, y, z) ? this.data.get((Object)new Coordinate((int)x, (int)y, (int)z)).asBlockKey().metadata : -1;
    }

    @SideOnly(value=Side.CLIENT)
    public TileEntity getTileEntityAt(int x, int y, int z) {
        if (!this.hasBlock(x, y, z)) {
            return null;
        }
        BlockCheck b = this.data.get(new Coordinate(x, y, z));
        return b instanceof BlockCheck.TileEntityCheck ? ((BlockCheck.TileEntityCheck)b).getTileEntity() : null;
    }

    public ItemHashMap<Integer> tally() {
        return this.tally(null);
    }

    public ItemHashMap<Integer> tally(Function<Coordinate, Boolean> validity) {
        ItemHashMap<Integer> map = new ItemHashMap<Integer>();
        for (Map.Entry<Coordinate, BlockCheck> e : this.data.entrySet()) {
            Integer get;
            ItemStack key;
            if (validity != null && !validity.apply(e.getKey()).booleanValue() || !this.count(key = e.getValue().asItemStack())) continue;
            if (Block.func_149634_a((Item)key.func_77973_b()) instanceof BlockStairs) {
                key.func_77964_b(0);
            }
            int has = (get = map.get(key)) != null ? get : 0;
            map.put(key, (Integer)(has + 1));
        }
        return map;
    }

    private boolean count(ItemStack is) {
        if (is == null) {
            return false;
        }
        Item it = is.func_77973_b();
        if (it == null) {
            return false;
        }
        Block b = Block.func_149634_a((Item)it);
        if (ReikaBlockHelper.isLiquid(b) && is.func_77960_j() != (b instanceof BlockFluidFinite ? 8 : 0)) {
            return false;
        }
        return !(it instanceof ItemBlock) || b == null || b.func_149688_o() != Material.field_151579_a;
    }

    @Override
    public void remove(int x, int y, int z) {
        super.remove(x, y, z);
        this.data.remove(new Coordinate(x, y, z));
    }

    @Override
    public BlockArray offset(int x, int y, int z) {
        super.offset(x, y, z);
        HashMap<Coordinate, BlockCheck> map = new HashMap<Coordinate, BlockCheck>();
        for (Coordinate key : this.data.keySet()) {
            int dx = key.xCoord;
            int dy = key.yCoord;
            int dz = key.zCoord;
            map.put(new Coordinate(dx += x, dy += y, dz += z), this.data.get(key));
        }
        this.data.clear();
        this.data.putAll(map);
        this.recalcLimits();
        return this;
    }

    public void populateBlockData() {
        for (int i = 0; i < this.getSize(); ++i) {
            Coordinate c = this.getNthBlock(i);
            int x = c.xCoord;
            int y = c.yCoord;
            int z = c.zCoord;
            Block b = this.world.func_147439_a(x, y, z);
            int meta = this.world.func_72805_g(x, y, z);
            this.setBlock(x, y, z, b, meta);
        }
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    protected BlockArray instantiate() {
        return new FilledBlockArray(this.world);
    }

    @Override
    public void addAll(BlockArray arr) {
        super.addAll(arr);
        if (arr instanceof FilledBlockArray) {
            this.data.putAll(((FilledBlockArray)arr).data);
        }
    }

    public void fillFrom(SlicedBlockBlueprint sbb, int x, int y, int z, ForgeDirection dir) {
        sbb.putInto(this, x, y, z, dir);
    }

    @Override
    public BlockArray rotate90Degrees(int ox, int oz, boolean left) {
        FilledBlockArray b = (FilledBlockArray)super.rotate90Degrees(ox, oz, left);
        for (Coordinate c : this.data.keySet()) {
            BlockCheck bc = this.data.get(c);
            Coordinate c2 = c.rotate90About(ox, oz, left);
            b.data.put(c2, bc);
        }
        return b;
    }

    @Override
    public BlockArray rotate180Degrees(int ox, int oz) {
        FilledBlockArray b = (FilledBlockArray)super.rotate180Degrees(ox, oz);
        for (Coordinate c : this.data.keySet()) {
            BlockCheck bc = this.data.get(c);
            Coordinate c2 = c.rotate180About(ox, oz);
            b.data.put(c2, bc);
        }
        return b;
    }

    @Override
    public void clear() {
        super.clear();
        this.data.clear();
    }

    @Override
    public BlockArray flipX() {
        FilledBlockArray b = (FilledBlockArray)super.flipX();
        for (Coordinate c : this.data.keySet()) {
            BlockCheck bc = this.data.get(c);
            Coordinate c2 = new Coordinate(-c.xCoord, c.yCoord, c.zCoord);
            b.data.put(c2, bc);
        }
        return b;
    }

    @Override
    public BlockArray flipZ() {
        FilledBlockArray b = (FilledBlockArray)super.flipZ();
        for (Coordinate c : this.data.keySet()) {
            BlockCheck bc = this.data.get(c);
            Coordinate c2 = new Coordinate(c.xCoord, c.yCoord, -c.zCoord);
            b.data.put(c2, bc);
        }
        return b;
    }

    public Collection<Coordinate> getAllLocationsOf(BlockCheck key) {
        HashSet<Coordinate> set = new HashSet<Coordinate>();
        for (Coordinate c : this.data.keySet()) {
            BlockCheck bc = this.data.get(c);
            if (!bc.match(key)) continue;
            set.add(c);
        }
        return set;
    }

    public boolean isSpaceEmpty(World world, boolean allowSoft) {
        for (Coordinate c : this.keySet()) {
            Block b = c.getBlock((IBlockAccess)world);
            if (b.isAir((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord) || allowSoft && ReikaWorldHelper.softBlocks((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord)) continue;
            return false;
        }
        return true;
    }

    public void cutToQuarter() {
        int x = this.getMidX();
        int z = this.getMidZ();
        ArrayList<Coordinate> li = new ArrayList<Coordinate>(this.keySet());
        for (Coordinate c : li) {
            if (c.xCoord <= x && c.zCoord <= z) continue;
            this.remove(c.xCoord, c.yCoord, c.zCoord);
        }
    }

    public void cutToCenter() {
        int x = this.getMidX();
        int z = this.getMidZ();
        ArrayList<Coordinate> li = new ArrayList<Coordinate>(this.keySet());
        for (Coordinate c : li) {
            if (c.xCoord == x && c.zCoord == z) continue;
            this.remove(c.xCoord, c.yCoord, c.zCoord);
        }
    }

    public void cutTo(Function<Coordinate, Boolean> func) {
        ArrayList<Coordinate> li = new ArrayList<Coordinate>(this.keySet());
        for (Coordinate c : li) {
            if (func.apply(c).booleanValue()) continue;
            this.remove(c.xCoord, c.yCoord, c.zCoord);
        }
    }

    public static interface PlacementExclusionHook {
        public boolean skipPlacement(Coordinate var1, BlockCheck var2);
    }

    public static interface BlockMatchFailCallback {
        public void onBlockFailure(World var1, int var2, int var3, int var4, BlockCheck var5);
    }

    private static class BasicTileEntityCheck
    implements BlockCheck.TileEntityCheck {
        private final BlockKey block;
        private final Class tileClass;
        private final NBTTagCompound matchTag;
        private WeakReference<TileEntity> tileRef;

        private BasicTileEntityCheck(TileEnum te, String ... tags) {
            this(te.getBlock(), te.getBlockMetadata(), te.getTEClass(), tags);
        }

        private BasicTileEntityCheck(Block b, int meta, Class<? extends TileEntity> c, String ... tags) {
            this.block = new BlockKey(b, meta);
            this.matchTag = new NBTTagCompound();
            this.tileClass = c;
        }

        private BasicTileEntityCheck(Block b, int meta, TileEntity te, String ... tags) {
            this(b, meta, te.getClass(), tags);
            NBTTagCompound tag = new NBTTagCompound();
            te.func_145841_b(tag);
            for (int i = 0; i < tags.length; ++i) {
                NBTBase nbt = tag.func_74781_a(tags[i]);
                if (nbt == null) continue;
                this.matchTag.func_74782_a(tags[i], nbt);
            }
            this.tileRef = new WeakReference<TileEntity>(te);
        }

        @Override
        public ItemStack asItemStack() {
            return new ItemStack(this.block.blockID, 1, this.block.hasMetadata() ? this.block.metadata : 0);
        }

        @Override
        public ItemStack getDisplay() {
            return this.asItemStack();
        }

        @Override
        public boolean match(Block b, int meta) {
            return b == this.block.blockID && (!this.block.hasMetadata() || meta == this.block.metadata);
        }

        @Override
        public boolean matchInWorld(World world, int x, int y, int z) {
            return this.match(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z)) && this.matchTile(world.func_147438_o(x, y, z));
        }

        private boolean matchTile(TileEntity te) {
            if (te == null || te.getClass() != this.tileClass) {
                return false;
            }
            NBTTagCompound tag = new NBTTagCompound();
            te.func_145841_b(tag);
            return ReikaNBTHelper.tagContains(tag, this.matchTag);
        }

        @Override
        public void place(World world, int x, int y, int z, int flags) {
            world.func_147465_d(x, y, z, this.block.blockID, this.block.hasMetadata() ? this.block.metadata : 0, flags);
            TileEntity te = world.func_147438_o(x, y, z);
            if (te != null && te.getClass() == this.tileClass) {
                NBTTagCompound NBT = new NBTTagCompound();
                te.func_145841_b(NBT);
                ReikaNBTHelper.overwriteNBT(NBT, this.matchTag);
                te.func_145839_a(NBT);
            }
        }

        @Override
        public BlockKey asBlockKey() {
            return this.block;
        }

        @Override
        public TileEntity getTileEntity() {
            return (TileEntity)this.tileRef.get();
        }

        public String toString() {
            return this.block.toString() + "; NBT " + this.matchTag;
        }

        @Override
        public boolean match(BlockCheck bc) {
            if (bc instanceof BasicTileEntityCheck) {
                BasicTileEntityCheck bt = (BasicTileEntityCheck)bc;
                return bt.block.equals(this.block) && bt.tileClass == this.tileClass && bt.matchTag.equals((Object)this.matchTag);
            }
            return false;
        }
    }

    public static class EmptyCheck
    implements BlockCheck {
        public final boolean allowNonSolid;
        public final boolean allowSoft;
        private final Collection<Block> exceptions;

        public EmptyCheck(boolean soft, boolean nonsolid, Block ... exc) {
            this.allowNonSolid = nonsolid;
            this.allowSoft = soft;
            this.exceptions = ReikaJavaLibrary.makeListFromArray(exc);
        }

        @Override
        public boolean matchInWorld(World world, int x, int y, int z) {
            Block b = world.func_147439_a(x, y, z);
            if (this.exceptions.contains(b)) {
                return false;
            }
            if (b == Blocks.field_150350_a || b.isAir((IBlockAccess)world, x, y, z)) {
                return true;
            }
            if (this.allowSoft && ReikaWorldHelper.softBlocks((IBlockAccess)world, x, y, z)) {
                return true;
            }
            return this.allowNonSolid && b.func_149668_a(world, x, y, z) == null;
        }

        @Override
        public boolean match(Block b, int meta) {
            if (this.exceptions.contains(b)) {
                return false;
            }
            if (b == Blocks.field_150350_a || b instanceof BlockAir) {
                return true;
            }
            if (this.allowSoft && ReikaWorldHelper.softBlocks(b)) {
                return true;
            }
            return this.allowNonSolid && b.func_149688_o().func_76230_c();
        }

        @Override
        public void place(World world, int x, int y, int z, int flags) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }

        public String toString() {
            return "[Empty]";
        }

        @Override
        public ItemStack asItemStack() {
            return null;
        }

        @Override
        public BlockKey asBlockKey() {
            return new BlockKey(Blocks.field_150350_a);
        }

        @Override
        public ItemStack getDisplay() {
            return null;
        }

        @Override
        public boolean match(BlockCheck bc) {
            if (bc instanceof EmptyCheck) {
                EmptyCheck ec = (EmptyCheck)bc;
                return ec.allowNonSolid == this.allowNonSolid && ec.allowSoft == this.allowSoft && ec.exceptions.equals(this.exceptions);
            }
            return false;
        }
    }

    private static class FluidCheck
    implements BlockCheck {
        public final Fluid fluid;
        public boolean needsSourceBlock = true;
        public boolean allowSourceBlock = true;

        private FluidCheck(Fluid f) {
            if (!f.canBePlacedInWorld()) {
                throw new MisuseException("You cannot require non-placeable fluids!");
            }
            this.fluid = f;
        }

        @Override
        public boolean matchInWorld(World world, int x, int y, int z) {
            return this.match(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
        }

        @Override
        public boolean match(Block b, int meta) {
            boolean fmatch;
            boolean bl = fmatch = ReikaFluidHelper.lookupFluidForBlock(b) == this.fluid;
            if (!fmatch) {
                return false;
            }
            if (this.allowSourceBlock) {
                if (this.needsSourceBlock) {
                    return this.isSource(b, meta);
                }
                return true;
            }
            return !this.isSource(b, meta);
        }

        private boolean isSource(Block b, int meta) {
            return b instanceof BlockFluidFinite ? meta == 7 : meta == 0;
        }

        @Override
        public void place(World world, int x, int y, int z, int flags) {
            world.func_147465_d(x, y, z, this.getBlock(), this.allowSourceBlock ? 0 : 1, flags);
        }

        private Block getBlock() {
            return this.fluid.getBlock();
        }

        @Override
        public ItemStack asItemStack() {
            ItemStack is = ReikaItemHelper.getContainerForFluid(this.fluid);
            return is != null ? is : new ItemStack(this.getBlock());
        }

        @Override
        public BlockKey asBlockKey() {
            return new BlockKey(this.getBlock(), 0);
        }

        @Override
        public ItemStack getDisplay() {
            return new ItemStack(this.getBlock());
        }

        @Override
        public boolean match(BlockCheck bc) {
            return bc instanceof FluidCheck && ((FluidCheck)bc).fluid == this.fluid;
        }
    }

    public static class MultiKey
    implements BlockCheck {
        private ArrayList<BlockCheck> keys = new ArrayList();

        public void add(BlockCheck key) {
            if (!this.keys.contains(key)) {
                this.keys.add(key);
            }
        }

        @Override
        public boolean matchInWorld(World world, int x, int y, int z) {
            for (BlockCheck b : this.keys) {
                if (!b.matchInWorld(world, x, y, z)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean match(Block b, int meta) {
            for (BlockCheck c : this.keys) {
                if (!c.match(b, meta)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void place(World world, int x, int y, int z, int flags) {
            this.keys.get(0).place(world, x, y, z, flags);
        }

        public String toString() {
            return this.keys.toString();
        }

        @Override
        public ItemStack asItemStack() {
            return this.keys.get(0).asItemStack();
        }

        @Override
        public BlockKey asBlockKey() {
            return this.keys.get(0).asBlockKey();
        }

        @Override
        public ItemStack getDisplay() {
            return this.asItemStack();
        }

        @Override
        public boolean match(BlockCheck bc) {
            return bc instanceof MultiKey && ((MultiKey)bc).keys.equals(this.keys);
        }

        public List<BlockCheck> viewKeys() {
            return Collections.unmodifiableList(this.keys);
        }
    }
}

