/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class SlicedBlockBlueprint {
    private int width;
    private int ySize;
    private final ArrayList<Block[][]> IDs = new ArrayList();
    private final ArrayList<int[][]> metadatas = new ArrayList();
    private final ArrayList<Block[][]> antiIDs = new ArrayList();
    private final ArrayList<int[][]> antiMetadatas = new ArrayList();
    private final HashMap<Character, BlockKey> mappings = new HashMap();
    private final HashMap<Character, BlockKey> antiMappings = new HashMap();

    public void addMapping(char c, Block id) {
        this.addMapping(c, id, -1);
    }

    public void addMapping(char c, Block id, int meta) {
        this.verifyArg(c);
        this.mappings.put(Character.valueOf(c), new BlockKey(id, meta));
    }

    public void addAntiMapping(char c, Block id) {
        this.addAntiMapping(c, id, -1);
    }

    public void addAntiMapping(char c, Block id, int meta) {
        this.verifyArg(c);
        this.antiMappings.put(Character.valueOf(c), new BlockKey(id, meta));
    }

    private void verifyArg(char c) {
        if (c == 'x') {
            throw new MisuseException("Character 'x' is reserved for \"don't care\"!");
        }
        if (c == '-') {
            throw new MisuseException("Character '-' is reserved for empty space!");
        }
    }

    public void addSlice(String ... array) {
        int l = array.length;
        for (int i = 0; i < l; ++i) {
            if (i <= 0 || array[i].length() == array[i - 1].length()) continue;
            throw new MisuseException("You must only register properly shaped slices!");
        }
        int w = array[0].length();
        if (l > this.ySize) {
            this.ySize = l;
        }
        if (w > this.width) {
            this.width = w;
        }
        Block[][] ids = new Block[l][w];
        int[][] metas = new int[l][w];
        Block[][] antiids = new Block[l][w];
        int[][] antimetas = new int[l][w];
        for (int i = 0; i < l; ++i) {
            String s = array[i];
            char[] cs = s.toCharArray();
            for (int k = 0; k < cs.length; ++k) {
                char c = cs[k];
                if (c == '-') {
                    ids[i][k] = Blocks.field_150350_a;
                    metas[i][k] = 0;
                    antiids[i][k] = null;
                    antimetas[i][k] = -1;
                    continue;
                }
                if (c == 'x') {
                    ids[i][k] = null;
                    metas[i][k] = -1;
                    antiids[i][k] = null;
                    antimetas[i][k] = -1;
                    continue;
                }
                if (this.mapBlock(c, ids, metas, antiids, antimetas, i, k) || this.antimapBlock(c, ids, metas, antiids, antimetas, i, k)) continue;
                throw new MisuseException("Unspecified mapping '" + c + "'!");
            }
        }
        this.IDs.add(ids);
        this.metadatas.add(metas);
        this.antiIDs.add(antiids);
        this.antiMetadatas.add(antimetas);
    }

    private boolean mapBlock(char c, Block[][] ids, int[][] metas, Block[][] antiids, int[][] antimetas, int i, int k) {
        BlockKey block = this.mappings.get(Character.valueOf(c));
        if (block == null) {
            return false;
        }
        Block id = block.blockID;
        int meta = block.metadata;
        ids[i][k] = id;
        metas[i][k] = meta;
        return true;
    }

    private boolean antimapBlock(char c, Block[][] ids, int[][] metas, Block[][] antiids, int[][] antimetas, int i, int k) {
        BlockKey block = this.antiMappings.get(Character.valueOf(c));
        if (block == null) {
            return false;
        }
        Block id = block.blockID;
        int meta = block.metadata;
        antiids[i][k] = id;
        antimetas[i][k] = meta;
        ids[i][k] = null;
        metas[i][k] = -1;
        return true;
    }

    public int getLength() {
        return this.IDs.size();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.ySize;
    }

    public int getWidth(int slice) {
        return this.IDs.get(slice).length;
    }

    public int getHeight(int slice) {
        return this.IDs.get(slice)[0].length;
    }

    public String getString(int slice) {
        StringBuilder sb = new StringBuilder();
        Block[][] ids = this.IDs.get(slice);
        int[][] metas = this.metadatas.get(slice);
        Block[][] antiids = this.antiIDs.get(slice);
        int[][] antimetas = this.antiMetadatas.get(slice);
        for (int k = 0; k < ids.length; ++k) {
            sb.append("[ ");
            for (int m = 0; m < ids[k].length; ++m) {
                Block id = ids[k][m];
                int meta = metas[k][m];
                Block antiid = antiids[k][m];
                int antimeta = antimetas[k][m];
                sb.append(id + ":" + meta);
                sb.append("\t");
            }
            sb.append(" ]\n");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Size " + this.getLength() + "x" + this.getWidth() + "x" + this.getHeight() + ":\n");
        for (int i = 0; i < this.IDs.size(); ++i) {
            sb.append("{\n");
            sb.append(this.getString(i));
            sb.append("}\n");
        }
        return sb.toString();
    }

    public boolean checkAgainst(World world, int x, int y, int z, int xref, int yref, ForgeDirection plane, int slice, FilledBlockArray.BlockMatchFailCallback call) {
        Block[][] ids = this.IDs.get(slice);
        int[][] metas = this.metadatas.get(slice);
        Block[][] antiids = this.antiIDs.get(slice);
        int[][] antimetas = this.antiMetadatas.get(slice);
        for (int i = 0; i < ids.length; ++i) {
            for (int k = 0; k < ids[i].length; ++k) {
                int dx = plane.offsetX == 0 ? x - xref + i : x;
                int dz = plane.offsetZ == 0 ? z - xref + i : z;
                int dy = y + yref - k;
                Block id = ids[k][i];
                int meta = metas[k][i];
                Block id2 = world.func_147439_a(dx, dy, dz);
                int meta2 = world.func_72805_g(dx, dy, dz);
                if (id == null) {
                    id = antiids[k][i];
                    meta = antimetas[k][i];
                    if (id == null) continue;
                    if (id == id2) {
                        if (call != null) {
                            call.onBlockFailure(world, dx, dy, dz, new FilledBlockArray.EmptyCheck(false, false, new Block[0]));
                        }
                        return false;
                    }
                    if (meta == -1 || meta != meta2) continue;
                    if (call != null) {
                        call.onBlockFailure(world, dx, dy, dz, new FilledBlockArray.EmptyCheck(false, false, new Block[0]));
                    }
                    return false;
                }
                if (id != id2) {
                    if (call != null) {
                        call.onBlockFailure(world, dx, dy, dz, new BlockKey(id, meta));
                    }
                    return false;
                }
                if (meta == -1 || meta == meta2) continue;
                if (call != null) {
                    call.onBlockFailure(world, dx, dy, dz, new BlockKey(id, meta));
                }
                return false;
            }
        }
        return true;
    }

    public SlicedBlockBlueprint copy() {
        SlicedBlockBlueprint cp = new SlicedBlockBlueprint();
        cp.width = this.width;
        cp.ySize = this.ySize;
        cp.IDs.addAll(this.IDs);
        cp.metadatas.addAll(this.metadatas);
        cp.mappings.putAll(this.mappings);
        cp.antiIDs.addAll(this.antiIDs);
        cp.antiMetadatas.addAll(this.antiMetadatas);
        cp.antiMappings.putAll(this.antiMappings);
        return cp;
    }

    public void putInto(FilledBlockArray array, int x, int y, int z, ForgeDirection dir) {
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90(dir);
        for (int slice = 0; slice < this.IDs.size(); ++slice) {
            int dx = x + dir.offsetX * slice;
            Block[][] ids = this.IDs.get(slice);
            int[][] metas = this.metadatas.get(slice);
            for (int k = 0; k < ids.length; ++k) {
                int dz = z + left.offsetZ * k;
                for (int m = 0; m < ids[k].length; ++m) {
                    int dy = y + m;
                    Block id = ids[k][m];
                    if (id == null) continue;
                    int meta = metas[k][m];
                    array.setBlock(dx, dy, dz, id, meta);
                }
            }
        }
    }
}

