/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

public class CachedValue<V> {
    private final ValueCalculator<V> calculator;
    private boolean needsRecalc = true;
    private V value;

    public CachedValue(ValueCalculator<V> c) {
        this.calculator = c;
        this.value = c.calculate();
    }

    public void markDirty() {
        this.needsRecalc = true;
    }

    public V getValue() {
        if (this.needsRecalc) {
            this.value = this.calculator.calculate();
            this.needsRecalc = false;
        }
        return this.value;
    }

    public void setValue(V val) {
        this.value = val;
        this.needsRecalc = false;
    }

    public static interface ValueCalculator<V> {
        public V calculate();
    }
}

